/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.digiwin.smartdata.agiledataengine.exception.CustomException;
import com.digiwin.smartdata.agiledataengine.model.AthenaBasicHttpRequestHead;
import com.digiwin.smartdata.agiledataengine.service.HttpService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service(value="httpService")
public class HttpServiceImpl
implements HttpService {
    @Value(value="${iamApToken}")
    private String appToken;
    @Autowired
    private RestTemplate restTemplate;

    private HttpHeaders processHeaders(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String proxyToken;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("digi-middleware-auth-app", this.appToken);
        httpHeaders.set("digi-middleware-auth-user", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("token", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("client-agent", athenaBasicHttpRequestHead.getClientAgent());
        httpHeaders.set("locale", athenaBasicHttpRequestHead.getLocale());
        httpHeaders.set("locally", String.valueOf(athenaBasicHttpRequestHead.getLocally()));
        MediaType type = MediaType.parseMediaType((String)athenaBasicHttpRequestHead.getContentType());
        httpHeaders.setContentType(type);
        String tenantId = this.getTenantId(url, athenaBasicHttpRequestHead);
        if (StringUtils.hasLength((String)tenantId)) {
            httpHeaders.set("routerKey", tenantId);
        }
        if (StringUtils.hasLength((String)athenaBasicHttpRequestHead.getMessageId())) {
            httpHeaders.set("messageId", athenaBasicHttpRequestHead.getMessageId());
        }
        if (StringUtils.hasLength((String)athenaBasicHttpRequestHead.getSource())) {
            httpHeaders.set("source", athenaBasicHttpRequestHead.getSource());
        }
        if (StringUtils.hasLength((String)(proxyToken = this.getProxyToken(athenaBasicHttpRequestHead)))) {
            httpHeaders.set("digi-proxy-token", proxyToken);
        }
        return httpHeaders;
    }

    private String getTenantId(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String tenantId = athenaBasicHttpRequestHead.getTenantId();
        if (StringUtils.hasLength((String)tenantId)) {
            return tenantId;
        }
        throw new CustomException("API request header tenantId is empty! url\uff1a" + url);
    }

    private String getProxyToken(AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String proxyToken = athenaBasicHttpRequestHead.getProxyToken();
        if (StringUtils.hasLength((String)proxyToken)) {
            return proxyToken;
        }
        return null;
    }

    public <T> ResponseEntity<T> doGet(String url, Class<T> clazz) {
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, HttpEntity.EMPTY, clazz, new Object[0]);
        this.checkResponse(url, responseEntity, "zh_CN");
        return responseEntity;
    }

    public <T> ResponseEntity<T> doGet(String url, ParameterizedTypeReference<T> responseType) {
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, HttpEntity.EMPTY, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, "zh_CN");
        return responseEntity;
    }

    public <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, Class<T> clazz) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, clazz, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, ParameterizedTypeReference<T> responseType) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, ParameterizedTypeReference<T> responseType) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, Class<T> clazz) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, clazz, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, String bodyPayload, Class<T> clazz) {
        HttpEntity requestEntity = new HttpEntity((Object)bodyPayload, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, clazz, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public Map doPostForEntity(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Object bodyPayload, Class clazz) {
        HttpEntity requestEntity = new HttpEntity(bodyPayload, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        Map response = (Map)this.restTemplate.postForObject(url, (Object)requestEntity, clazz, new Object[0]);
        return response;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, String bodyPayload, ParameterizedTypeReference<T> responseType) {
        HttpEntity requestEntity = new HttpEntity((Object)bodyPayload, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, ParameterizedTypeReference<T> responseType) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, ParameterizedTypeReference<T> responseType) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Class<T> clazz) {
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, clazz, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    private void checkResponse(String url, ResponseEntity responseEntity, String locale) {
        if (url.contains("/oauth/oauth/token")) {
            return;
        }
        if (responseEntity.getStatusCode() == HttpStatus.UNAUTHORIZED) {
            throw new Exception("\u767b\u5f55\u8fc7\u671f");
        }
    }

    public <T> ResponseEntity<T> doPost(String url, ParameterizedTypeReference<T> responseType) {
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, HttpEntity.EMPTY, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, "zh_CN");
        return responseEntity;
    }
}

