/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.smartdata.agiledataengine.model.AthenaBasicHttpRequestHead;
import com.digiwin.smartdata.agiledataengine.model.StructureModel;
import com.digiwin.smartdata.agiledataengine.pojo.DigiwinIamUserRole;
import com.digiwin.smartdata.agiledataengine.service.HttpService;
import com.digiwin.smartdata.agiledataengine.service.IamService;
import com.digiwin.smartdata.agiledataengine.util.AESUtils;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import com.digiwin.smartdata.agiledataengine.util.LogUtils;
import com.digiwin.smartdata.agiledataengine.util.RSAUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="iamService")
public class IamServiceImpl
implements IamService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IamServiceImpl.class);
    private final HttpService httpService;

    public IamServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    public String getLanguageByTenantId(String userToken, String tenantId, String locale) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.iam.url") + "/api/iam/v2" + "/tenant/metadata/language";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), Collections.EMPTY_MAP, Map.class);
        return responseEntity.getStatusCode().is2xxSuccessful() ? (String)((Map)responseEntity.getBody()).get("data") : "";
    }

    public List<DigiwinIamUserRole> getUserInRoleList(String userToken, String locale, String tenantId, Map<String, Object> params) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.iam.url") + "/api/iam/v2" + "/association/userinrole/list?roleId=" + params.get("roleId") + "&pageSize=" + params.get("pageSize") + "&pageNum=" + params.get("pageNum");
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), Collections.EMPTY_MAP, (ParameterizedTypeReference)responseType);
            return responseEntity.getStatusCode().is2xxSuccessful() ? JsonUtil.listMapToListT((List)((List)((Map)responseEntity.getBody()).get("list")), DigiwinIamUserRole.class) : Collections.emptyList();
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u89d2\u8272\u4e0b\u7528\u6237\u5217\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DigiwinIamUserRole> getRoleListByUser(String tenantId, String locale, String userToken, String userId) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.iam.url") + "/api/iam/v2" + "/user/role";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("id", userId);
        long start = System.currentTimeMillis();
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), JsonUtil.getJsonString(params), (ParameterizedTypeReference)responseType);
            List list = responseEntity.getStatusCode().is2xxSuccessful() ? JsonUtil.listMapToListT((List)((List)((Map)responseEntity.getBody()).get("roles")), DigiwinIamUserRole.class) : Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u4e0b\u89d2\u8272\u5217\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
        }
        finally {
            LOGGER.info("IamServiceImpl#getRoleListByUser elapse time\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> queryRowDataPermission(String tenantId, String token, String locale, String moduleId, String actionId, String sysId, String prefix, String method) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.iam.url") + "/api/iam/v2" + "/permission/data/row";
        HashMap<String, String> reqMap = new HashMap<String, String>(3);
        reqMap.put("moduleId", moduleId);
        if (StructureModel.METRIC.getModel().equals(method)) {
            reqMap.put("actionId", prefix.concat("_").concat("standardParams"));
        } else {
            reqMap.put("actionId", actionId);
        }
        reqMap.put("sysId", sysId);
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        long start = System.currentTimeMillis();
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, token).setRouterKey((String)DWServiceContext.getContext().getRequestHeader().get("routerKey")), JsonUtil.getJsonString(reqMap), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null) {
                LogUtils.buildAgileDataEngineLog((String)"queryRowDataPermission", (String)LogUtils.SUCCESS, (String)JSON.toJSONString(reqMap), (String)JsonUtil.getJsonString((Object)responseEntity.getBody()), (String)"");
                Map map = (Map)responseEntity.getBody();
                return map;
            }
        }
        catch (Exception e) {
            LogUtils.buildAgileDataEngineLog((String)"queryRowDataPermission", (String)"U.ADE.501.0113", (String)JSON.toJSONString(reqMap), (String)"", (String)"");
        }
        finally {
            LOGGER.info("IamServiceImpl#queryRowDataPermission elapse time\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        }
        return Collections.EMPTY_MAP;
    }

    @Deprecated
    public String getIamUserToken(String tenantId, String username, String password) {
        block4: {
            String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.iam.url") + "/api/iam/v2" + "/identity/login";
            HashMap<String, String> requestEntity = new HashMap<String, String>(3);
            try {
                HashMap<String, String> keyMap = this.getKeyPairMap();
                if (keyMap != null) {
                    String clientPublicKey = keyMap.get("publicKey");
                    String privateKey = keyMap.get("privateKey");
                    String serverPublicKey = this.getServerPublicky(tenantId);
                    String encryptPublicKey = RSAUtils.encryptByPublicKey((String)clientPublicKey, (String)serverPublicKey);
                    String encryptAesKey = this.getAesPublicky(tenantId, encryptPublicKey);
                    String aesKey = new String(RSAUtils.decryptByPrivateKey((byte[])Base64.decodeBase64((String)encryptAesKey), (String)privateKey));
                    String passwordHash = AESUtils.aesEncryptByBase64((String)username, (String)aesKey);
                    requestEntity.put("identityType", "token");
                    requestEntity.put("userId", username);
                    requestEntity.put("passwordHash", passwordHash);
                    requestEntity.put("clientEncryptPublicKey", encryptPublicKey);
                    ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead().setTenantId(tenantId).setRouterKey((String)DWServiceContext.getContext().getRequestHeader().get("routerKey")), JsonUtil.getJsonString(requestEntity), Map.class);
                    if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null) {
                        return (String)((Map)responseEntity.getBody()).get("token");
                    }
                    break block4;
                }
                return null;
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6DMC\u7528\u6237\u6743\u9650:{", (Object)(JSON.toJSONString(requestEntity) + "},\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            }
        }
        return null;
    }

    private String getServerPublicky(String tenantId) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.iam.url") + "/api/iam/v2" + "/identity/publickey";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead().setTenantId(tenantId), new HashMap(), (ParameterizedTypeReference)responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (String)((Map)responseEntity.getBody()).get("publicKey");
        }
        return "";
    }

    private String getAesPublicky(String tenantId, String encryptPublicKey) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.iam.url") + "/api/iam/v2" + "/identity/aeskey";
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("clientEncryptPublicKey", encryptPublicKey);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead().setTenantId(tenantId), JsonUtil.getJsonString(params), Map.class);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (String)((Map)responseEntity.getBody()).get("encryptAesKey");
        }
        return "";
    }

    public HashMap<String, String> getKeyPairMap() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        KeyPair keyPair = generator.generateKeyPair();
        String privateKey = new String(Base64.encodeBase64((byte[])keyPair.getPrivate().getEncoded()));
        String publicKey = new String(Base64.encodeBase64((byte[])keyPair.getPublic().getEncoded()));
        HashMap<String, String> keyMap = new HashMap<String, String>(2);
        keyMap.put("privateKey", privateKey);
        keyMap.put("publicKey", publicKey);
        return keyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getUserPermission(String tenantId, String locale, String userToken, String userId, String sysId) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.iam.url") + "/api/iam/v2" + "/permission/user";
        HashMap<String, String> reqMap = new HashMap<String, String>(3);
        reqMap.put("userId", userId);
        reqMap.put("sysId", sysId);
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        long start = System.currentTimeMillis();
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setRouterKey((String)DWServiceContext.getContext().getRequestHeader().get("routerKey")), JsonUtil.getJsonString(reqMap), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null) {
                LogUtils.buildAgileDataEngineLog((String)"getUserPermission", (String)LogUtils.SUCCESS, (String)JSON.toJSONString(reqMap), (String)JsonUtil.getJsonString(((Map)responseEntity.getBody()).get("data")), (String)"");
                List list = (List)((Map)responseEntity.getBody()).get("data");
                return list;
            }
        }
        catch (Exception e) {
            LogUtils.buildAgileDataEngineLog((String)"getUserPermission", (String)"U.ADE.501.0114", (String)JSON.toJSONString(reqMap), (String)"", (String)"");
        }
        finally {
            LOGGER.info("IamServiceImpl#getUserPermission elapse time\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> queryColDataPermission(String token, String locale, String tenantId, String userId, String sysId, String moduleId, String actionId, Boolean self) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.iam.url") + "/api/iam/v2" + "/permission/data/col";
        HashMap<String, Object> reqMap = new HashMap<String, Object>(3);
        reqMap.put("tenantId", tenantId);
        reqMap.put("userId", userId);
        reqMap.put("sysId", sysId);
        reqMap.put("moduleId", moduleId);
        reqMap.put("actionId", actionId);
        reqMap.put("self", self);
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        long start = System.currentTimeMillis();
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, token).setRouterKey((String)DWServiceContext.getContext().getRequestHeader().get("routerKey")), JsonUtil.getJsonString(reqMap), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null) {
                LogUtils.buildAgileDataEngineLog((String)"queryColDataPermission", (String)LogUtils.SUCCESS, (String)JSON.toJSONString(reqMap), (String)JsonUtil.getJsonString((Object)responseEntity.getBody()), (String)"");
                Map map = (Map)responseEntity.getBody();
                return map;
            }
        }
        catch (Exception e) {
            LogUtils.buildAgileDataEngineLog((String)"queryColDataPermission", (String)"U.ADE.501.2006", (String)JSON.toJSONString(reqMap), (String)"", (String)"");
        }
        finally {
            LOGGER.info("IamServiceImpl#queryColDataPermission elapse time\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        }
        return Collections.emptyMap();
    }
}

