/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.smartdata.agiledataengine.model.AthenaBasicHttpRequestHead;
import com.digiwin.smartdata.agiledataengine.pojo.LmcLog;
import com.digiwin.smartdata.agiledataengine.service.HttpService;
import com.digiwin.smartdata.agiledataengine.service.LmcService;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="lmcService")
public class LmcServiceImpl
implements LmcService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LmcServiceImpl.class);
    @Autowired
    private HttpService httpService;

    public List<LmcLog> getdevLogsByParams(String tenantId, String locale, String pageSize, String pageNum, String userToken, Map<String, Object> params) {
        Long startTime = System.currentTimeMillis();
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"lmcUrl") + "/api/lmc/v1/devlogs?pageSize={pageSize}&pageNum={pageNum}&params={params}";
        HashMap<String, String> uriVariables = new HashMap<String, String>(3);
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("params", JsonUtil.getJsonString(params));
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), uriVariables, (ParameterizedTypeReference)responseType);
            Long endTime = System.currentTimeMillis();
            LOGGER.error("\u8c03\u7528\u65e5\u5fd7\u4e2d\u5fc3\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2");
            return responseEntity.getStatusCode().is2xxSuccessful() ? JsonUtil.listMapToListT((List)((List)((Map)((Map)responseEntity.getBody()).get("data")).get("list")), LmcLog.class) : Collections.emptyList();
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u65e5\u5fd7\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public List<LmcLog> getdevLogsByParamsNoPression(String tenantId, String locale, String pageSize, String pageNum, String userToken, Map<String, Object> params) {
        Long startTime = System.currentTimeMillis();
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"lmcUrl") + "/api/lmc/v1/devlog/es/search?pageSize={pageSize}&pageNum={pageNum}&params={params}";
        HashMap<String, String> uriVariables = new HashMap<String, String>(3);
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("params", JsonUtil.getJsonString(params));
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), uriVariables, (ParameterizedTypeReference)responseType);
            Long endTime = System.currentTimeMillis();
            LOGGER.error("\u8c03\u7528\u65e5\u5fd7\u4e2d\u5fc3\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2");
            return responseEntity.getStatusCode().is2xxSuccessful() ? JsonUtil.listMapToListT((List)((List)((Map)((Map)responseEntity.getBody()).get("data")).get("list")), LmcLog.class) : Collections.emptyList();
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u65e5\u5fd7\u4e2d\u5fc3\u4e0d\u9274\u6743\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }
}

