/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.smartdata.agiledataengine.model.AthenaBasicHttpRequestHead;
import com.digiwin.smartdata.agiledataengine.model.ErrorCodeDto;
import com.digiwin.smartdata.agiledataengine.service.HttpService;
import com.digiwin.smartdata.agiledataengine.service.RecastService;
import com.digiwin.smartdata.agiledataengine.util.HttpClientUtil;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import com.digiwin.smartdata.agiledataengine.util.LogUtils;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

@Service(value="recastService")
public class RecastServiceImpl
implements RecastService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecastServiceImpl.class);
    private final HttpService httpService;

    public RecastServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    public Object getRecastData(Object pullingData, List<Map<String, Object>> recasts, String tenantId, String locale, String userToken, String messageId) {
        String url = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"digiwin.recast.url") + "/restful/service/Recast/execute/";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("data", pullingData);
        params.put("recasts", recasts);
        params.put("locale", locale);
        params.put("userToken", userToken);
        params.put("tenantId", tenantId);
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setMessageId(messageId).setRouterKey((String)DWServiceContext.getContext().getRequestHeader().get("routerKey")), JsonUtil.getJsonString(params), String.class);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody() != null) {
                LogUtils.buildAgileDataEngineLog((String)"getRecastData", (String)LogUtils.SUCCESS, (String)JSON.toJSONString(params), (String)JSON.toJSONString((Object)JsonUtil.getObject((String)((String)responseEntity.getBody())).get((Object)"response")), (String)"");
                return JsonUtil.getObject((String)((String)responseEntity.getBody())).get((Object)"response");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e8c\u6b21\u8ba1\u7b97\u51fa\u9519\uff0c\u5165\u53c2\u6570\u636e\u4e3a\uff1a{},\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)JsonUtil.getJsonString(params), (Object)e.getMessage());
            ErrorCodeDto errorCodeDto = e instanceof HttpClientErrorException ? HttpClientUtil.parseErrorInfo((String)new String(((HttpClientErrorException)((Object)e)).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : (e instanceof HttpServerErrorException ? HttpClientUtil.parseErrorInfo((String)new String(((HttpServerErrorException)((Object)e)).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : new ErrorCodeDto("500", "\u4e8c\u6b21\u8ba1\u7b97\u51fa\u9519"));
            LogUtils.buildAgileDataEngineLog((String)"getRecastData", (String)"U.ADE.501.0120", (String)JSON.toJSONString(params), (String)("\u8bf7\u6c42\u4e8c\u6b21\u8ba1\u7b97\u62a5\u9519\uff0c\u53ef\u80fd\u662f\u8bbe\u8ba1\u5668\u4e8c\u6b21\u89c4\u5219\u914d\u7f6e\u6709\u95ee\u9898\uff0c\u6bd4\u5982\uff1a\u6392\u5e8f\u4e8c\u6b21\u8ba1\u7b97\u89c4\u5219\u4e2d\uff1a\u6392\u5e8f\u5b57\u6bb5\u4e0d\u662f\u8f93\u51fa\u5b57\u6bb5\u4e4b\u4e00\u6216\u8005\u6570\u636e\u6d41\u8f6c\u4e2d\u4e24\u6570\u636e\u96c6join\u64cd\u4f5c\u6ca1\u6709\u5339\u914d\u5404\u81ea\u7684\u5b57\u6bb5\u7b49\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + LogUtils.appendBracket((String)e.getMessage())), (String)"\u8bbe\u8ba1\u5668\u91cd\u65b0\u6821\u9a8c\u4e0b\u8ba1\u7b97\u89c4\u5219,\u5982\u95ee\u9898\u4ecd\u7136\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\u3002");
            LOGGER.error("agiledata_adt_\u8bf7\u6c42\u7684\u56de\u53c2\uff1a{}", (Object)errorCodeDto.getMessage());
        }
        return Collections.EMPTY_MAP;
    }
}

