/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.listener.impl;

import com.digiwin.smartdata.agiledataengine.anylaze.IAnalyzer;
import com.digiwin.smartdata.agiledataengine.exception.CustomException;
import com.digiwin.smartdata.agiledataengine.model.AdeRequest;
import com.digiwin.smartdata.agiledataengine.service.listener.Listener;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import com.rabbitmq.client.Channel;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="adeSnapshotListener")
public class AdeSnapshotListener
implements Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdeSnapshotListener.class);
    @Autowired
    private IAnalyzer analyzer;

    @Override
    @RabbitListener(queues={"athena.event.message.ade"})
    public void listenerAdeQueue(Message message, Channel channel) throws Exception {
        String messageStr = new String(message.getBody(), StandardCharsets.UTF_8);
        AdeRequest request = (AdeRequest)JsonUtil.getObject((String)messageStr, AdeRequest.class);
        LOGGER.info("\u63a5\u6536\u7c7b\u578b\u4e3a[{}]\u7684MQ\u6d88\u606f,\u6d88\u606f\u5b9e\u4f53\u4e3a[{}]", (Object)"snapshot", (Object)messageStr);
        try {
            this.analyzer.doAnalyze(request, "snapshot");
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
        }
        catch (Exception e) {
            if (!(e instanceof CustomException)) {
                channel.basicReject(message.getMessageProperties().getDeliveryTag(), message.getMessageProperties().getRedelivered() == false);
            } else {
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
            }
            LOGGER.error("...............................", (Object)messageStr, (Object)e);
        }
    }

    @Override
    public Map<String, Object> doAnalyze(Object data, Map<String, Object> prevListenerReturn) {
        return prevListenerReturn;
    }
}

