/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.mq;

import com.digiwin.smartdata.agiledataengine.anylaze.IAnalyzer;
import com.digiwin.smartdata.agiledataengine.exception.CustomException;
import com.digiwin.smartdata.agiledataengine.model.AdeRequest;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import com.rabbitmq.client.Channel;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;

public class SnapshotBuildConsumer
implements ChannelAwareMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotBuildConsumer.class);
    private IAnalyzer analyzer;

    public SnapshotBuildConsumer(IAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void onMessage(Message message, Channel channel) throws Exception {
        String messageStr = new String(message.getBody(), StandardCharsets.UTF_8);
        AdeRequest request = (AdeRequest)JsonUtil.getObject((String)messageStr, AdeRequest.class);
        try {
            this.analyzer.doAnalyze(request, "snapshot");
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
        }
        catch (Exception e) {
            if (!(e instanceof CustomException)) {
                channel.basicReject(message.getMessageProperties().getDeliveryTag(), message.getMessageProperties().getRedelivered() == false);
            } else {
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
            }
            LOGGER.error("...............................", (Object)messageStr, (Object)e);
        }
    }
}

