/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.mq;

import com.digiwin.app.common.DWApplicationPropertiesUtils;
import com.digiwin.smartdata.agiledataengine.service.ISnapshotSendProductor;
import com.digiwin.smartdata.agiledataengine.util.StringUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

@Component
public class SnapshotSendProductor
implements ISnapshotSendProductor {
    private static final Logger log = LoggerFactory.getLogger(SnapshotSendProductor.class);
    private RabbitTemplate rabbitTemplate;

    public SnapshotSendProductor(RabbitTemplate template) {
        this.rabbitTemplate = template;
    }

    public Boolean sendDirectMessage(String messageData, String queue) {
        try {
            if (StringUtil.isEmpty((String)queue)) {
                queue = DWApplicationPropertiesUtils.getProperty((String)"application", (String)"agiledataengine.rabbit.connect.queue");
            }
            this.rabbitTemplate.convertAndSend(queue, (Object)messageData);
            log.info("sendDirectMessage\u6d88\u606f\u53d1\u9001\u6210\u529f\uff1a{}", (Object)messageData);
        }
        catch (Exception e) {
            log.error("sendDirectMessage\u53d1\u9001\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public Boolean sendTopicMessage(String messageData) {
        return true;
    }

    public Boolean sendFanoutMessage(String messageData) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("messageId", UUID.randomUUID());
        map.put("messageData", messageData);
        map.put("createTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        try {
            this.rabbitTemplate.convertAndSend(DWApplicationPropertiesUtils.getProperty((String)"application", (String)"agiledataengine.rabbit.connect.exchange"), DWApplicationPropertiesUtils.getProperty((String)"application", (String)"agiledataengine.rabbit.connect.routingKey"), map);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }
}

