/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.schema;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.constant.TransConstant;
import com.digiwin.smartdata.agiledataengine.dto.schema.SchemaTransDto;
import com.digiwin.smartdata.agiledataengine.pojo.bo.DataCenterParamBo;
import com.digiwin.smartdata.agiledataengine.pojo.node.DataCenterFilterNode;
import com.digiwin.smartdata.agiledataengine.pojo.node.FilterNode;
import com.digiwin.smartdata.agiledataengine.pojo.trans.DataDescription;
import com.digiwin.smartdata.agiledataengine.pojo.trans.DataItem;
import com.digiwin.smartdata.agiledataengine.service.schema.ISchemaBuilder;
import com.digiwin.smartdata.agiledataengine.service.schema.ISchemaConvertor;
import com.digiwin.smartdata.agiledataengine.util.ContextUtils;
import com.digiwin.smartdata.agiledataengine.util.DateUtils;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SchemaBuilder
implements ISchemaBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaBuilder.class);

    @Override
    public Map<String, Object> buildQuerySchema(JSONObject querySchema, Map<String, Object> reqData, String actionId, DataDescription dataDescription) {
        JSONObject currentQuerySchema = JsonUtil.getObject((String)JsonUtil.getJsonString((Object)querySchema));
        this.buildDynamicFilters(currentQuerySchema, dataDescription);
        this.buildPermissionFilters(currentQuerySchema, dataDescription);
        this.doParamReplace(reqData, actionId, currentQuerySchema);
        return currentQuerySchema;
    }

    private void doParamReplace(Map<String, Object> reqData, String actionId, JSONObject currentQuerySchema) {
        JSONArray params = currentQuerySchema.getJSONArray("params");
        for (int i = 0; i < params.size(); ++i) {
            JSONObject paramJsonObject = params.getJSONObject(i);
            String inputParamKey = "";
            String inputValue = "";
            if (paramJsonObject.containsKey((Object)"source")) {
                inputParamKey = paramJsonObject.getString("source");
                String interval = paramJsonObject.getString("interval");
                inputValue = (String)reqData.get(inputParamKey);
                if (StringUtils.isNotEmpty((CharSequence)inputValue) && StringUtils.isNotEmpty((CharSequence)interval)) {
                    switch (interval) {
                        case "between-left": {
                            int splitPos = inputValue.indexOf(35);
                            inputValue = inputValue.substring(0, splitPos);
                            break;
                        }
                        case "between-right": {
                            int splitPos = inputValue.indexOf(35) + 1;
                            inputValue = inputValue.substring(splitPos);
                            break;
                        }
                        default: {
                            LOGGER.info("BMDAction:{}\u66ff\u6362\u67e5\u8be2\u53c2\u6570souce:{}\u65f6\u9047\u5230\u672a\u8bc6\u522b\u7684interval:{}", new Object[]{actionId, inputParamKey, interval});
                        }
                    }
                }
                String value = this.getValue(paramJsonObject, inputValue);
                paramJsonObject.put("value", (Object)value);
                paramJsonObject.fluentRemove((Object)"source");
                paramJsonObject.fluentRemove((Object)"interval");
                continue;
            }
            inputParamKey = paramJsonObject.getString("value");
            inputValue = (String)reqData.get(inputParamKey);
            paramJsonObject.put("value", (Object)inputValue);
        }
    }

    @Override
    public Map<String, Object> buildQuerySchemaByNewStrategy(JSONObject querySchema, Map<String, Object> reqData, DataDescription dataDescription) {
        JSONObject currentQuerySchema = JsonUtil.getObject((String)JsonUtil.getJsonString((Object)querySchema));
        if (dataDescription == null) {
            return currentQuerySchema;
        }
        this.buildPermissionFilters(currentQuerySchema, dataDescription);
        JSONObject dynamicSchema = dataDescription.getDynamicSchema();
        JSONObject computeObj = dynamicSchema.getJSONObject("computeList");
        dynamicSchema.forEach((k, v) -> {
            String beanName = (String)TransConstant.CONVERTOR_MAP.get(k);
            if (StringUtils.isNotEmpty((CharSequence)beanName)) {
                ((ISchemaConvertor)ContextUtils.getBean((String)beanName, ISchemaConvertor.class)).convert(new SchemaTransDto(currentQuerySchema, v, computeObj, reqData));
            }
        });
        this.doParamReplace(reqData, "", currentQuerySchema);
        return currentQuerySchema;
    }

    @Override
    public Map<String, Object> buildExportQuerySchema(String querySchema, Map<String, Object> reqData, DataDescription dataDescription) {
        JSONObject currentQuerySchema = JsonUtil.getObject((String)querySchema);
        if (dataDescription == null) {
            return currentQuerySchema;
        }
        this.buildPermissionFilters(currentQuerySchema, dataDescription);
        JSONObject dynamicSchema = dataDescription.getDynamicSchema();
        JSONObject computeObj = dynamicSchema.getJSONObject("computeList");
        dynamicSchema.remove((Object)"computeList");
        dynamicSchema.forEach((k, v) -> {
            if ("filter".equalsIgnoreCase((String)k)) {
                String beanName = (String)TransConstant.CONVERTOR_MAP.get(k);
                ((ISchemaConvertor)ContextUtils.getBean((String)beanName, ISchemaConvertor.class)).convert(new SchemaTransDto(currentQuerySchema, v, computeObj, reqData));
            }
        });
        this.doParamReplace(reqData, "", currentQuerySchema);
        return currentQuerySchema;
    }

    @Override
    public DataCenterParamBo buildDataCenterSchema(DataDescription dataDescription) {
        JSONObject querySchema = this.createBaseQuerySchema();
        querySchema.put("distinct", dataDescription.getDynamicSchema().get((Object)"distinct"));
        JSONObject dynamicSchema = dataDescription.getDynamicSchema();
        JSONObject mappingFields = (JSONObject)dynamicSchema.get((Object)"fieldMapping");
        this.buildDatasetPermission(querySchema, dataDescription.getDatasetPermissions(), mappingFields);
        JSONObject computeObj = dynamicSchema.getJSONObject("computeList");
        dynamicSchema.forEach((k, v) -> {
            String beanName = (String)TransConstant.DATA_CENTER_CONVERTOR_MAP.get(k);
            if (StringUtils.isNotEmpty((CharSequence)beanName)) {
                ((ISchemaConvertor)ContextUtils.getBean((String)beanName, ISchemaConvertor.class)).convert(new SchemaTransDto(querySchema, v, computeObj, (Map)mappingFields));
            }
        });
        JSONArray orderColumns = this.buildOrderColumns(dynamicSchema.getJSONArray("sort"), computeObj, mappingFields);
        return new DataCenterParamBo(querySchema, orderColumns);
    }

    private JSONObject createBaseQuerySchema() {
        JSONObject querySchema = new JSONObject();
        querySchema.put("dataType", (Object)"2");
        querySchema.put("distinct", (Object)"false");
        querySchema.put("dimensions", (Object)new JSONArray());
        querySchema.put("measures", (Object)new JSONArray());
        querySchema.put("filter", (Object)new JSONObject());
        querySchema.put("havingFilters", (Object)new JSONArray());
        querySchema.put("computedFields", (Object)new JSONArray());
        return querySchema;
    }

    private JSONArray buildOrderColumns(JSONArray sort, JSONObject computeObj, JSONObject mappingFields) {
        if (CollectionUtils.isEmpty((Collection)sort)) {
            return new JSONArray();
        }
        JSONArray newSort = new JSONArray();
        sort.forEach(item -> {
            JSONObject jsonObject = (JSONObject)item;
            JSONObject dataObject = jsonObject.getJSONObject("dataObject");
            String field = dataObject.getString("content");
            String contentType = dataObject.getString("contentType");
            if ("calculate".equals(contentType)) {
                JSONArray innerComputeObj = computeObj.getJSONArray(field);
                String function = innerComputeObj.getJSONObject(0).getString("calFunction");
                if (!"AVERAGE,SUM,COUNT,MAX,MIN".contains(function.toUpperCase())) {
                    field = innerComputeObj.getJSONObject(0).getString("newField");
                }
            } else {
                field = mappingFields.getString(field);
            }
            String order = jsonObject.getString("order");
            JSONObject sortSchemaObj = new JSONObject();
            sortSchemaObj.put("field", (Object)field);
            sortSchemaObj.put("type", (Object)order);
            newSort.add((Object)sortSchemaObj);
        });
        return newSort;
    }

    private void buildDatasetPermission(JSONObject querySchema, JSONArray permissions, JSONObject mappingFields) {
        if (CollectionUtils.isEmpty((Collection)permissions)) {
            return;
        }
        JSONArray children = new JSONArray();
        permissions.forEach(permission -> {
            DataCenterFilterNode filterNode = this.processDatasetFilter((JSONObject)permission, mappingFields);
            if (filterNode != null) {
                children.add(JSONObject.toJSON((Object)filterNode));
            }
        });
        JSONObject filter = new JSONObject();
        filter.put("logical", (Object)"and");
        filter.put("children", (Object)children);
        querySchema.put("filter", (Object)filter);
    }

    private DataCenterFilterNode processDatasetFilter(JSONObject filter, JSONObject mappingFields) {
        if (MapUtils.isEmpty((Map)filter)) {
            return null;
        }
        DataCenterFilterNode filterNode = new DataCenterFilterNode();
        String logic = filter.getString("filterType");
        if ("and".equalsIgnoreCase(logic) || "or".equalsIgnoreCase(logic)) {
            filterNode.setLogical(logic);
            JSONArray children = filter.getJSONArray("filterValue");
            for (int i = 0; i < children.size(); ++i) {
                JSONObject child = children.getJSONObject(i);
                DataCenterFilterNode childNode = this.processDatasetFilter(child, mappingFields);
                if (childNode == null) continue;
                filterNode.getChildren().add(childNode);
            }
        } else {
            filterNode.setLeftValue(mappingFields.getString(filter.getString("filterField")));
            filterNode.setOperator(((Integer)TransConstant.DATASET_PERMISSION_FILTER_TYPE_COMPARISON_MAP.get(filter.getString("filterType"))).intValue());
            filterNode.setRightValue(filter.getString("filterValue"));
            filterNode.setRightType("const");
        }
        return filterNode;
    }

    private void buildDynamicFilters(JSONObject querySchema, DataDescription dataDescription) {
        if (dataDescription == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)querySchema.getJSONArray("measures"))) {
            return;
        }
        List items = dataDescription.getDataItems().stream().filter(dataItem -> dataItem.getType().equalsIgnoreCase("string")).collect(Collectors.toList());
        JSONObject showFieldsMapping = querySchema.getJSONObject("showFieldsMapping");
        Map<String, String> newMap = showFieldsMapping.entrySet().stream().collect(Collectors.toMap(entry -> entry.getValue().toString(), entry -> (String)entry.getKey()));
        if (!CollectionUtils.isEmpty(items)) {
            for (DataItem item2 : items) {
                if (!newMap.containsKey(item2.getName())) continue;
                String uuid = UUID.randomUUID().toString();
                JSONObject paramJsonObject = new JSONObject();
                paramJsonObject.put("field", (Object)item2.getName());
                paramJsonObject.put("name", (Object)item2.getName());
                paramJsonObject.put("dataType", (Object)0);
                paramJsonObject.put("releaseFlag", (Object)0);
                paramJsonObject.put("key", (Object)uuid);
                paramJsonObject.put("value", (Object)item2.getName());
                paramJsonObject.put("required", (Object)"0");
                querySchema.getJSONArray("params").add((Object)paramJsonObject);
                JSONObject filterJsonObject = new JSONObject();
                filterJsonObject.put("leftValue", (Object)newMap.get(item2.getName()));
                filterJsonObject.put("operator", (Object)"eq");
                filterJsonObject.put("rightValue", (Object)item2.getName());
                filterJsonObject.put("rightType", (Object)"param");
                filterJsonObject.put("key", (Object)uuid);
                filterJsonObject.put("logical", (Object)"and");
                filterJsonObject.put("children", (Object)new JSONArray());
                querySchema.getJSONObject("filter").getJSONArray("children").add((Object)filterJsonObject);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)dataDescription.getDimensions())) {
            boolean match = dataDescription.getDimensions().stream().anyMatch(item -> newMap.containsKey(item));
            if (match) {
                Map<String, String> map = dataDescription.getDimensions().stream().filter(item -> newMap.get(item) != null).collect(Collectors.toMap(item -> (String)newMap.get(item), item -> item));
                querySchema.getJSONArray("dimensions").stream().filter(o -> !"N".equals(((JSONObject)o).getString("isEnableAggregate"))).filter(o -> ((JSONObject)o).getInteger("dataType") != 7 && ((JSONObject)o).getInteger("dataType") != 1).filter(o -> !map.containsKey(((JSONObject)o).getString("field"))).forEach(o -> ((JSONObject)o).put("defaultValue", (Object)"auto"));
            } else {
                querySchema.getJSONArray("dimensions").stream().filter(o -> !"N".equals(((JSONObject)o).getString("isEnableAggregate"))).filter(o -> ((JSONObject)o).getInteger("dataType") != 7 && ((JSONObject)o).getInteger("dataType") != 1).forEach(o -> ((JSONObject)o).put("defaultValue", (Object)"auto"));
            }
        } else {
            querySchema.getJSONArray("dimensions").stream().filter(o -> !"N".equals(((JSONObject)o).getString("isEnableAggregate"))).filter(o -> ((JSONObject)o).getInteger("dataType") != 7 && ((JSONObject)o).getInteger("dataType") != 1).forEach(o -> ((JSONObject)o).put("defaultValue", (Object)"auto"));
        }
    }

    private void buildPermissionFilters(JSONObject querySchema, DataDescription dataDescription) {
        if (dataDescription == null) {
            return;
        }
        JSONObject showFieldsMapping = querySchema.getJSONObject("showFieldsMapping");
        Map<String, String> mapping = showFieldsMapping.entrySet().stream().collect(Collectors.toMap(entry -> entry.getValue().toString(), entry -> (String)entry.getKey()));
        JSONObject permissions = dataDescription.getPermissions();
        if (!CollectionUtils.isEmpty((Map)permissions)) {
            FilterNode filterNode = this.processFilter(permissions, mapping);
            if (filterNode != null) {
                JSONObject filter = new JSONObject();
                JSONArray children = new JSONArray();
                filter.put("logical", (Object)"and");
                filter.put("children", (Object)children);
                children.add((Object)querySchema.getJSONObject("filter"));
                children.add(JSONObject.toJSON((Object)filterNode));
                querySchema.put("filter", (Object)filter);
            }
        } else if (!CollectionUtils.isEmpty((Collection)dataDescription.getDatasetPermissions())) {
            JSONArray children = new JSONArray();
            dataDescription.getDatasetPermissions().forEach(permission -> {
                FilterNode filterNode = this.processFilter((JSONObject)permission, mapping);
                if (filterNode != null) {
                    children.add(JSONObject.toJSON((Object)filterNode));
                }
            });
            JSONObject filter = new JSONObject();
            filter.put("logical", (Object)"and");
            filter.put("children", (Object)children);
            querySchema.put("filter", (Object)filter);
        }
    }

    private FilterNode processFilter(JSONObject filter, Map<String, String> mapping) {
        FilterNode filterNode = new FilterNode();
        String logic = filter.getString("filterType");
        if ("and".equalsIgnoreCase(logic) || "or".equalsIgnoreCase(logic)) {
            filterNode.setLogical(logic);
            JSONArray children = filter.getJSONArray("filterValue");
            for (int i = 0; i < children.size(); ++i) {
                JSONObject child = children.getJSONObject(i);
                FilterNode childNode = this.processFilter(child, mapping);
                if (childNode == null) continue;
                filterNode.getChildren().add(childNode);
            }
        } else {
            if (!mapping.containsKey(filter.getString("filterField"))) {
                return null;
            }
            filterNode.setLeftValue(mapping.get(filter.getString("filterField")));
            filterNode.setOperator((String)TransConstant.PERMISSION_FILTER_TYPE_COMPARISON_MAP.get(filter.getString("filterType")));
            filterNode.setRightValue(filter.getString("filterValue"));
            filterNode.setRightType("const");
        }
        return filterNode;
    }

    private String getValue(JSONObject paramJsonObject, String val) {
        String method;
        if (val != null) {
            return val;
        }
        if (!paramJsonObject.containsKey((Object)"paramDefault")) {
            LOGGER.warn("\u56fe\u8c31\u4e2d\u7684\u6761\u4ef6\u53c2\u6570\u5e76\u672a\u83b7\u5f97\u4e14\u672a\u8bbe\u5b9adefault\u9ed8\u8ba4\u503c");
            return null;
        }
        JSONObject paramDefault = paramJsonObject.getJSONObject("paramDefault");
        switch (method = paramDefault.getString("method")) {
            case "firstDayOfMonthYearAgo": {
                val = DateUtils.firstDayOfMonthYearAgo((String)"");
                break;
            }
            case "firstDateOfLastMonth": {
                val = DateUtils.getfirstDayOfLastMonth((String)"");
                break;
            }
            case "lastDateOfLastMonth": {
                val = DateUtils.getLastDayOfLastMonth((String)"");
                break;
            }
            case "firstDayOfThisYear": {
                val = DateUtils.firstDayOfThisYear();
                break;
            }
            case "lastDayOfThisYear": {
                val = DateUtils.lastDayOfThisYear();
                break;
            }
            case "firstDateOfMonth": {
                val = DateUtils.firstDayOfThisMonth();
                break;
            }
            case "lastDateOfMonth": {
                val = DateUtils.lastDayOfThisMonth();
                break;
            }
            case "custom": {
                val = paramDefault.getString("value");
                break;
            }
            default: {
                LOGGER.warn("\u672a\u8bc6\u522b\u7684 method \u7c7b\u578b: {}", (Object)method);
            }
        }
        return val;
    }
}

