/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.schema.datacenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.dto.schema.SchemaTransDto;
import com.digiwin.smartdata.agiledataengine.service.schema.AbstractSchemaConvertor;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DataCenterGroupConvertor
extends AbstractSchemaConvertor {
    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        JSONObject querySchema = schemaTransDto.getQuerySchema();
        Object dynamicSchema = schemaTransDto.getDynamicSchema();
        if (dynamicSchema == null) {
            return;
        }
        JSONArray groups = (JSONArray)dynamicSchema;
        if (CollectionUtils.isEmpty((Collection)groups)) {
            return;
        }
        JSONObject mappingFields = (JSONObject)schemaTransDto.getReqData();
        List<JSONObject> exclusionCalNodes = groups.stream().map(o -> (JSONObject)o).filter(item -> !"calculate".equals(item.getString("contentType"))).collect(Collectors.toList());
        this.handleGroup(querySchema, exclusionCalNodes, mappingFields);
    }

    private void handleGroup(JSONObject querySchema, List<JSONObject> exclusionCalNodes, JSONObject mappingFields) {
        exclusionCalNodes.forEach(obj -> {
            String dataType = obj.getString("dataType");
            String content = obj.getString("content");
            JSONObject groupObject = new JSONObject();
            groupObject.put("field", (Object)mappingFields.getString(content));
            groupObject.put("name", (Object)content);
            groupObject.put("dataType", (Object)dataType.toUpperCase());
            if (!this.dimensionsIsExist(querySchema, content)) {
                querySchema.getJSONArray("dimensions").add((Object)groupObject);
            }
        });
    }
}

