/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.schema.datacenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.constant.TransConstant;
import com.digiwin.smartdata.agiledataengine.dto.schema.SchemaTransDto;
import com.digiwin.smartdata.agiledataengine.service.schema.AbstractSchemaConvertor;
import com.digiwin.smartdata.agiledataengine.service.schema.datacenter.compute.IFunctionConvertor;
import com.digiwin.smartdata.agiledataengine.util.ContextUtils;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DataCenterSelectConvertor
extends AbstractSchemaConvertor {
    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        JSONArray selects = (JSONArray)schemaTransDto.getDynamicSchema();
        JSONObject computeObj = schemaTransDto.getComputeObj();
        if (CollectionUtils.isEmpty((Collection)selects)) {
            return;
        }
        JSONObject mappingFields = (JSONObject)schemaTransDto.getReqData();
        selects.forEach(item -> {
            JSONObject select = (JSONObject)item;
            if (this.isAggregateQueryField(select, computeObj)) {
                schemaTransDto.getQuerySchema().put("dataType", (Object)"1");
                schemaTransDto.getQuerySchema().getJSONArray("measures").add((Object)this.genMeasureObj(select, computeObj, mappingFields));
            } else {
                this.handleSelect(schemaTransDto, select, mappingFields);
            }
        });
    }

    private boolean isAggregateQueryField(JSONObject sel, JSONObject computeObj) {
        if (computeObj == null || computeObj.isEmpty()) {
            return false;
        }
        JSONObject dataObject = sel.getJSONObject("dataObject");
        String key = dataObject.getString("content");
        if (!computeObj.containsKey((Object)key)) {
            return false;
        }
        JSONArray computeObjJSONArray = computeObj.getJSONArray(key);
        JSONObject compute = computeObjJSONArray.getJSONObject(0);
        return "AVERAGE,SUM,COUNT,MAX,MIN".contains(compute.getString("calFunction").toUpperCase());
    }

    private void handleSelect(SchemaTransDto schemaTransDto, JSONObject select, JSONObject mappingFields) {
        JSONObject dataObj = select.getJSONObject("dataObject");
        String contentType = dataObj.getString("contentType");
        if (!"calculate".equals(contentType)) {
            String dataType = dataObj.getString("dataType");
            String content = dataObj.getString("content");
            JSONObject groupObject = new JSONObject();
            groupObject.put("field", (Object)mappingFields.getString(content));
            groupObject.put("name", (Object)content);
            groupObject.put("dataType", (Object)dataType.toUpperCase());
            if (!this.dimensionsIsExist(schemaTransDto.getQuerySchema(), content)) {
                schemaTransDto.getQuerySchema().getJSONArray("dimensions").add((Object)groupObject);
            }
        } else {
            String content = dataObj.getString("content");
            JSONArray computeList = schemaTransDto.getComputeObj().getJSONArray(content);
            JSONObject computeItem = computeList.getJSONObject(0);
            computeItem.put("FLAG", (Object)true);
            String calFunction = computeItem.getString("calFunction");
            ((IFunctionConvertor)ContextUtils.getBean((String)calFunction, IFunctionConvertor.class)).convert(computeItem, schemaTransDto);
        }
    }

    private JSONObject genMeasureObj(JSONObject select, JSONObject computeObj, JSONObject mappingFields) {
        JSONObject dataObj = select.getJSONObject("dataObject");
        String content = dataObj.getString("content");
        JSONArray computeList = computeObj.getJSONArray(content);
        JSONObject funObj = computeList.getJSONObject(0);
        funObj.put("FLAG", (Object)true);
        String function = funObj.getString("calFunction");
        String newField = funObj.getString("newField");
        JSONObject measureObj = new JSONObject();
        JSONObject aggregator = new JSONObject();
        aggregator.put("function", TransConstant.AGGREGATOR_FUNCTION_MAP.get(function.toUpperCase()));
        aggregator.put("distinct", (Object)funObj.getBooleanValue("distinct"));
        measureObj.put("aggregator", (Object)aggregator);
        JSONArray params = funObj.getJSONArray("params");
        JSONObject fieldParam = params.getJSONObject(0);
        String field = fieldParam.getString("content");
        String dataType = fieldParam.getString("dataType");
        measureObj.put("field", (Object)mappingFields.getString(field));
        measureObj.put("name", (Object)newField);
        measureObj.put("dataType", (Object)dataType.toUpperCase());
        return measureObj;
    }
}

