/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.schema.datacenter.compute;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.dto.schema.DateFormatDto;
import com.digiwin.smartdata.agiledataengine.dto.schema.SchemaTransDto;
import com.digiwin.smartdata.agiledataengine.service.schema.datacenter.compute.AbstractFunctionConvertor;
import org.springframework.stereotype.Service;

@Service(value="DateFormat")
public class DateFormat
extends AbstractFunctionConvertor {
    @Override
    public void convert(JSONObject computeItem, SchemaTransDto schemaTransDto) {
        JSONObject mappingFields = (JSONObject)schemaTransDto.getReqData();
        JSONArray params = computeItem.getJSONArray("params");
        JSONObject fieldParam = params.getJSONObject(0);
        JSONObject formatParam = params.getJSONObject(1);
        String field = fieldParam.getString("content");
        String newField = computeItem.getString("newField");
        String fieldType = fieldParam.getString("dataType");
        String format = formatParam.getString("content");
        DateFormatDto dateFormatDto = new DateFormatDto(field, format);
        dateFormatDto.setFieldType(fieldType);
        JSONObject computeObject = new JSONObject();
        computeObject.put("field", (Object)newField);
        computeObject.put("dataType", (Object)dateFormatDto.getFieldType().toUpperCase());
        computeObject.put("expression", (Object)this.getExpression(mappingFields.getString(dateFormatDto.getField()), dateFormatDto.getFormat()));
        schemaTransDto.getQuerySchema().getJSONArray("computedFields").add((Object)computeObject);
        JSONObject groupObject = new JSONObject();
        groupObject.put("field", (Object)newField);
        groupObject.put("name", (Object)newField);
        groupObject.put("dataType", (Object)dateFormatDto.getFieldType().toUpperCase());
        if (!this.dimensionsIsExist(schemaTransDto.getQuerySchema(), newField)) {
            schemaTransDto.getQuerySchema().getJSONArray("dimensions").add((Object)groupObject);
        }
    }

    protected String getExpression(String field, String format) {
        switch (format) {
            case "y_M": {
                return "date_format([" + field + "],'%Y-%m')";
            }
            case "y": {
                return "YEAR([" + field + "])";
            }
            case "d": {
                return "DAY([" + field + "])";
            }
            case "W": {
                return "WEEK([" + field + "])";
            }
            case "M": {
                return "date_format([" + field + "],'%c')";
            }
            case "Q": {
                return "CAST(QUARTER([" + field + "]) AS CHAR)";
            }
            case "y_Q": {
                return "CONCAT(YEAR([" + field + "]), '-Q', QUARTER([" + field + "]))";
            }
        }
        return "";
    }
}

