/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.schema.grammar;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.constant.TransConstant;
import com.digiwin.smartdata.agiledataengine.dto.schema.LeftDto;
import com.digiwin.smartdata.agiledataengine.dto.schema.RightDto;
import com.digiwin.smartdata.agiledataengine.dto.schema.SchemaTransDto;
import com.digiwin.smartdata.agiledataengine.pojo.node.FilterNode;
import com.digiwin.smartdata.agiledataengine.service.schema.AbstractSchemaConvertor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilterConvertor
extends AbstractSchemaConvertor {
    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        if (schemaTransDto.getDynamicSchema() == null) {
            return;
        }
        JSONObject filterObj = null;
        filterObj = schemaTransDto.getDynamicSchema() instanceof JSONObject ? (JSONObject)schemaTransDto.getDynamicSchema() : (schemaTransDto.getDynamicSchema() instanceof Map ? JSONObject.parseObject((String)JSONObject.toJSONString((Object)schemaTransDto.getDynamicSchema())) : new JSONObject());
        JSONObject computeObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)schemaTransDto.getComputeObj()));
        JSONObject querySchema = schemaTransDto.getQuerySchema();
        if (MapUtils.isEmpty((Map)filterObj)) {
            return;
        }
        Map<String, String> mapping = this.getReversalShowFieldMapping(querySchema);
        FilterNode filterNode = this.processFilter(filterObj, computeObj, mapping);
        if (filterNode != null) {
            JSONObject filter = new JSONObject();
            JSONArray children = new JSONArray();
            filter.put("logical", (Object)"and");
            filter.put("children", (Object)children);
            children.add((Object)querySchema.getJSONObject("filter"));
            children.add(JSONObject.toJSON((Object)filterNode));
            querySchema.put("filter", (Object)filter);
        }
    }

    private FilterNode processFilter(JSONObject filter, JSONObject computeObj, Map<String, String> mapping) {
        FilterNode filterNode = new FilterNode();
        String logic = filter.getString("logic");
        if (filter.size() > 2) {
            LeftDto leftDto = this.getLeftDto(filter, computeObj);
            RightDto rightDto = this.getRightDto(filter, computeObj);
            if (leftDto == null || rightDto == null) {
                return null;
            }
            if (!mapping.containsKey(leftDto.getLeftField())) {
                return null;
            }
            filterNode.setLeftValue(mapping.get(leftDto.getLeftField()));
            filterNode.setOperator((String)TransConstant.FILTER_TYPE_COMPARISON_MAP.get(filter.getString("operator")));
            filterNode.setRightValue(rightDto.getRightValue());
            filterNode.setRightType(rightDto.getFilterRightType());
            if (StringUtils.isNotEmpty((CharSequence)leftDto.getFunction())) {
                filterNode.setFieldFunctionFlag(true);
                filterNode.setFieldFunctionType(leftDto.getFunction());
                filterNode.setFunctionParams(leftDto.getFunctionParams());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getJSONArray("children"))) {
            filterNode.setLogical(logic);
            JSONArray children = filter.getJSONArray("children");
            for (int i = 0; i < children.size(); ++i) {
                JSONObject child = children.getJSONObject(i);
                FilterNode childNode = this.processFilter(child, computeObj, mapping);
                if (childNode == null) continue;
                filterNode.getChildren().add(childNode);
            }
        }
        return filterNode;
    }

    private RightDto getRightDto(JSONObject filter, JSONObject computeObj) {
        JSONArray rights = filter.getJSONArray("right");
        if (CollectionUtils.isEmpty((Collection)rights)) {
            return null;
        }
        JSONObject rightObj = rights.getJSONObject(0);
        JSONObject dataObject = rightObj.getJSONObject("dataObject");
        if (MapUtils.isEmpty((Map)dataObject)) {
            return null;
        }
        String contentType = dataObject.getString("contentType");
        if (!"const".equals(contentType)) {
            return null;
        }
        List collect = rights.stream().map(item -> (JSONObject)item).map(obj -> obj.getJSONObject("dataObject").getString("content")).collect(Collectors.toList());
        String rightValue = collect.stream().collect(Collectors.joining(","));
        return new RightDto(rightValue, contentType);
    }

    private LeftDto getLeftDto(JSONObject filter, JSONObject computeObj) {
        JSONObject left = filter.getJSONObject("left");
        String contentType = left.getString("contentType");
        String content = left.getString("content");
        if ("calculate".equals(contentType)) {
            JSONArray computeList = computeObj.getJSONArray(content);
            JSONObject compute = computeList.getJSONObject(0);
            String field = compute.getJSONArray("params").getJSONObject(0).getString("content");
            String function = compute.getJSONArray("params").getJSONObject(1).getString("contentType");
            String type = compute.getJSONArray("params").getJSONObject(1).getString("content");
            return new LeftDto(field, contentType, function.toLowerCase(), type);
        }
        return new LeftDto(content, contentType);
    }
}

