/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.schema.grammar;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.dto.schema.DateFormatDto;
import com.digiwin.smartdata.agiledataengine.dto.schema.SchemaTransDto;
import com.digiwin.smartdata.agiledataengine.service.schema.AbstractSchemaConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class GroupConvertor
extends AbstractSchemaConvertor {
    private static final int AGGREGATION_QUERY_TYPE = 1;

    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        JSONObject querySchema = schemaTransDto.getQuerySchema();
        Object dynamicSchema = schemaTransDto.getDynamicSchema();
        int dataType = querySchema.getIntValue("dataType");
        if (dynamicSchema == null) {
            if (1 == dataType) {
                querySchema.getJSONArray("dimensions").stream().filter(o -> !"N".equals(((JSONObject)o).getString("isEnableAggregate"))).forEach(o -> ((JSONObject)o).put("defaultValue", (Object)"auto"));
            }
            return;
        }
        JSONArray groups = null;
        groups = dynamicSchema instanceof JSONArray ? (JSONArray)dynamicSchema : (dynamicSchema instanceof List ? JSONArray.parseArray((String)JSONObject.toJSONString((Object)schemaTransDto.getDynamicSchema())) : new JSONArray());
        if (1 != dataType) {
            this.doComputeList(querySchema, groups, schemaTransDto);
            return;
        }
        if (CollectionUtils.isEmpty((Collection)groups)) {
            querySchema.getJSONArray("dimensions").stream().filter(o -> !"N".equals(((JSONObject)o).getString("isEnableAggregate"))).forEach(o -> ((JSONObject)o).put("defaultValue", (Object)"auto"));
            return;
        }
        Map<String, String> mapping = this.getReversalShowFieldMapping(querySchema);
        boolean fieldMatch = groups.stream().map(o -> (JSONObject)o).filter(item -> "field".equals(item.getString("contentType"))).anyMatch(item -> mapping.containsKey(item.getString("content")));
        if (fieldMatch) {
            Map<String, String> map = groups.stream().map(o -> (JSONObject)o).map(item -> item.getString("content")).filter(item -> mapping.get(item) != null).collect(Collectors.toMap(item -> (String)mapping.get(item), item -> item));
            querySchema.getJSONArray("dimensions").stream().filter(o -> !map.containsKey(((JSONObject)o).getString("field"))).filter(o -> !"N".equals(((JSONObject)o).getString("isEnableAggregate"))).forEach(o -> ((JSONObject)o).put("defaultValue", (Object)"auto"));
        } else {
            querySchema.getJSONArray("dimensions").stream().filter(o -> !"N".equals(((JSONObject)o).getString("isEnableAggregate"))).forEach(o -> ((JSONObject)o).put("defaultValue", (Object)"auto"));
        }
        List<JSONObject> calculateObj = groups.stream().map(o -> (JSONObject)o).filter(item -> "calculate".equals(item.getString("contentType"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(calculateObj)) {
            return;
        }
        JSONObject computeObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)schemaTransDto.getComputeObj()));
        ArrayList dateFormatDtos = new ArrayList();
        calculateObj.forEach(item -> {
            String content = item.getString("content");
            JSONArray computeList = computeObj.getJSONArray(content);
            if (CollectionUtils.isEmpty((Collection)computeList)) {
                return;
            }
            computeList.forEach(o -> {
                JSONObject computeItem = (JSONObject)o;
                String calFunction = computeItem.getString("calFunction");
                if ("DateFormat".equals(calFunction)) {
                    JSONArray params = computeItem.getJSONArray("params");
                    JSONObject fieldParam = params.getJSONObject(0);
                    JSONObject formatParam = params.getJSONObject(1);
                    String field = fieldParam.getString("content");
                    String format = formatParam.getString("content");
                    dateFormatDtos.add(new DateFormatDto(field, format));
                }
            });
        });
        if (CollectionUtils.isEmpty(dateFormatDtos)) {
            return;
        }
        boolean calMatch = dateFormatDtos.stream().anyMatch(o -> mapping.containsKey(o.getField()));
        if (calMatch) {
            Map<String, DateFormatDto> map = dateFormatDtos.stream().filter(item -> mapping.get(item.getField()) != null).collect(Collectors.toMap(item -> (String)mapping.get(item.getField()), item -> item));
            querySchema.getJSONArray("dimensions").stream().filter(o -> map.containsKey(((JSONObject)o).getString("field"))).forEach(o -> ((JSONObject)o).fluentRemove((Object)"defaultValue").fluentPut("dateGranularity", (Object)((DateFormatDto)map.get(((JSONObject)o).getString("field"))).getFormat()));
            if (!fieldMatch) {
                querySchema.getJSONArray("dimensions").stream().filter(o -> !map.containsKey(((JSONObject)o).getString("field"))).filter(o -> !"N".equals(((JSONObject)o).getString("isEnableAggregate"))).forEach(o -> ((JSONObject)o).put("defaultValue", (Object)"auto"));
            }
        }
    }

    private void doComputeList(JSONObject querySchema, JSONArray groups, SchemaTransDto schemaTransDto) {
        List<JSONObject> calculateObj = groups.stream().map(o -> (JSONObject)o).filter(item -> "calculate".equals(item.getString("contentType"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(calculateObj)) {
            return;
        }
        JSONObject computeObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)schemaTransDto.getComputeObj()));
        ArrayList dateFormatDtos = new ArrayList();
        calculateObj.forEach(item -> {
            String content = item.getString("content");
            JSONArray computeList = computeObj.getJSONArray(content);
            if (CollectionUtils.isEmpty((Collection)computeList)) {
                return;
            }
            computeList.forEach(o -> {
                JSONObject computeItem = (JSONObject)o;
                String calFunction = computeItem.getString("calFunction");
                if ("DateFormat".equals(calFunction)) {
                    JSONArray params = computeItem.getJSONArray("params");
                    JSONObject fieldParam = params.getJSONObject(0);
                    JSONObject formatParam = params.getJSONObject(1);
                    String field = fieldParam.getString("content");
                    String format = formatParam.getString("content");
                    dateFormatDtos.add(new DateFormatDto(field, format));
                }
            });
        });
        if (CollectionUtils.isEmpty(dateFormatDtos)) {
            return;
        }
        Map<String, String> mapping = this.getReversalShowFieldMapping(querySchema);
        boolean calMatch = dateFormatDtos.stream().anyMatch(o -> mapping.containsKey(o.getField()));
        if (calMatch) {
            Map<String, DateFormatDto> map = dateFormatDtos.stream().filter(item -> mapping.get(item.getField()) != null).collect(Collectors.toMap(item -> (String)mapping.get(item.getField()), item -> item));
            querySchema.getJSONArray("dimensions").stream().filter(o -> map.containsKey(((JSONObject)o).getString("field"))).forEach(o -> ((JSONObject)o).fluentPut("dateGranularity", (Object)((DateFormatDto)map.get(((JSONObject)o).getString("field"))).getFormat()));
        }
    }
}

