/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.trans;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.smartdata.agiledataengine.metric.model.MetricDebugInfo;
import com.digiwin.smartdata.agiledataengine.metric.model.TemplateReplaceVars;
import com.digiwin.smartdata.agiledataengine.model.AnalysisItem;
import com.digiwin.smartdata.agiledataengine.model.MetricElements;
import com.digiwin.smartdata.agiledataengine.service.analyze.Analyzer;
import com.digiwin.smartdata.agiledataengine.util.CollectionUtil;
import com.digiwin.smartdata.agiledataengine.util.DateTimeUtil;
import com.digiwin.smartdata.agiledataengine.util.LogUtils;
import com.digiwin.smartdata.agiledataengine.util.MapUtils;
import com.digiwin.smartdata.agiledataengine.util.StringReplaceUtil;
import com.github.houbb.opencc4j.util.ZhTwConverterUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionStepConvertToSql {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionStepConvertToSql.class);
    private List<Map<String, Object>> ssList;
    private Map<String, Object> currentStep;
    private Map<String, Map<String, String>> computeList = new HashMap<String, Map<String, String>>();
    private Object solutionSteps;

    public SolutionStepConvertToSql(Object solutionSteps) {
        this.solutionSteps = solutionSteps;
    }

    public String solutionStepConvert() {
        this.ssList = (List)this.solutionSteps;
        if (this.ssList.isEmpty()) {
            return new String("");
        }
        ArrayList sqlObjectList = new ArrayList(this.ssList.size());
        int stepNO = 1;
        for (Map<String, Object> solutionStep : this.ssList) {
            this.currentStep = solutionStep;
            HashMap<String, String> step = new HashMap<String, String>();
            Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format(stepNO == 1 ? "Step %s:" : "\nStep %s:", stepNO)));
            step.put("sql", this.convertQuery(solutionStep, false));
            step.put("stepName", this.currentStep.get("alias").toString());
            ++stepNO;
            sqlObjectList.add(step);
        }
        String sql = "";
        int count = 1;
        for (Object e : sqlObjectList) {
            if (count < sqlObjectList.size()) {
                String tableName = ((Map)e).get("stepName").toString();
                String content = ((Map)e).get("sql").toString();
                content = content.replace("\n", "\n  ");
                sql = sql.concat(String.format("WITH %s AS (\n  %s\n)\n", tableName, content)).replaceFirst(";", "");
            } else {
                sql = sql.concat(((Map)e).get("sql").toString());
            }
            ++count;
        }
        return sql;
    }

    public MetricDebugInfo.SemanticItem convertSemantic(String sqlExpression, Map<String, Object> dataModels, String locale, String GPTExplain) {
        dataModels.putAll(TemplateReplaceVars.getDataModels());
        String originExpression = (String)Analyzer.analyzerTL.get();
        String traditionWord = StringReplaceUtil.replaceString((String)(StringUtils.equals((String)"zh_CN", (String)locale) ? originExpression : ZhTwConverterUtil.toTraditional((String)originExpression)), (Map)MapUtils.mergeMaps(dataModels, (Map)((Map)Analyzer.dataModelTL.get())));
        JSONObject jsonObject = new JSONObject(4);
        jsonObject.put("sqlExpression", (Object)sqlExpression);
        LogUtils.buildAgileDataEngineLog((String)"convertSemantic", (String)LogUtils.SUCCESS, (String)jsonObject.toJSONString(), (String)traditionWord, (String)"");
        new MetricDebugInfo.SemanticItem();
        return MetricDebugInfo.SemanticItem.builder().semanticSql(sqlExpression).semanticSqlDescription(traditionWord).explain4Gpt(GPTExplain).build();
    }

    public List<AnalysisItem> convertStepAnalysis(Map<String, Object> dataModels, String locale) {
        dataModels.putAll(TemplateReplaceVars.getDataModels());
        Map mergeDataModel = Analyzer.dataModelTL.get() != null ? MapUtils.mergeMaps((Map)((Map)Analyzer.dataModelTL.get()), dataModels) : dataModels;
        List<Object> analysisItems = new ArrayList<AnalysisItem>(4);
        try {
            analysisItems = Optional.ofNullable(Analyzer.elementsTL.get()).map(maps -> maps.entrySet().stream().sorted(Comparator.comparingInt(e -> MetricElements.getOrder((String)((String)e.getKey())))).map(entry -> {
                String join = Strings.join((Iterable)((Iterable)entry.getValue()), (char)' ');
                String trimData = StringReplaceUtil.replaceString((String)StringUtils.substringBeforeLast((String)join, (String)";"), (Map)mergeDataModel).trim();
                if (!"condition".equalsIgnoreCase((String)entry.getKey())) {
                    String noConditionData = StringUtils.substringBeforeLast((String)trimData, (String)",").trim();
                    AnalysisItem analysisItem = new AnalysisItem();
                    String conditionName = MetricElements.getNameCN((String)((String)entry.getKey()), (String)locale);
                    analysisItem.setName("group".equalsIgnoreCase((String)entry.getKey()) ? "" : conditionName.concat(": "));
                    analysisItem.setValue("group".equalsIgnoreCase((String)entry.getKey()) ? String.format("\u6309 %s %s", noConditionData, conditionName) : noConditionData);
                    return Arrays.asList(analysisItem);
                }
                List conditionValues = Arrays.stream(trimData.split(";")).map(String::trim).filter(StringUtils::isNotBlank).distinct().map(value -> {
                    AnalysisItem analysisItem = new AnalysisItem();
                    analysisItem.setName("");
                    if (!StringUtils.isEmpty((String)value)) {
                        if (value.contains("\u5f00\u5934\u4ee5")) {
                            value = value.replace("\u5f00\u5934\u4ee5", "\u4ee5") + "\u5f00\u5934";
                        } else if (value.contains("\u7ed3\u5c3e\u4ee5")) {
                            value = value.replace("\u7ed3\u5c3e\u4ee5", "\u4ee5") + "\u7ed3\u5c3e";
                        } else if (value.contains("~") && value.split(": ").length > 1) {
                            String name = value.split(": ")[0];
                            String[] values = value.split(": ")[1].split("~");
                            if (values.length == 2 && values[0].contains("00:00:00") && values[1].contains("23:59:59")) {
                                String endTimePre;
                                String startTimePre;
                                String endTime;
                                String startTime = values[0].trim().split(" ")[0];
                                value = startTime.equals(endTime = values[1].trim().split(" ")[0]) ? startTime : (startTime.contains("-01-01") && endTime.contains("-12-31") ? ((startTimePre = startTime.split("-01-01")[0]).equals(endTimePre = endTime.split("-12-31")[0]) ? startTimePre + "\u5e74" : startTime + "~" + endTime) : ("01".equals(startTime.split("-")[2]) && DateTimeUtil.isMonthLastDay((String)endTime) ? startTime.substring(0, startTime.lastIndexOf("-")) + "~" + endTime.substring(0, endTime.lastIndexOf("-")) : startTime + "~" + endTime));
                                value = name + ": " + value;
                            }
                        }
                    }
                    analysisItem.setValue(value);
                    return analysisItem;
                }).collect(Collectors.toList());
                return conditionValues;
            }).flatMap(Collection::stream).collect(Collectors.toList())).orElse(new ArrayList());
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8f6c\u6362\u6807\u7b7e\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
        }
        return analysisItems;
    }

    public String convertQuery(Map<String, Object> solutionStep, boolean isUnion) {
        String queryName = solutionStep.get("alias").toString();
        this.computeList.put(queryName, this.setComputeList(queryName));
        String sql = String.format("SELECT %s \n FROM %s%s%s%s%s%s", this.convertSelect((List)solutionStep.get("select"), queryName), this.convertFrom(solutionStep, queryName), solutionStep.containsKey("filter") && !CollectionUtil.isEmpty((Map)((Map)solutionStep.get("filter"))) ? "\n" + this.convertWhere((Map)solutionStep.get("filter"), queryName, false) : "", solutionStep.containsKey("groupby") && !CollectionUtil.isEmpty((Collection)((List)solutionStep.get("groupby"))) ? "\n" + this.convertGroup((List)solutionStep.get("groupby"), queryName) : "", solutionStep.containsKey("having") && !CollectionUtil.isEmpty((Map)((Map)solutionStep.get("having"))) ? "\n" + this.convertHaving((Map)solutionStep.get("having"), queryName) : "", solutionStep.containsKey("sort") && !CollectionUtil.isEmpty((Collection)((List)solutionStep.get("sort"))) ? "\n" + this.convertSort((List)solutionStep.get("sort"), queryName) : "", solutionStep.containsKey("limit") && !CollectionUtil.isEmpty((Map)((Map)solutionStep.get("limit"))) ? "\n" + this.convertLimit((Map)solutionStep.get("limit")) : "");
        sql = String.format("%s%s", solutionStep.containsKey("union") && !CollectionUtil.isEmpty((Collection)((List)solutionStep.get("union"))) ? this.convertUnion((List)solutionStep.get("union"), sql) : sql, isUnion ? "" : ";");
        return sql;
    }

    private String getComputeString(String queryName, String contentName) {
        return this.computeList.containsKey(queryName) && this.computeList.get(queryName).containsKey(contentName) ? this.computeList.get(queryName).get(contentName) : "";
    }

    private String convertDataObject(Map<String, Object> schema, String queryName) {
        String sql = "";
        if ("calculate".equals(schema.get("contentType").toString())) {
            String content = schema.get("content").toString();
            sql = this.getComputeString(queryName, content);
        } else if ("const".equals(schema.get("contentType").toString())) {
            sql = sql.concat(schema.get("content").toString());
            if ("string".equals(schema.get("dataType").toString()) || "datetime".equals(schema.get("dataType").toString())) {
                sql = "'".concat(sql).concat("'");
            }
        } else {
            sql = "dateFormat".equals(schema.get("contentType").toString()) ? sql.concat(schema.get("content").toString()) : (schema.containsKey("source") ? String.format("%s.%s", schema.get("source").toString(), schema.get("content").toString()) : schema.get("content").toString());
        }
        return sql;
    }

    private String convertDataObjectForlike(List<Map<String, Object>> schema) {
        String sql = "";
        for (Map<String, Object> step : schema) {
            sql = sql.concat(this.convertDataObjectForlike(step));
        }
        return sql;
    }

    private String convertDataObjectForlike(Map<String, Object> schema) {
        String sql = "";
        if (schema.containsKey("dataObject")) {
            if ("const".equals(((Map)schema.get("dataObject")).get("contentType").toString())) {
                String likeParams = ((Map)schema.get("dataObject")).get("content").toString();
                if ("pm".equals(schema.get("operator"))) {
                    sql = sql.concat("'").concat("%").concat(likeParams).concat("'");
                } else if ("sm".equals(schema.get("operator"))) {
                    sql = sql.concat("'").concat(likeParams).concat("%'");
                } else if ("fm".equals(schema.get("operator"))) {
                    sql = sql.concat("'%").concat(likeParams).concat("%'");
                }
                Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format("'%s'", likeParams)));
                ((Map)Analyzer.elementsTL.get()).computeIfAbsent(MetricElements.CONDITION.name, k -> new ArrayList(4)).add(String.format("'%s'", likeParams));
            }
            if (((Map)schema.get("dataObject")).containsKey("alias")) {
                sql = sql.concat(" AS ").concat(((Map)schema.get("dataObject")).get("alias").toString());
            }
        }
        return sql;
    }

    private String convertDatasetObject(Map<String, Object> schema) {
        String sql = "";
        if (schema.containsKey("metric")) {
            sql = sql.concat(schema.get("metric").toString()).concat("[metric]");
            Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format("\n %s: ${%s}", TemplateReplaceVars.METRIC.getValueDes(), schema.get("metric").toString())));
            List dsEle = ((Map)Analyzer.elementsTL.get()).computeIfAbsent(MetricElements.METRICSOURCE.name, k -> new ArrayList(4));
            String metric = String.format("${%s}", schema.get("metric").toString()).trim();
            if (!dsEle.contains(metric)) {
                dsEle.add(metric);
                dsEle.add(",");
            }
        } else if (schema.containsKey("table")) {
            sql = sql.concat(schema.get("table").toString()).concat("[table]");
        } else if (schema.containsKey("step")) {
            sql = sql.concat(schema.get("step").toString()).concat("[step]");
        } else if (schema.containsKey("subQuery")) {
            sql = sql.concat("(").concat(this.convertQuery((Map)schema.get("subQuery"), false)).concat(")");
        }
        if (schema.containsKey("alias") && !schema.get("alias").toString().isEmpty()) {
            sql = sql.concat(" AS ").concat(schema.get("alias").toString());
        }
        return sql;
    }

    private String convertSelect(List<Map<String, Object>> schema, String queryName) {
        if (schema.size() <= 0) {
            return "";
        }
        String sql = "";
        for (Map<String, Object> selectObject : schema) {
            Map<String, Object> selectUnit = new HashMap();
            String alias = "";
            sql = sql.concat(", ");
            if (selectObject.containsKey("dataObject")) {
                selectUnit = (Map)selectObject.get("dataObject");
                String contentType = (String)selectUnit.get("contentType");
                Map tlMap = Optional.ofNullable(Analyzer.dataModelTL.get()).orElse(new HashMap(8));
                tlMap.put(((String)selectUnit.get("alias")).replaceAll("#", ""), Optional.ofNullable((Map)selectUnit.get("language")).map(i1 -> (Map)i1.get("title")).map(lang -> lang.get(Analyzer.localeTL.get())).orElse(selectUnit.get("title")));
                tlMap.put(((String)selectUnit.get("content")).replaceAll("#", ""), Optional.ofNullable((Map)selectUnit.get("language")).map(i1 -> (Map)i1.get("title")).map(lang -> lang.get(Analyzer.localeTL.get())).orElse(selectUnit.get("title")));
                Analyzer.dataModelTL.set(tlMap);
                sql = sql.concat(this.convertDataObject(selectUnit, queryName));
            } else if (selectObject.containsKey("datasetObject")) {
                selectUnit = (Map)selectObject.get("datasetObject");
                sql = sql.concat("(").concat(this.convertQuery(selectUnit, false)).concat(")");
            }
            if ((alias = (String)selectUnit.get("alias")).isEmpty()) continue;
            sql = sql.concat(" AS ").concat(alias);
        }
        return sql.replaceFirst(", ", "");
    }

    private String convertFrom(Map<String, Object> schema, String queryName) {
        String join = schema.containsKey("join") ? this.convertJoin((List)schema.get("join"), queryName) : "";
        return this.convertDatasetObject((Map)schema.get("datasetObject")) + join;
    }

    private String convertConditions(Map<String, Object> schema, String queryName, boolean rootLevel) {
        String sql = "";
        Integer doubleTimePart = 0;
        if (schema.containsKey("children")) {
            String logicString = schema.get("logic").toString();
            List childrenList = (List)schema.get("children");
            for (Map condition : childrenList) {
                if (!condition.containsKey("children")) {
                    String dataType = (String)((Map)condition.get("left")).get("dataType");
                    String operator = (String)condition.get("operator");
                    sql = sql.concat(String.format(" %s %s", logicString, this.convertSingleCondition(condition, queryName, false, doubleTimePart)));
                    Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format(" ${%s} ", logicString)));
                    if ("datetime".equalsIgnoreCase(dataType) || "date".equalsIgnoreCase(dataType)) {
                        Integer n;
                        Integer n2;
                        if (doubleTimePart == 0 && ("lte".equalsIgnoreCase(operator) || "lt".equalsIgnoreCase(operator))) {
                            n2 = doubleTimePart;
                            n = doubleTimePart = Integer.valueOf(doubleTimePart + 1);
                        }
                        if ((doubleTimePart = Integer.valueOf(doubleTimePart % 2)) != 1) {
                            ((Map)Analyzer.elementsTL.get()).computeIfAbsent(MetricElements.CONDITION.name, k -> new ArrayList(4)).add("~");
                        } else {
                            ((Map)Analyzer.elementsTL.get()).computeIfAbsent(MetricElements.CONDITION.name, k -> new ArrayList(4)).add(";");
                        }
                        n2 = doubleTimePart;
                        n = doubleTimePart = Integer.valueOf(doubleTimePart + 1);
                    } else {
                        ((Map)Analyzer.elementsTL.get()).computeIfAbsent(MetricElements.CONDITION.name, k -> new ArrayList(4)).add(";");
                    }
                }
                String otherSql = "";
                if (condition.containsKey("children") && ((List)condition.get("children")).size() > 0) {
                    otherSql = this.convertConditions(condition, queryName, false);
                }
                if (otherSql.isEmpty()) continue;
                sql = String.format("%s %s %s", sql, logicString, otherSql);
            }
            Analyzer.analyzerTL.set(StringUtils.substringBeforeLast((String)((String)Analyzer.analyzerTL.get()), (String)String.format(" ${%s} ", logicString)));
            sql = sql.replaceFirst(" " + logicString + " ", "");
            if (childrenList.size() > 1 && !rootLevel) {
                sql = String.format("(%s)", sql);
            }
        }
        return sql;
    }

    private String convertSingleCondition(Map<String, Object> schema, String queryName, boolean isJoin, Integer doubleTimePart) {
        String sql = "";
        List conditionEle = ((Map)Analyzer.elementsTL.get()).computeIfAbsent(MetricElements.CONDITION.name, k -> new ArrayList(4));
        boolean isTimeCondition = false;
        if (schema.containsKey("left") && ((Map)schema.get("left")).size() > 0) {
            String dataType = (String)((Map)schema.get("left")).get("dataType");
            String operator = (String)schema.get("operator");
            sql = sql.concat(this.convertDataObject((Map)schema.get("left"), queryName));
            if (!isJoin) {
                Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format("${%s}", (String)((Map)schema.get("left")).get("content")).replaceAll("#", "")));
                if ("datetime".equalsIgnoreCase(dataType) || "date".equalsIgnoreCase(dataType)) {
                    isTimeCondition = true;
                    if (doubleTimePart % 2 != 1) {
                        conditionEle.add(String.format("${%s}:", (String)((Map)schema.get("left")).get("content")).replaceAll("#", ""));
                    }
                    if (doubleTimePart == 0 && ("lte".equalsIgnoreCase(operator) || "lt".equalsIgnoreCase(operator))) {
                        ((Map)Analyzer.elementsTL.get()).computeIfAbsent(MetricElements.CONDITION.name, k -> new ArrayList(4)).addAll(Arrays.asList("-", "~"));
                    }
                } else {
                    conditionEle.add(String.format("${%s}", (String)((Map)schema.get("left")).get("content")).replaceAll("#", ""));
                }
            }
        }
        String opr = "";
        if (schema.containsKey("operator")) {
            opr = schema.get("operator").toString();
            sql = sql.concat(this.convertOperator(opr));
            if (!isJoin) {
                Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format(" %s ", this.convertOperator(opr))));
                if (!isTimeCondition) {
                    String conditionOpr;
                    String oprStr = this.convertOperator(opr);
                    if (opr.equals("in") || opr.equals("nin")) {
                        conditionOpr = opr.equals("in") ? "\u5728" : "\u4e0d\u5728";
                        conditionEle.add(conditionOpr);
                    } else if (opr.equals("is_null")) {
                        conditionOpr = "\u4e3a\u7a7a";
                        conditionEle.add(conditionOpr);
                    } else if (opr.equals("is_not_null")) {
                        conditionOpr = "\u4e0d\u4e3a\u7a7a";
                        conditionEle.add(conditionOpr);
                    } else if (opr.equals("neq")) {
                        conditionOpr = "\u4e0d\u7b49\u4e8e";
                        conditionEle.add(conditionOpr);
                    } else if (opr.equals("pm") || opr.equals("sm")) {
                        conditionOpr = opr.equals("pm") ? "\u5f00\u5934\u4ee5" : "\u7ed3\u5c3e\u4ee5";
                        conditionEle.add(conditionOpr);
                    } else if (opr.equals("fm")) {
                        conditionOpr = "\u5305\u542b";
                        conditionEle.add(conditionOpr);
                    } else {
                        conditionEle.add(String.format("%s", oprStr).trim());
                    }
                }
            }
        }
        if (schema.containsKey("right") && (schema.get("right") instanceof List ? (List<Map>)schema.get("right") : Arrays.asList((Map)schema.get("right"))).size() > 0) {
            if (opr.equals("pm") || opr.equals("sm") || opr.equals("fm")) {
                String likeOprCondition = this.convertDataObjectForlike((List<Map<String, Object>>)(schema.get("right") instanceof List ? (List<Map>)schema.get("right") : Arrays.asList((Map)schema.get("right"))));
                sql = sql.concat(likeOprCondition);
                if (!isJoin) {
                    Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format(" %s ", likeOprCondition)));
                    conditionEle.add(String.format("%s", likeOprCondition.replaceAll("'", "")));
                }
            } else if (opr.equals("in") || opr.equals("nin")) {
                String rightSql = this.rightParam((List<Map<String, Object>>)(schema.get("right") instanceof List ? (List<Map>)schema.get("right") : Arrays.asList((Map)schema.get("right"))), queryName, opr);
                sql = sql.concat(String.format("(%s)", rightSql));
                if (!isJoin) {
                    Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format(" (%s) ", rightSql)));
                    conditionEle.add(String.format("%s", String.format("(%S) ", rightSql.replaceAll("'", ""))));
                }
            } else {
                List<Map<String, Object>> rightListMap = schema.get("right") instanceof List ? (List<Map<String, Object>>)schema.get("right") : Arrays.asList((Map)schema.get("right"));
                String rightPa = this.rightParam(rightListMap, queryName, opr);
                sql = sql.concat(rightPa);
                if (!isJoin) {
                    String rightCondition = Optional.ofNullable(rightListMap).map(mp -> (Map)rightListMap.get(0)).map(dataObj -> (Map)dataObj.get("dataObject")).map(obj -> "const".equalsIgnoreCase((String)obj.get("contentType")) ? (String)obj.get("content") : String.format("${%s}", ((String)obj.get("content")).replaceAll("#", ""))).orElse(rightPa);
                    Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format(" %s ", rightCondition.replaceAll("'", ""))));
                    conditionEle.add(String.format("%s", rightCondition.replaceAll("'", "")));
                }
            }
        }
        return sql;
    }

    private String rightParam(List<Map<String, Object>> right, String queryName, String opr) {
        String sql = "";
        for (Map<String, Object> fieldObj : right) {
            if ("in".equals(opr) || "nin".equals(opr)) {
                sql = sql.concat(", ");
            }
            sql = sql.concat(this.rightParam(fieldObj, queryName));
        }
        if ("in".equals(opr) || "nin".equals(opr)) {
            sql = sql.replaceFirst(", ", "");
        }
        return sql;
    }

    private String rightParam(Map<String, Object> right, String queryName) {
        String sql = "";
        sql = right.containsKey("dataObject") ? this.convertDataObject((Map)right.get("dataObject"), queryName) : (right.containsKey("datasetObject") ? this.convertDatasetObject((Map)right.get("datasetObject")) : (right.containsKey("source") ? String.format("%s.%s", right.get("source").toString(), right.get("content").toString()) : right.get("content").toString()));
        return sql;
    }

    private String convertJoin(List<Map<String, Object>> schema, String queryName) {
        String sql = "";
        for (Map<String, Object> joinUnit : schema) {
            if (joinUnit.containsKey("joinType") && !joinUnit.get("joinType").toString().isEmpty()) {
                sql = sql.concat(" ").concat(joinUnit.get("joinType").toString());
            }
            if (joinUnit.containsKey("datasetObject") && ((Map)joinUnit.get("datasetObject")).size() > 0) {
                sql = sql.concat(" ").concat(this.convertDatasetObject((Map)joinUnit.get("datasetObject")));
            }
            if (!joinUnit.containsKey("on") || ((List)joinUnit.get("on")).size() <= 0) continue;
            List conditionList = (List)joinUnit.get("on");
            sql = sql.concat(" ON ");
            for (Map condition : conditionList) {
                sql = sql.concat(this.convertSingleCondition(condition, queryName, true, 0));
            }
        }
        return sql;
    }

    private String convertWhere(Map<String, Object> schema, String queryName, boolean isHaving) {
        String sql = "";
        if (!schema.isEmpty() && schema.containsKey("children") && !((List)schema.get("children")).isEmpty()) {
            sql = isHaving ? "" : sql.concat("WHERE ");
            Analyzer.analyzerTL.set(isHaving ? Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("") : Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format("\n %s: ", TemplateReplaceVars.WHERE.getValueDes())));
            sql = sql.concat(this.convertConditions(schema, queryName, true));
        }
        return sql;
    }

    private String convertGroup(List<Map<String, Object>> schema, String queryName) {
        String sql = "GROUP BY ";
        Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format("\n %s:", TemplateReplaceVars.GROUP.getValueDes())));
        ArrayList groupCons = Lists.newArrayListWithCapacity((int)8);
        for (Map<String, Object> field : schema) {
            String groupName = this.convertDataObject(field, queryName);
            groupCons.add(String.format("${%s}", field.get("content")).trim().replaceAll("#", ""));
            sql = sql.concat(", ").concat(groupName);
        }
        Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format(" %s", Strings.join((Iterable)groupCons, (char)','))));
        List groupEles = ((Map)Analyzer.elementsTL.get()).computeIfAbsent(MetricElements.GROUP.name, k -> new ArrayList(4));
        groupCons.forEach(item -> {
            if (!groupEles.contains(item)) {
                groupEles.add(item);
                groupEles.add(",");
            }
        });
        sql = sql.replaceFirst(", ", "");
        return sql;
    }

    private String convertHaving(Map<String, Object> schema, String queryName) {
        Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format("\n %s:", TemplateReplaceVars.HAVING.getValueDes())));
        return String.format("HAVING %s", this.convertWhere(schema, queryName, true));
    }

    private String convertSort(List<Map<String, Object>> schema, String queryName) {
        String sql = "ORDER BY";
        Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format("\n %s:", TemplateReplaceVars.SORT.getValueDes())));
        ArrayList sortCons = Lists.newArrayListWithCapacity((int)8);
        for (Map<String, Object> field : schema) {
            Map dataObject = (Map)field.get("dataObject");
            String sortOj = this.convertDataObject(dataObject, queryName);
            sql = sql.concat(String.format(", %s %s", sortOj, field.get("order").toString()));
            String content = (String)dataObject.get("content");
            sortCons.add(String.format(" ${%s} ${%s} ", content.contains("#") ? StringUtils.substringAfterLast((String)content, (String)"#") : content, field.get("order")));
        }
        Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(Strings.join((Iterable)sortCons, (char)',')));
        sql = sql.replaceFirst("ORDER BY,", "ORDER BY");
        return sql;
    }

    private String convertLimit(Map<String, Object> schema) {
        Analyzer.analyzerTL.set(Optional.ofNullable(Analyzer.analyzerTL.get()).orElse("").concat(String.format("\n %s: %s", TemplateReplaceVars.LIMIT.getValueDes(), this.transLimitScript(schema))));
        return String.format("LIMIT %s, %s", schema.containsKey("startPos") ? schema.get("startPos").toString() : "0", schema.get("endPos").toString());
    }

    private String transLimitScript(Map<String, Object> schema) {
        String startStr = schema.containsKey("startPos") ? schema.get("startPos").toString() : "0";
        String endStr = schema.containsKey("endPos") ? schema.get("endPos").toString() : "\u7ed3\u675f";
        return String.format("\u53d6%s\u5230%s", String.format("\u7b2c%s\u7b14", NumberUtils.createNumber((String)startStr).intValue() + 1), NumberUtils.isNumber((String)endStr) ? String.format("\u7b2c%s\u7b14", NumberUtils.createNumber((String)endStr).intValue() + 1) : endStr);
    }

    private String convertUnion(List<Map<String, Object>> schema, String sql) {
        String resSql = "";
        if (schema.size() > 0) {
            resSql = String.format("(%s)", sql);
        }
        for (Map<String, Object> union : schema) {
            resSql = resSql.concat(String.format("\n%s\n(%s)", union.get("unionType").toString(), this.convertQuery((Map)union.get("subQuery"), true)));
        }
        return resSql;
    }

    private String convertOperator(String opt) {
        String str = "";
        switch (opt) {
            case "eq": {
                str = " = ";
                break;
            }
            case "is_null": {
                str = " is null";
                break;
            }
            case "is_not_null": {
                str = " is not null";
                break;
            }
            case "neq": {
                str = " <> ";
                break;
            }
            case "lt": {
                str = " < ";
                break;
            }
            case "lte": {
                str = " <= ";
                break;
            }
            case "gt": {
                str = " > ";
                break;
            }
            case "gte": {
                str = " >= ";
                break;
            }
            case "in": {
                str = " in ";
                break;
            }
            case "nin": {
                str = " NOT IN ";
                break;
            }
            case "pm": {
                str = " START LIKE ";
                break;
            }
            case "fm": {
                str = " LIKE ";
                break;
            }
            case "sm": {
                str = " END LIKE ";
                break;
            }
            default: {
                str = "<<< unknown operator: " + opt + " >>>";
            }
        }
        return str;
    }

    private Map<String, String> setComputeList(String queryName) {
        if (!this.currentStep.containsKey("computeList")) {
            return new HashMap<String, String>();
        }
        Map computeMap = (Map)this.currentStep.get("computeList");
        HashMap<String, String> computeList = new HashMap<String, String>();
        for (Map.Entry entry : computeMap.entrySet()) {
            String paramName = (String)entry.getKey();
            List computeSteps = (List)entry.getValue();
            computeList.put(paramName, this.convertComputeSteps(computeSteps, queryName, paramName));
        }
        return computeList;
    }

    private String convertComputeSteps(List<Object> computeSteps, String queryName, String paramName) {
        String sql = "";
        for (Object computeStep : computeSteps) {
            Map step = (Map)computeStep;
            String computeFunc = step.get("calFunction").toString();
            ArrayList<String> paramStrings = new ArrayList<String>();
            List params = Optional.ofNullable((List)step.get("params")).orElse(new ArrayList(0));
            Map overParams = Optional.ofNullable((Map)step.get("overParams")).orElse(new HashMap(0));
            Map tlMap = Optional.ofNullable(Analyzer.dataModelTL.get()).orElse(new HashMap(8));
            if (!tlMap.containsKey(paramName)) {
                tlMap.put(paramName, params.size() > 0 ? "${".concat((String)((Map)params.get(0)).get("content")).concat("}") : ((Map)computeStep).get("newField"));
                Analyzer.dataModelTL.set(tlMap);
            }
            for (Map param : params) {
                paramStrings.add(this.convertDataObject(param, queryName));
            }
            if (CollectionUtil.isNotEmpty((Map)overParams)) {
                paramStrings.addAll(this.convertRowNumber(overParams, queryName));
            }
            sql = sql.concat(this.convertFunctions(computeFunc, paramStrings));
        }
        return sql;
    }

    private String convertFunctions(String computeFunc, List<String> paramStrings) {
        String str = "";
        switch (computeFunc) {
            case "GrowthRate": {
                str = String.format("(%s - %s) / %s", paramStrings.get(0), paramStrings.get(1), paramStrings.get(1));
                break;
            }
            case "Add": {
                str = String.format("%s + %s", paramStrings.get(0), paramStrings.get(1));
                break;
            }
            case "Minus": {
                str = String.format("%s - %s", paramStrings.get(0), paramStrings.get(1));
                break;
            }
            case "Multiply": {
                str = String.format("%s * %s", paramStrings.get(0), paramStrings.get(1));
                break;
            }
            case "Divide": {
                str = String.format("%s / %s", paramStrings.get(0), paramStrings.get(1));
                break;
            }
            case "Abs": {
                str = String.format("ABS(%s)", paramStrings.get(0));
                break;
            }
            case "Sum": {
                str = String.format("SUM(%s)", paramStrings.get(0));
                break;
            }
            case "Avg": {
                str = String.format("AVG(%s)", paramStrings.get(0));
                break;
            }
            case "Count": {
                str = String.format("COUNT(%s)", paramStrings.get(0));
                break;
            }
            case "Max": {
                str = String.format("MAX(%s)", paramStrings.get(0));
                break;
            }
            case "Min": {
                str = String.format("MIN(%s)", paramStrings.get(0));
                break;
            }
            case "Stddev": {
                str = String.format("STDDEV(%s)", paramStrings.get(0));
                break;
            }
            case "DateFormat": {
                str = this.convertDateFormat(paramStrings.get(0), paramStrings.get(1));
                break;
            }
            case "RowNumber": {
                str = String.format("RowNumber() OVER{ %s }", Strings.join(paramStrings, (char)' '));
                break;
            }
            default: {
                str = "<<< unknown function: " + computeFunc + " >>>";
            }
        }
        return str;
    }

    private String convertDateFormat(String paramString, String formatString) {
        if ("Q".equals(formatString)) {
            return "QUARTER('" + paramString + "')";
        }
        if ("y_Q".equals(formatString)) {
            return "QUARTER('" + paramString + "')";
        }
        if ("W".equals(formatString)) {
            return "WEEK('" + paramString + "', 0)";
        }
        if ("y_W".equals(formatString)) {
            return "WEEK('" + paramString + "', 0)";
        }
        String formatStr = "";
        formatStr = formatString.startsWith("y") ? formatString.replaceAll("y", "%y") : (formatString.startsWith("M") ? formatString.replaceAll("M", "%m") : (formatString.startsWith("d") ? formatString.replaceAll("d", "%d") : (formatString.startsWith("H") ? formatString.replaceAll("H", "%H") : formatString.replaceAll("_M", "-%m").replaceAll("_d", "-%d").replaceAll("_H", " %H").replaceAll("_m", ":%i").replaceAll("_s", ":%s"))));
        return String.format("DATE_FORMAT(%s, '%s')", paramString, formatStr);
    }

    private Collection<? extends String> convertRowNumber(Map<String, Object> overParams, String queryName) {
        ArrayList strs = Lists.newArrayList();
        List orderByMap = (List)overParams.get("orderBy");
        strs.add("order by");
        strs.add(this.convertDataObject(Optional.ofNullable(orderByMap).map(ls -> (Map)ls.get(0)).map(itme -> (Map)itme.get("dataObject")).orElse(new HashMap(2)), queryName));
        strs.add(Optional.ofNullable(orderByMap).map(ls -> (Map)ls.get(0)).map(itme -> (String)itme.get("order")).orElse(" "));
        return strs;
    }
}

