/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.service.trans.impl;

import com.digiwin.smartdata.agiledataengine.dto.trans.element.GroupElement;
import com.digiwin.smartdata.agiledataengine.dto.trans.element.MicroTrans;
import com.digiwin.smartdata.agiledataengine.dto.trans.element.Statistic;
import com.digiwin.smartdata.agiledataengine.dto.trans.element.StepElement;
import com.digiwin.smartdata.agiledataengine.service.trans.ITransSchemaBuilder;
import com.digiwin.smartdata.agiledataengine.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TransSchemaBuilder
implements ITransSchemaBuilder {
    @Override
    public MicroTrans buildTransByRecast(List<Map<String, Object>> recasts) {
        MicroTrans microTrans = new MicroTrans();
        ArrayList<StepElement> stepElements = new ArrayList<StepElement>();
        int stepIndex = 0;
        stepElements.add(StepElement.buildSpread((String)("spread_" + ++stepIndex)));
        stepElements.add(StepElement.buildTruncateKey((String)("truncateKey_" + stepIndex)));
        ArrayList<Object> newRecasts = new ArrayList();
        if (!CollectionUtils.isEmpty(recasts)) {
            TreeMap<Integer, Map<String, Object>> orderedRecastMap = new TreeMap<Integer, Map<String, Object>>();
            for (Map<String, Object> recast : recasts) {
                String type = (String)recast.get("name");
                int index = "filter,measure,distinct,calculate,having,sort,limit,seqNo,choose".indexOf(type);
                if (index == -1) continue;
                orderedRecastMap.put(index, recast);
            }
            newRecasts = new ArrayList(orderedRecastMap.values());
        }
        List<String> fields = new ArrayList<String>(8);
        for (Map<String, Object> recast : newRecasts) {
            String name = (String)recast.get("name");
            if (("filter".equals(name) || "measure".equals(name) || "having".equals(name) || "sort".equals(name) || "limit".equals(name)) && (recast.get("condition") == null || recast.get("condition") instanceof List && CollectionUtils.isEmpty((Collection)((Collection)recast.get("condition"))) || recast.get("condition") instanceof Map && CollectionUtils.isEmpty((Map)((Map)recast.get("condition"))))) continue;
            if ("filter".equals(name)) {
                stepElements.add(StepElement.buildFilter((String)("filter_" + ++stepIndex), (Map)((Map)recast.get("condition"))));
                continue;
            }
            if ("measure".equals(name)) {
                TransSchemaBuilder.buildDistinctField(fields, (Map)recast.get("condition"));
                stepElements.add(StepElement.buildGroup((String)("group_" + ++stepIndex), (Map)((Map)recast.get("condition"))));
                if (CollectionUtils.isEmpty(fields)) continue;
                stepElements.add(StepElement.buildDistinct((String)("distinct_" + ++stepIndex), fields));
                continue;
            }
            if ("distinct".equals(name)) {
                fields = (List)recast.get("fields");
                stepElements.add(StepElement.buildDistinct((String)("distinct_" + ++stepIndex), fields));
                continue;
            }
            if ("calculate".equals(name)) {
                if (recast.get("rule") == null || CollectionUtils.isEmpty((Collection)((Collection)recast.get("rule")))) continue;
                stepElements.add(StepElement.buildCalculate((String)("calculate_" + ++stepIndex), (List)((List)recast.get("rule"))));
                continue;
            }
            if ("having".equals(name)) {
                stepElements.add(StepElement.buildHaving((String)("having_" + ++stepIndex), (Map)((Map)recast.get("condition"))));
                continue;
            }
            if ("sort".equals(name)) {
                stepElements.add(StepElement.buildGroup((String)("group-sort_" + ++stepIndex), (Map)((Map)recast.get("condition"))));
                continue;
            }
            if ("limit".equals(name)) {
                stepElements.add(StepElement.buildGroup((String)("group-limit_" + ++stepIndex), (Map)((Map)recast.get("condition"))));
                continue;
            }
            if ("seqNo".equals(name)) {
                stepElements.add(StepElement.buildGroup((String)("group-seqNo_" + ++stepIndex), (Map)((Map)recast.get("condition"))));
                continue;
            }
            if (!"choose".equals(name) || recast.get("fields") == null || recast.get("fields") instanceof Map || recast.get("fields") instanceof List && CollectionUtils.isEmpty((Collection)((Collection)recast.get("fields")))) continue;
            stepElements.add(StepElement.buildChoose((String)("group-choose_" + ++stepIndex), (String)((String)recast.get("type")), (List)((List)recast.get("fields"))));
        }
        microTrans.setStep(stepElements);
        microTrans.setOrder(MicroTrans.buildOrderListByStepList(stepElements));
        return microTrans;
    }

    private static void buildDistinctField(List<String> fields, Map<String, Object> conditions) {
        GroupElement groupElement = (GroupElement)JsonUtil.getObject((String)JsonUtil.getJsonString(conditions), GroupElement.class);
        fields.addAll(groupElement.getFields());
        List statistics = groupElement.getStatistics();
        for (Statistic statistic : statistics) {
            if (!"count".equals(statistic.getStatisticalMethod()) && !"sum".equals(statistic.getStatisticalMethod()) && !"average".equals(statistic.getStatisticalMethod()) && !"min".equals(statistic.getStatisticalMethod()) && !"max".equals(statistic.getStatisticalMethod())) continue;
            fields.add(statistic.getNewField());
        }
    }
}

