/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.smartdata.agiledataengine.trans;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.smartdata.agiledataengine.trans.CronModel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class CronUtil {
    public static List<String> getCronNextTimes(String cronExpress, Integer num) {
        if (StrUtil.isEmpty((CharSequence)cronExpress)) {
            throw new RuntimeException("cron \u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CronSequenceGenerator.isValidExpression((String)cronExpress)) {
            throw new RuntimeException("cron \u8868\u8fbe\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e,cron: " + cronExpress);
        }
        if (num == null || num == 0) {
            num = 1;
        }
        ArrayList<String> list = new ArrayList<String>();
        CronTriggerImpl cronTrigger = new CronTriggerImpl();
        try {
            cronTrigger.setCronExpression(cronExpress);
        }
        catch (ParseException e) {
            throw new RuntimeException("cron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e,cron: " + cronExpress);
        }
        List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTrigger, null, (int)num);
        String format = "yyyy-MM-dd HH:mm:ss";
        for (Date date : dates) {
            list.add(DateUtil.format((Date)date, (String)format));
        }
        return list;
    }

    public static String createCronExpression(CronModel cronModel) {
        StringBuilder cronExp = new StringBuilder();
        if (null == cronModel.getJobType()) {
            System.out.println("\u6267\u884c\u5468\u671f\u672a\u914d\u7f6e");
        }
        if (null != cronModel.getSecond() && null != cronModel.getMinute() && null != cronModel.getHour()) {
            cronExp.append(cronModel.getSecond()).append(" ");
            cronExp.append(cronModel.getMinute()).append(" ");
            cronExp.append(cronModel.getHour()).append(" ");
            if (cronModel.getJobType().getValue() == 1) {
                if (cronModel.getBeApart() != null) {
                    cronExp.append("1");
                    cronExp.append("/");
                    cronExp.append(cronModel.getBeApart() + 1);
                    cronExp.append(" ");
                    cronExp.append("* ");
                    cronExp.append("?");
                } else {
                    cronExp.append("* ");
                    cronExp.append("* ");
                    cronExp.append("?");
                }
            } else if (cronModel.getJobType().getValue() == 3) {
                cronExp.append("? ");
                cronExp.append("* ");
                String[] weeks = cronModel.getDayOfWeeks();
                for (int i = 0; i < weeks.length; ++i) {
                    if (i == 0) {
                        cronExp.append(weeks[i]);
                        continue;
                    }
                    cronExp.append(",").append(weeks[i]);
                }
            } else if (cronModel.getJobType().getValue() == 2) {
                String[] days = cronModel.getDayOfMonths();
                for (int i = 0; i < days.length; ++i) {
                    if (i == 0) {
                        if ("32".equals(days[i])) {
                            String endMouthCron = "0 0 0 L * ?";
                            return endMouthCron;
                        }
                        cronExp.append(days[i]);
                        continue;
                    }
                    cronExp.append(",").append(days[i]);
                }
                cronExp.append(" * ");
                cronExp.append("?");
            } else if (cronModel.getJobType().getValue() == 4) {
                Object[] days = cronModel.getDayOfMonths();
                if (ArrayUtil.isEmpty((Object[])days)) {
                    cronExp.append("*");
                } else {
                    for (int i = 0; i < days.length; ++i) {
                        if (i == 0) {
                            cronExp.append((String)days[i]);
                            continue;
                        }
                        cronExp.append(",").append((String)days[i]);
                    }
                }
                Object[] months = cronModel.getMonths();
                if (ArrayUtil.isEmpty((Object[])months)) {
                    cronExp.append(" *");
                } else {
                    for (int i = 0; i < months.length; ++i) {
                        Object month = months[i];
                        if (Integer.valueOf((String)month) > 12) {
                            throw new RuntimeException("\u6708\u4efd\u6570\u636e\u5f02\u5e38: " + Arrays.toString(months));
                        }
                        if (i == 0) {
                            cronExp.append(" ").append((String)month);
                            continue;
                        }
                        cronExp.append(",").append((String)month);
                    }
                }
                cronExp.append(" ?");
            } else if (cronModel.getJobType().getValue() == 0) {
                cronExp.append("* ");
                cronExp.append("* ");
                cronExp.append("?");
            }
        }
        return cronExp.toString();
    }

    public static String createDescription(CronModel cronModel) {
        StringBuffer description = new StringBuffer("");
        if (null != cronModel.getSecond() && null != cronModel.getMinute() && null != cronModel.getHour()) {
            if (cronModel.getJobType().getValue() == 1) {
                Integer beApart = cronModel.getBeApart();
                if (beApart != null) {
                    description.append("\u6bcf\u95f4\u9694").append(beApart).append("\u5929");
                } else {
                    description.append("\u6bcf\u5929");
                }
                description.append(cronModel.getHour()).append("\u65f6");
                description.append(cronModel.getMinute()).append("\u5206");
                description.append(cronModel.getSecond()).append("\u79d2");
                description.append("\u6267\u884c");
            } else if (cronModel.getJobType().getValue() == 3) {
                if (cronModel.getDayOfWeeks() != null && cronModel.getDayOfWeeks().length > 0) {
                    String days = "";
                    for (String i : cronModel.getDayOfWeeks()) {
                        days = days + "\u5468" + i;
                    }
                    description.append("\u6bcf\u5468\u7684").append(days).append(" ");
                }
                if (null != cronModel.getSecond() && null != cronModel.getMinute() && null != cronModel.getHour()) {
                    description.append(",");
                    description.append(cronModel.getHour()).append("\u65f6");
                    description.append(cronModel.getMinute()).append("\u5206");
                    description.append(cronModel.getSecond()).append("\u79d2");
                }
                description.append("\u6267\u884c");
            } else if (cronModel.getJobType().getValue() == 2) {
                if (cronModel.getDayOfMonths() != null && cronModel.getDayOfMonths().length > 0) {
                    String days = "";
                    for (String i : cronModel.getDayOfMonths()) {
                        days = days + i + "\u53f7";
                    }
                    description.append("\u6bcf\u6708\u7684").append(days).append(" ");
                }
                description.append(cronModel.getHour()).append("\u65f6");
                description.append(cronModel.getMinute()).append("\u5206");
                description.append(cronModel.getSecond()).append("\u79d2");
                description.append("\u6267\u884c");
            }
        }
        return description.toString();
    }

    public static String createLoopCronExpression(int rate, int cycle) {
        String cron = "";
        switch (rate) {
            case 0: {
                cron = "0/" + cycle + " * * * * ?";
                break;
            }
            case 1: {
                cron = "0 0/" + cycle + " * * * ?";
                break;
            }
            case 2: {
                cron = "0 0 0/" + cycle + " * * ?";
                break;
            }
            case 3: {
                cron = "0 0 0 1/" + cycle + " * ?";
                break;
            }
            case 4: {
                cron = "0 0 0 1 1/" + cycle + " ? ";
                break;
            }
            case 5: {
                cron = "0 0 " + cycle + "  * * ?";
                break;
            }
            default: {
                cron = "0/1 * * * * ?";
            }
        }
        return cron;
    }
}

