/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8;

import com.kingbase8.KBProperty;
import com.kingbase8.dispatcher.core.ConnectionMangerV2;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.util.Base64;
import com.kingbase8.util.ExpressionProperties;
import com.kingbase8.util.GT;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.SharedTimer;
import com.kingbase8.util.TraceLogger;
import com.kingbase8.util.URLCoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Driver
implements java.sql.Driver {
    private static final Logger PARENT_KBLOGGER = Logger.getLogger("com.kingbase8");
    private static Driver registeredDriver;
    public static AtomicLong ttotal;
    private static SharedTimer sharedTimer;
    private static boolean isDebug;
    private static final String DEFAULT_PORT = "54321";
    private Properties defaultPropertiesT;

    private synchronized Properties getDefaultPropertiesT() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.defaultPropertiesT != null) {
            return this.defaultPropertiesT;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.defaultPropertiesT = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return Driver.this.loadDefaultProperties_();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw (IOException)privilegedActionException.getException();
        }
        return this.defaultPropertiesT;
    }

    private Properties loadDefaultProperties_() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Properties mergedPros = new Properties();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBProperty.USER.set(mergedPros, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "Can't find our classloader for the Driver; attempt to use the system class loader", new Object[0]);
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (classLoader == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.WARNING, "Can't find a classloader for the Driver; not loading driver configuration from com/kingbase8/driverconfig.propes", new Object[0]);
            return mergedPros;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBLOGGER.log(Level.FINE, "Loading driver configuration via classloader {0}", classLoader);
        ArrayList<URL> urlList = new ArrayList<URL>();
        Enumeration<URL> urlEnumT = classLoader.getResources("com/kingbase8/driverconfig.propes");
        while (urlEnumT.hasMoreElements()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            urlList.add(urlEnumT.nextElement());
        }
        for (int j = urlList.size() - 1; j >= 0; --j) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            URL url = (URL)urlList.get(j);
            KBLOGGER.log(Level.FINE, "Loading driver configuration from: {0}", url);
            InputStream inputStream = url.openStream();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            mergedPros.load(inputStream);
            inputStream.close();
        }
        return mergedPros;
    }

    @Override
    public Connection connect(String urlStr, Properties infoProps) throws SQLException {
        Properties defaultsPros;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (urlStr == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new SQLException("url is null");
        }
        if (!urlStr.startsWith("jdbc:kingbase8:")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        try {
            defaultsPros = this.getDefaultPropertiesT();
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Error loading default settings from driverconfig.propes", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties properties = new Properties(defaultsPros);
        if (infoProps != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Enumeration<?> enumeration = infoProps.propertyNames();
            while (enumeration.hasMoreElements()) {
                Object propertyName = enumeration.nextElement();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object propValue = infoProps.get(propertyName.toString());
                if (propValue == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new KSQLException(GT.tr("Properties for the driver contains a non-string _value for the _key ", new Object[0]) + propertyName, KSQLState.UNEXPECTED_ERROR);
                }
                properties.setProperty(propertyName.toString(), propValue.toString());
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        properties = Driver.parseURL(urlStr, properties);
        if (properties == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        try {
            String passwordEncryptionT;
            if (KBProperty.CONFIGUREPATH.get(properties) != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    properties = Driver.initJDBCCONF(properties);
                }
                catch (Exception e) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBLOGGER.log(Level.SEVERE, "initJDBCCONF Exception: " + e.getMessage(), new Object[0]);
                    throw new KSQLException(GT.tr(e.getMessage(), new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)e);
                }
            }
            if ((passwordEncryptionT = KBProperty.PASSWORD_ENCRYPTION.get(properties)) != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String password = properties.getProperty("password");
                if (password != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (passwordEncryptionT.equalsIgnoreCase("base64")) {
                        properties.setProperty("password", new String(Base64.decode(password), "UTF-8"));
                    }
                }
            }
            this.setupLoggerFromProperties_(properties);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.INFO, "Connecting with URL: {0}", urlStr);
            long _timeout = Driver._timeout(properties);
            if (_timeout <= 0L) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Driver.makeConnection(urlStr, properties);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ConnectThread ct = new ConnectThread(urlStr, properties);
            Thread thread = new Thread((Runnable)ct, "Kingbase8 JDBC driver _connection thread");
            thread.setDaemon(true);
            thread.start();
            return ct.getResult(_timeout);
        }
        catch (KSQLException exception) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "Connection _error: ", exception);
            throw exception;
        }
        catch (AccessControlException accessControlException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Your security policy has prevented the _connection from being attempted.  You probably need to grant the _connect java.net.SocketPermission to the database server _host and port that you wish to _connect to.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)accessControlException);
        }
        catch (Exception exception) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "Unexpected _connection _error: ", exception);
            throw new KSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)exception);
        }
    }

    public static Properties initJDBCCONF(Properties pros) throws Exception {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Properties p = Driver.loadPropertyFiles(KBProperty.CONFIGUREPATH.get(pros), pros);
        return p;
    }

    public static Properties loadPropertyFiles(String name, Properties pros) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Properties p = new Properties(pros);
        File f = Driver.getFile(name);
        if (!f.exists()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException("Configuration file " + f.getAbsolutePath() + " does not exist. Consider adding it to specify db _host and login");
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            p.load(new FileInputStream(f));
        }
        catch (IOException ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ex.printStackTrace();
        }
        return p;
    }

    public static File getFile(String name) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (name == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("null file name is not expected");
        }
        if (name.startsWith("/")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new File(name);
        }
        return new File(System.getProperty("user.dir"), name);
    }

    private void setupLoggerFromProperties_(Properties properties) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!isDebug) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String driverLogLevel = KBProperty.LOGGER_LEVEL.get(properties);
            ExpressionProperties exprPropst = new ExpressionProperties(properties, System.getProperties());
            String driverLogFile = KBProperty.KBLOGGER_FILE.get(exprPropst);
            if (driverLogFile != null && !driverLogFile.contains(".log")) {
                System.err.println("Failed to open log : The file extension needs to end whit .log, log file:" + driverLogFile + ".");
                return;
            }
            isDebug = KBLOGGER.setDebugStatus(driverLogLevel, driverLogFile);
        }
    }

    private static Connection makeConnection(String url, Properties pros) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        AtomicLong t1 = new AtomicLong(System.currentTimeMillis());
        boolean useDispatch = KBProperty.USEDISPATCH.getBoolean(pros);
        if (useDispatch) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            DispatchConnection dis_con = ConnectionMangerV2.createConnection(url, pros.getProperty("password", ""), Driver.database(pros), pros);
            AtomicLong t2 = new AtomicLong(System.currentTimeMillis() - t1.get());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.INFO, "this _connect consume time:::" + t2.get() + "(ms)", new Object[0]);
            KBLOGGER.log(Level.INFO, "ALL _connect consume time:::" + ttotal.addAndGet(t2.get()) + "(ms)", new Object[0]);
            return dis_con;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KbConnection _con = new KbConnection(Driver._hostSpecs(pros), Driver.user(pros), Driver.database(pros), pros, url);
        if (KBLOGGER.isLoggable(Level.INFO)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            AtomicLong t2 = new AtomicLong(System.currentTimeMillis() - t1.get());
            KBLOGGER.log(Level.INFO, "this _connect consume time:::" + t2.get() + "(ms)", new Object[0]);
            KBLOGGER.log(Level.INFO, "ALL _connect consume time:::" + ttotal.addAndGet(t2.get()) + "(ms)", new Object[0]);
        }
        return _con;
    }

    @Override
    public boolean acceptsURL(String urlStr) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Driver.parseURL(urlStr, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String urlStr, Properties infoProps) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Properties copyProps = new Properties(infoProps);
        Properties parseProps = Driver.parseURL(urlStr, copyProps);
        if (null != parseProps) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            copyProps = parseProps;
        }
        KBProperty[] knownProps = KBProperty.values();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        DriverPropertyInfo[] driverPropertyInfos = new DriverPropertyInfo[knownProps.length];
        for (int i = 0; i < driverPropertyInfos.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            driverPropertyInfos[i] = knownProps[i].toDriverPropertyInfo(copyProps);
        }
        return driverPropertyInfos;
    }

    @Override
    public int getMajorVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Override
    public int getMinorVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 0;
    }

    @Deprecated
    public static String getVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String DriverFullName = "Kingbase8 JDBC Driver V008R006B05280926";
        return DriverFullName;
    }

    @Override
    public boolean jdbcCompliant() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean v = false;
        return v;
    }

    public static Properties parseURL(String urlStr, Properties defaultsPros) {
        String[] argsT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Properties urlProperties = new Properties(defaultsPros);
        String urlServerT = urlStr;
        String urlArgs = "";
        int qPosT = urlStr.indexOf(63);
        if (qPosT != -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            urlServerT = urlStr.substring(0, qPosT);
            urlArgs = urlStr.substring(qPosT + 1);
        }
        if (!urlServerT.startsWith("jdbc:kingbase8:")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "JDBC URL must start with \"jdbc:kingbase8:\" but was: {0}", urlStr);
            return null;
        }
        if ((urlServerT = urlServerT.substring("jdbc:kingbase8:".length())).startsWith("//")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            urlServerT = urlServerT.substring(2);
            int slashT = urlServerT.indexOf(47);
            if (slashT == -1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBLOGGER.log(Level.WARNING, "JDBC URL must contain a / at the end of the _host or port: {0}", urlStr);
                return null;
            }
            urlProperties.setProperty("DBNAME", URLCoder.decode(urlServerT.substring(slashT + 1)));
            String[] addressesT = urlServerT.substring(0, slashT).split(",");
            StringBuilder _hosts = new StringBuilder();
            StringBuilder portsSB = new StringBuilder();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (String address : addressesT) {
                int portIdx = address.lastIndexOf(58);
                if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    String portStr = address.substring(portIdx + 1);
                    try {
                        int portT = Integer.parseInt(portStr);
                        if (portT < 1 || portT > 65535) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            KBLOGGER.log(Level.WARNING, "JDBC URL port: {0} not valid (1:65535) ", portStr);
                            return null;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.WARNING, "JDBC URL invalid port number: {0}", portStr);
                        return null;
                    }
                    portsSB.append(portStr);
                    _hosts.append(address.subSequence(0, portIdx));
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    portsSB.append(DEFAULT_PORT);
                    _hosts.append(address);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                portsSB.append(',');
                _hosts.append(',');
            }
            portsSB.setLength(portsSB.length() - 1);
            _hosts.setLength(_hosts.length() - 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            urlProperties.setProperty("PORT", portsSB.toString());
            urlProperties.setProperty("HOST", _hosts.toString());
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (defaultsPros == null || !defaultsPros.containsKey("PORT")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                urlProperties.setProperty("PORT", DEFAULT_PORT);
            }
            if (defaultsPros == null || !defaultsPros.containsKey("HOST")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                urlProperties.setProperty("HOST", "localhost");
            }
            if (defaultsPros == null || !defaultsPros.containsKey("DBNAME")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                urlProperties.setProperty("DBNAME", URLCoder.decode(urlServerT));
            }
        }
        for (String tokenStr : argsT = urlArgs.split("&")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (tokenStr.isEmpty()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                continue;
            }
            int pos = tokenStr.indexOf(61);
            if (pos == -1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                urlProperties.setProperty(tokenStr, "");
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            urlProperties.setProperty(tokenStr.substring(0, pos), URLCoder.decode(tokenStr.substring(pos + 1)));
        }
        return urlProperties;
    }

    public static HostSpec[] _hostSpecs(Properties pros) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String[] _hosts = pros.getProperty("HOST").split(",");
        String[] ports = pros.getProperty("PORT").split(",");
        HostSpec[] _hostSpecs = new HostSpec[_hosts.length];
        for (int i = 0; i < _hostSpecs.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _hostSpecs[i] = new HostSpec(_hosts[i], Integer.parseInt(ports[i]));
        }
        return _hostSpecs;
    }

    public static String user(Properties properties) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return properties.getProperty("user", "");
    }

    public static String database(Properties properties) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return properties.getProperty("DBNAME", "");
    }

    private static long _timeout(Properties properties) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _timeout = KBProperty.LOGIN_TIMEOUT.get(properties);
        if (_timeout != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                return (long)(Float.parseFloat(_timeout) * 1000.0f);
            }
            catch (NumberFormatException numberFormatException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBLOGGER.log(Level.WARNING, "Couldn't parse loginTimeout _value: {0}", _timeout);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> callCls, String functionNameStr) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callCls.getName() + "." + functionNameStr), KSQLState.NOT_IMPLEMENTED.getState());
    }

    @Override
    public Logger getParentLogger() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return PARENT_KBLOGGER;
    }

    public static SharedTimer getSharedTimer() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return sharedTimer;
    }

    public static boolean isRegistered() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null != registeredDriver;
    }

    public static void register() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (Driver.isRegistered()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        Driver registeredDriverT = new Driver();
        DriverManager.registerDriver(registeredDriverT);
        registeredDriver = registeredDriverT;
    }

    public static void deregister() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!Driver.isRegistered()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() mtd)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    static {
        ttotal = new AtomicLong(0L);
        sharedTimer = new SharedTimer();
        isDebug = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Driver.register();
        }
        catch (SQLException sqlException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new ExceptionInInitializerError(sqlException);
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties pros;
        private Connection _result;
        private Throwable _resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties pros) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.url = url;
            this.pros = pros;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable _error;
            Connection _conn;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _conn = Driver.makeConnection(this.url, this.pros);
                _error = null;
            }
            catch (Throwable t) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _conn = null;
                _error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.abandoned) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (_conn != null) {
                        try {
                            _conn.close();
                        }
                        catch (SQLException e) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        }
                    }
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this._result = _conn;
                    this._resultException = _error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long _timeout) throws SQLException {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long expiry = System.nanoTime() / 1000L + _timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                while (true) {
                    if (this._result != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return this._result;
                    }
                    if (this._resultException != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (this._resultException instanceof SQLException) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this._resultException.fillInStackTrace();
                            throw (SQLException)this._resultException;
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throw new KSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), KSQLState.UNEXPECTED_ERROR, this._resultException);
                    }
                    long delayTime = expiry - System.nanoTime() / 1000L;
                    if (delayTime <= 0L) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.abandoned = true;
                        throw new KSQLException(GT.tr("Connection attempt timed out.", new Object[0]), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.wait(delayTime);
                    }
                    catch (InterruptedException ie) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to _connect.", new Object[0]));
                    }
                }
            }
        }
    }
}

