/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.ServerVersion;
import com.kingbase8.jdbc.CompatibleDB;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.logging.Level;

public class Utils {
    private static final Charset utf8Charset = Charset.forName("UTF-8");

    public static String toHexString(byte[] data) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder sbu = new StringBuilder(data.length * 2);
        for (byte element : data) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append(Integer.toHexString(element >> 4 & 0xF));
            sbu.append(Integer.toHexString(element & 0xF));
        }
        return sbu.toString();
    }

    public static byte[] _encodeUTF8(String str) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return str.getBytes(utf8Charset);
    }

    public static byte[] encode(String str, String _encoding) throws UnsupportedEncodingException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return str.getBytes(_encoding);
    }

    public static StringBuilder escapeLiteral(StringBuilder s_buf, String _value, boolean standardConformingStrings) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s_buf == null) {
            s_buf = new StringBuilder((_value.length() + 10) / 10 * 11);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Utils.doAppendEscapedLiteral(s_buf, _value, standardConformingStrings);
        return s_buf;
    }

    private static void doAppendEscapedLiteral(Appendable s_buf, String _value, boolean standardConformingStrings) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (standardConformingStrings) {
                for (int i = 0; i < _value.length(); ++i) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    char chr = _value.charAt(i);
                    if (chr == '\u0000') {
                        throw new KSQLException(GT.tr("Zero _bytes may not occur in string _parameters.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (chr == '\'') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        s_buf.append('\'');
                    }
                    s_buf.append(chr);
                }
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                for (int i = 0; i < _value.length(); ++i) {
                    char chr = _value.charAt(i);
                    if (chr == '\u0000') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throw new KSQLException(GT.tr("Zero _bytes may not occur in string _parameters.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (chr == '\\' || chr == '\'') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        s_buf.append(chr);
                    }
                    s_buf.append(chr);
                }
            }
        }
        catch (IOException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)e);
        }
    }

    public static StringBuilder escapeIdentifier(StringBuilder s_buf, String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s_buf == null) {
            s_buf = new StringBuilder(2 + (_value.length() + 10) / 10 * 11);
        }
        Utils.doAppendEscapedIdentifier(s_buf, _value, '\"');
        return s_buf;
    }

    public static StringBuilder escapeIdentifier(StringBuilder s_buf, String _value, String compatibleLevel, boolean containsANSIQuotes) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s_buf == null) {
            s_buf = new StringBuilder(2 + (_value.length() + 10) / 10 * 11);
        }
        if (CompatibleDB.mysql(compatibleLevel) && !containsANSIQuotes) {
            Utils.doAppendEscapedIdentifier(s_buf, _value, '`');
        } else {
            Utils.doAppendEscapedIdentifier(s_buf, _value, '\"');
        }
        return s_buf;
    }

    private static void doAppendEscapedIdentifier(Appendable s_buf, String _value, char quotes) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            s_buf.append(quotes);
            for (int i = 0; i < _value.length(); ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                char chr = _value.charAt(i);
                if (chr == '\u0000') {
                    throw new KSQLException(GT.tr("Zero _bytes may not occur in identifiers.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
                }
                if (chr == '\"') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    s_buf.append(chr);
                }
                s_buf.append(chr);
            }
            s_buf.append(quotes);
        }
        catch (IOException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)e);
        }
    }

    @Deprecated
    public static int parseServerVersionStr(String serVersion) throws NumberFormatException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ServerVersion.parseServerVersionStr(serVersion);
    }
}

