/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3;

import com.kingbase8.KBProperty;
import com.kingbase8.copy.CopyIn;
import com.kingbase8.copy.CopyOperation;
import com.kingbase8.copy.CopyOut;
import com.kingbase8.core.CommandCompleteParser;
import com.kingbase8.core.Encoding;
import com.kingbase8.core.EncodingPredictor;
import com.kingbase8.core.Field;
import com.kingbase8.core.KBBindException;
import com.kingbase8.core.KBStream;
import com.kingbase8.core.NativeQuery;
import com.kingbase8.core.Notification;
import com.kingbase8.core.Oid;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.Parser;
import com.kingbase8.core.Query;
import com.kingbase8.core.QueryExecutorBase;
import com.kingbase8.core.ReplicationProtocol;
import com.kingbase8.core.ResultCursor;
import com.kingbase8.core.ResultHandler;
import com.kingbase8.core.ResultHandlerBase;
import com.kingbase8.core.ResultHandlerDelegate;
import com.kingbase8.core.SqlCommand;
import com.kingbase8.core.SqlCommandType;
import com.kingbase8.core.TransactionState;
import com.kingbase8.core.Utils;
import com.kingbase8.core.v3.BatchedQuery;
import com.kingbase8.core.v3.CompositeParameterList;
import com.kingbase8.core.v3.CompositeQuery;
import com.kingbase8.core.v3.CopyDualImpl;
import com.kingbase8.core.v3.CopyInImpl;
import com.kingbase8.core.v3.CopyOperationImpl;
import com.kingbase8.core.v3.CopyOutImpl;
import com.kingbase8.core.v3.DescribeRequest;
import com.kingbase8.core.v3.ExecuteRequest;
import com.kingbase8.core.v3.Portal;
import com.kingbase8.core.v3.SimpleParameterList;
import com.kingbase8.core.v3.SimpleQuery;
import com.kingbase8.core.v3.V3ParameterList;
import com.kingbase8.core.v3.replication.V3ReplicationProtocol;
import com.kingbase8.jdbc.AutoSave;
import com.kingbase8.jdbc.BatchResultHandler;
import com.kingbase8.jdbc.CompatibleDB;
import com.kingbase8.jdbc.TimestampUtils;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.KSQLWarning;
import com.kingbase8.util.ServerErrorMessage;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class QueryExecutorImpl
extends QueryExecutorBase {
    private static final String COPY_ERROR_MESSAGE_T = "COPY commands are only supported using the CopyManager API.";
    private String applicationNameT;
    private TimeZone tz;
    private final Set<Integer> useBinaryReceiveForOids = new HashSet<Integer>();
    private boolean integerDateTimesT;
    private final SimpleQuery sync;
    private final Set<Integer> useBinarySendForOids;
    private String lastSetSearchPathQuery;
    private Object lockedFor;
    private short _deallocateEpoch;
    private final ReplicationProtocol replicationProtocolT;
    private SQLException transactionFailedCauseT;
    private final CommandCompleteParser commandCompleteParser;
    private String client_encoding;
    private static final int MAX_BUFFERED_RECV_BYTES = 64000;
    private static final int NODATA_QUERY_RESPONSE_SIZE_BYTES = 250;
    AtomicBoolean processingCopyResults;
    private final HashMap<PhantomReference<SimpleQuery>, String> parsedQueryMap;
    private final ReferenceQueue<SimpleQuery> parsedQueryCleanupQueue;
    private final HashMap<PhantomReference<Portal>, String> openPortalMap;
    private final ReferenceQueue<Portal> openPortalCleanupQueue;
    private SimpleQuery lastQuery;
    private final Deque<SimpleQuery> lastQueries;
    private int level;
    private Field[] firstFields;
    private boolean resetField;
    private boolean hast;
    private boolean isEnd;
    private boolean describeOnly;
    private boolean currentIsBatch;
    private boolean popStack;
    private static final Portal UNNAMED_PORTAL = new Portal(null, "unnamed");
    private final Deque<SimpleQuery> _pendingParseQueue;
    private final Deque<Portal> _pendingBindQueue;
    private final Deque<ExecuteRequest> _pendingExecuteQueue;
    private final Deque<DescribeRequest> _pendingDescribeStatementQueue;
    private final Deque<SimpleQuery> _pendingDescribePortalQueue;
    private long nextUniqueID;
    private final boolean allowEncodingChanges;
    private final boolean cleanupSavePoints;
    private int _estimatedReceiveBufferBytes;
    private final SimpleQuery beginTransactionQuery;
    private final SimpleQuery beginReadOnlyTransactionQuery;
    private final SimpleQuery emptyQuery;
    private final SimpleQuery autoSaveQuery;
    private final SimpleQuery releaseAutoSave;
    private final SimpleQuery restoreToAutoSave;

    public QueryExecutorImpl(KBStream kbStream, String user, String database, int cancelSignalTimeout, Properties info) throws SQLException, IOException {
        super(kbStream, user, database, cancelSignalTimeout, info);
        this.sync = (SimpleQuery)this.createQuery((String)"SYNC", (boolean)false, (boolean)true, (String[])new String[0]).query;
        this.useBinarySendForOids = new HashSet<Integer>();
        this.lockedFor = null;
        this.commandCompleteParser = new CommandCompleteParser();
        this.processingCopyResults = new AtomicBoolean(false);
        this.parsedQueryMap = new HashMap();
        this.parsedQueryCleanupQueue = new ReferenceQueue();
        this.openPortalMap = new HashMap();
        this.openPortalCleanupQueue = new ReferenceQueue();
        this.lastQuery = null;
        this.lastQueries = new ArrayDeque<SimpleQuery>();
        this.level = -1;
        this.firstFields = null;
        this.resetField = false;
        this.hast = false;
        this.isEnd = false;
        this.describeOnly = false;
        this.currentIsBatch = false;
        this.popStack = true;
        this._pendingParseQueue = new ArrayDeque<SimpleQuery>();
        this._pendingBindQueue = new ArrayDeque<Portal>();
        this._pendingExecuteQueue = new ArrayDeque<ExecuteRequest>();
        this._pendingDescribeStatementQueue = new ArrayDeque<DescribeRequest>();
        this._pendingDescribePortalQueue = new ArrayDeque<SimpleQuery>();
        this.nextUniqueID = 1L;
        this._estimatedReceiveBufferBytes = 0;
        this.beginTransactionQuery = new SimpleQuery(new NativeQuery("BEGIN", new int[0], null, false, SqlCommand.BLANK), null, false);
        this.beginReadOnlyTransactionQuery = new SimpleQuery(new NativeQuery("BEGIN READ ONLY", new int[0], null, false, SqlCommand.BLANK), null, false);
        this.emptyQuery = new SimpleQuery(new NativeQuery("", new int[0], null, false, SqlCommand.createStatementTypeInfo(SqlCommandType.BLANK)), null, false);
        this.autoSaveQuery = new SimpleQuery(new NativeQuery("SAVEPOINT KBJDBC_AUTOSAVE", new int[0], null, false, SqlCommand.BLANK), null, false);
        this.releaseAutoSave = new SimpleQuery(new NativeQuery("RELEASE SAVEPOINT KBJDBC_AUTOSAVE", new int[0], null, false, SqlCommand.BLANK), null, false);
        this.restoreToAutoSave = new SimpleQuery(new NativeQuery("ROLLBACK TO SAVEPOINT KBJDBC_AUTOSAVE", new int[0], null, false, SqlCommand.BLANK), null, false);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.client_encoding = KBProperty.CLIENT_ENCODING.get(info);
        this.allowEncodingChanges = KBProperty.ALLOW_ENCODING_CHANGES.getBoolean(info);
        this.cleanupSavePoints = KBProperty.CLEANUP_SAVEPOINTS.getBoolean(info);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.replicationProtocolT = new V3ReplicationProtocol(this, kbStream);
        this.readStartupMessages();
    }

    @Override
    public int getProtocolVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return 3;
    }

    private void lock(Object obtainer) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.lockedFor == obtainer) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Tried to obtain lock while already holding it", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.waitOnLock_();
        this.lockedFor = obtainer;
    }

    private void unlock(Object holder) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.lockedFor != holder) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Tried to break lock on database _connection", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.lockedFor = null;
        this.notify();
    }

    private void waitOnLock_() throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (this.lockedFor != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Thread.currentThread().interrupt();
                throw new KSQLException(GT.tr("Interrupted while waiting to obtain lock on database _connection", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE, (Throwable)ie);
            }
        }
    }

    @Override
    public Query createSimpleQuery(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        List<NativeQuery> _queries = Parser.parseJdbcSql(_sql, this.getStandardConformingStrings(), false, true, this.isReWriteBatchedInsertsEnabled(), this.getCompatibleLevel(), this.getContainsANSIQuotes(), new String[0]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.wrap(_queries);
    }

    boolean hasLock(Object holder) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.lockedFor == holder;
    }

    @Override
    public Query wrap(List<NativeQuery> _queries) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_queries.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.emptyQuery;
        }
        if (_queries.size() == 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            NativeQuery _firstQuery = _queries.get(0);
            if (this.isReWriteBatchedInsertsEnabled() && _firstQuery.getCommand().isBatchedReWriteCompatible()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int valuesBraceOpenPosition = _firstQuery.getCommand().getBatchRewriteValuesBraceOpenPosition();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int valuesBraceClosePosition = _firstQuery.getCommand().getBatchRewriteValuesBraceClosePosition();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return new BatchedQuery(_firstQuery, this, valuesBraceOpenPosition, valuesBraceClosePosition, this.isColumnSanitiserDisabled());
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new SimpleQuery(_firstQuery, this, this.isColumnSanitiserDisabled());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SimpleQuery[] sub_queries = new SimpleQuery[_queries.size()];
        int[] _offsets = new int[sub_queries.length];
        int _offset = 0;
        for (int i = 0; i < _queries.size(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            NativeQuery _nativeQuery = _queries.get(i);
            _offsets[i] = _offset;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sub_queries[i] = new SimpleQuery(_nativeQuery, this, this.isColumnSanitiserDisabled());
            _offset += _nativeQuery._bindPositions.length;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new CompositeQuery(sub_queries, _offsets);
    }

    private int updateQueryMode_(int _flags) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        switch (this.getPreferQueryMode()) {
            case SIMPLE: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return _flags | 0x400;
            }
            case EXTENDED: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return _flags & 0xFFFFFBFF;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _flags;
    }

    @Override
    public synchronized void execute(Query query, ParameterList _parameters, ResultHandler _handler, int maxRows, int fetchSize, int _flags) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.waitOnLock_();
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, "  simple execute, _handler={0}, maxRows={1}, fetchSize={2}, _flags={3}", _handler, maxRows, fetchSize, _flags);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_parameters == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _parameters = SimpleQuery.NO_PARAMETERS;
        }
        boolean describeOnly = (0x20 & (_flags = this.updateQueryMode_(_flags))) != 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.pg(this.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ((V3ParameterList)_parameters).convertFunctionOutParameters();
        }
        if (!describeOnly) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ((V3ParameterList)_parameters).checkAllParametersSet();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean _autosave = false;
        try {
            try {
                V3ParameterList[] v3ParameterListArray;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _handler = this.sendQueryPreamble(_handler, _flags);
                _autosave = this.sendAutomaticSavepoint(query, _flags);
                if (_parameters instanceof SimpleParameterList) {
                    SimpleParameterList[] simpleParameterListArray = new SimpleParameterList[1];
                    v3ParameterListArray = simpleParameterListArray;
                    simpleParameterListArray[0] = (SimpleParameterList)_parameters;
                } else {
                    CompositeParameterList[] compositeParameterListArray = new CompositeParameterList[1];
                    v3ParameterListArray = compositeParameterListArray;
                    compositeParameterListArray[0] = (CompositeParameterList)_parameters;
                }
                this.sendQuery(query, v3ParameterListArray, maxRows, fetchSize, _flags, _handler, null, false);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if ((_flags & 0x400) != 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.sendSync_();
                }
                this.processResults(_handler, _flags);
                this._estimatedReceiveBufferBytes = 0;
            }
            catch (KBBindException se) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.sendSync_();
                this.processResults(_handler, _flags);
                this._estimatedReceiveBufferBytes = 0;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _handler.handleError(new KSQLException(GT.tr("Unable to _bind _parameter values for stmt.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE, (Throwable)se.getIOException()));
            }
        }
        catch (IOException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.abort();
            _handler.handleError(new KSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _handler.handleCompletion();
            if (this.cleanupSavePoints) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.releaseSavePoint(_autosave, _flags);
            }
        }
        catch (SQLException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.rollbackIfRequired(_autosave, e);
        }
    }

    private boolean sendAutomaticSavepoint(Query query, int _flags) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!((_flags & 0x10) != 0 && this.getTransactionState() != TransactionState.OPEN || query == this.restoreToAutoSave || query.getNativeSql().equalsIgnoreCase("COMMIT") || this.getAutoSave() == AutoSave.NEVER || this.getAutoSave() != AutoSave.ALWAYS && query instanceof SimpleQuery && ((SimpleQuery)query).getFields() == null)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.sendOneQuery(this.autoSaveQuery, new SimpleParameterList[]{SimpleQuery.NO_PARAMETERS}, 1, 0, 1030, false);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    private void releaseSavePoint(boolean _autosave, int _flags) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_autosave && this.getAutoSave() == AutoSave.ALWAYS && this.getTransactionState() == TransactionState.OPEN) {
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.sendOneQuery(this.releaseAutoSave, new SimpleParameterList[]{SimpleQuery.NO_PARAMETERS}, 1, 0, 1030, false);
            }
            catch (IOException ex) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Error releasing savepoint", new Object[0]), KSQLState.IO_ERROR);
            }
        }
    }

    private void rollbackIfRequired(boolean _autosave, SQLException e) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_autosave && this.getTransactionState() == TransactionState.FAILED && (this.getAutoSave() == AutoSave.ALWAYS || this.willHealOnRetry(e))) {
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.execute(this.restoreToAutoSave, SimpleQuery.NO_PARAMETERS, new ResultHandlerDelegate(null), 1, 0, 1030);
            }
            catch (SQLException ex2) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                e.setNextException(ex2);
            }
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(Query[] _queries, ParameterList[] _parameterLists, BatchResultHandler _batchHandler, int maxRows, int fetchSize, int _flags, boolean reWriteBind) throws SQLException {
        boolean describeOnly;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.waitOnLock_();
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, "  batch execute {0} _queries, _handler={1}, maxRows={2}, fetchSize={3}, _flags={4}", _queries.length, _batchHandler, maxRows, fetchSize, _flags);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _flags = this.updateQueryMode_(_flags);
        boolean bl = describeOnly = (0x20 & _flags) != 0;
        if (!describeOnly) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (ParameterList _parameterList : _parameterLists) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_parameterList == null) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ((V3ParameterList)_parameterList).checkAllParametersSet();
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.currentIsBatch = true;
        boolean _autosave = false;
        ResultHandler _handler = _batchHandler;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _handler = this.sendQueryPreamble(_batchHandler, _flags);
            _autosave = this.sendAutomaticSavepoint(_queries[0], _flags);
            this._estimatedReceiveBufferBytes = 0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (reWriteBind) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                SimpleParameterList[] paraLists = new SimpleParameterList[_queries.length];
                for (int i = 0; i < _queries.length; ++i) {
                    SimpleParameterList _parameters = (SimpleParameterList)_parameterLists[i];
                    if (_parameters == null) {
                        _parameters = SimpleQuery.NO_PARAMETERS;
                    }
                    paraLists[i] = _parameters;
                }
                this.sendQuery(_queries[0], paraLists, maxRows, fetchSize, _flags, _handler, _batchHandler, true);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                for (int i = 0; i < _queries.length; ++i) {
                    V3ParameterList[] v3ParameterListArray;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    Query query = _queries[i];
                    V3ParameterList _parameters = (V3ParameterList)_parameterLists[i];
                    if (_parameters == null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _parameters = SimpleQuery.NO_PARAMETERS;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (_parameters instanceof SimpleParameterList) {
                        SimpleParameterList[] simpleParameterListArray = new SimpleParameterList[1];
                        v3ParameterListArray = simpleParameterListArray;
                        simpleParameterListArray[0] = (SimpleParameterList)_parameters;
                    } else {
                        CompositeParameterList[] compositeParameterListArray = new CompositeParameterList[1];
                        v3ParameterListArray = compositeParameterListArray;
                        compositeParameterListArray[0] = (CompositeParameterList)_parameters;
                    }
                    this.sendQuery(query, v3ParameterListArray, maxRows, fetchSize, _flags, _handler, _batchHandler, false);
                    if (_handler.getException() == null) continue;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    break;
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_handler.getException() == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if ((_flags & 0x400) == 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.sendSync_();
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.processResults(_handler, _flags);
                this._estimatedReceiveBufferBytes = 0;
            }
        }
        catch (IOException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.abort();
            _handler.handleError(new KSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _handler.handleCompletion();
            if (this.cleanupSavePoints) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.releaseSavePoint(_autosave, _flags);
            }
        }
        catch (SQLException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.rollbackIfRequired(_autosave, e);
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.currentIsBatch = false;
        }
    }

    private ResultHandler sendQueryPreamble(ResultHandler _delegateHandler, int _flags) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.processDeadParsedQueries();
        this.processDeadPortals();
        if ((_flags & 0x10) != 0 || this.getTransactionState() != TransactionState.IDLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _delegateHandler;
        }
        int beginFlags = 2;
        if ((_flags & 1) != 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            beginFlags |= 1;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        beginFlags |= 0x400;
        beginFlags = this.updateQueryMode_(beginFlags);
        SimpleQuery beginQuery = (_flags & 0x800) == 0 ? this.beginTransactionQuery : this.beginReadOnlyTransactionQuery;
        this.sendOneQuery(beginQuery, new SimpleParameterList[]{SimpleQuery.NO_PARAMETERS}, 0, 0, beginFlags, false);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new ResultHandlerDelegate(_delegateHandler){
            private boolean sawBegin;
            {
                this.sawBegin = false;
            }

            @Override
            public void handleResultRows(Query fromQuery, Field[] _fields, List<byte[][]> _tuples, ResultCursor cursor) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.sawBegin) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    super.handleResultRows(fromQuery, _fields, _tuples, cursor);
                }
            }

            @Override
            public void handleCommandStatus(String status, long updateNum, long insertOID) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!this.sawBegin) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.sawBegin = true;
                    if (!status.equals("BEGIN")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.handleError(new KSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), KSQLState.PROTOCOL_VIOLATION));
                    }
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    super.handleCommandStatus(status, updateNum, insertOID);
                }
            }
        };
    }

    @Override
    public synchronized byte[] fpCall(int functionId, ParameterList _parameters, boolean suppressBegin) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.waitOnLock_();
        if (!suppressBegin) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.doSubprotocolBegin();
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.sendFastpathCall_(functionId, (SimpleParameterList)_parameters);
            return this.receiveFastpathResult();
        }
        catch (IOException ioException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.abort();
            throw new KSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ioException);
        }
    }

    public void doSubprotocolBegin() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getTransactionState() == TransactionState.IDLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, "Issuing BEGIN before fp or copy call.", new Object[0]);
            ResultHandlerBase _handler = new ResultHandlerBase(){
                private boolean sawBegin = false;

                @Override
                public void handleCommandStatus(String status, long updateNum, long insertOID) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (!this.sawBegin) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (!status.equals("BEGIN")) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.handleError(new KSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), KSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.handleError(new KSQLException(GT.tr("Unexpected command status: {0}.", status), KSQLState.PROTOCOL_VIOLATION));
                    }
                }

                @Override
                public void handleWarning(SQLWarning _warning) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.handleError(_warning);
                }
            };
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int beginFlagsT = 1027;
                beginFlagsT = this.updateQueryMode_(beginFlagsT);
                this.sendOneQuery(this.beginTransactionQuery, new SimpleParameterList[]{SimpleQuery.NO_PARAMETERS}, 0, 0, beginFlagsT, false);
                this.sendSync_();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.processResults(_handler, 0);
                this._estimatedReceiveBufferBytes = 0;
            }
            catch (IOException ioe) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
    }

    @Override
    public ParameterList createFastpathParameters(int _count) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new SimpleParameterList(_count, this);
    }

    private void sendFastpathCall_(int functionId, SimpleParameterList _params) throws SQLException, IOException {
        int i;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, " FE=> FunctionCall({0}, {1} _params)", functionId, _params.getParameterCount());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _paramCount = _params.getParameterCount();
        int _encodedSize = 0;
        for (i = 1; i <= _paramCount; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_params.isNull(i)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _encodedSize += 4;
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _encodedSize += 4 + _params.getV3Length(i, this.client_encoding);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(70);
        this.kbStream.sendInteger4(10 + 2 * _paramCount + 2 + _encodedSize + 2);
        this.kbStream.sendInteger4(functionId);
        this.kbStream.sendInteger2(_paramCount);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (i = 1; i <= _paramCount; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.sendInteger2(_params.isBinary(i) ? 1 : 0);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendInteger2(_paramCount);
        for (i = 1; i <= _paramCount; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_params.isNull(i)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.kbStream.sendInteger4(-1);
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.sendInteger4(_params.getV3Length(i, this.client_encoding));
            _params.writeV3Value(i, this.kbStream, this.client_encoding);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendInteger2(1);
        this.kbStream.flush();
    }

    @Override
    public synchronized void processNotifies() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.processNotifies(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void processNotifies(int _timeoutMillis) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.waitOnLock_();
        if (this.getTransactionState() != TransactionState.IDLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        if (this.hasNotifications()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _timeoutMillis = -1;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean useTimeout = _timeoutMillis > 0;
        long startTime = 0L;
        int oldTimeout = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (useTimeout) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            startTime = System.nanoTime() / 1000L;
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oldTimeout = this.kbStream.getSocket().getSoTimeout();
            }
            catch (SocketException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("An _error occurred while trying to get the socket _timeout.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            block14: while (true) {
                if (_timeoutMillis < 0) {
                    if (!this.kbStream.hasMessagePending()) return;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (useTimeout && _timeoutMillis >= 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setSocketTimeout(_timeoutMillis);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int c = this.kbStream.receiveChar();
                if (useTimeout && _timeoutMillis >= 0) {
                    this.setSocketTimeout(0);
                }
                switch (c) {
                    case 65: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.receiveAsyncNotify_();
                        _timeoutMillis = -1;
                        continue block14;
                    }
                    case 69: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throw this.receiveErrorResponse();
                    }
                    case 78: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        SQLWarning _warning = this.receiveNoticeResponse();
                        this.addWarning(_warning);
                        if (!useTimeout) continue block14;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        long newTimeMillis = System.nanoTime() / 1000L;
                        _timeoutMillis = (int)((long)_timeoutMillis + (startTime - newTimeMillis));
                        startTime = newTimeMillis;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (_timeoutMillis != 0) continue block14;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _timeoutMillis = -1;
                        continue block14;
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Unknown Response Type {0}.", Character.valueOf((char)c)), KSQLState.CONNECTION_FAILURE);
            }
        }
        catch (SocketTimeoutException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (useTimeout) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setSocketTimeout(oldTimeout);
            }
        }
    }

    private void setSocketTimeout(int millisecs) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            Socket s = this.kbStream.getSocket();
            if (!s.isClosed()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.kbStream.isUseDispatch()) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbStream.getSocket().setSoTimeout(millisecs);
                    this.kbStream.setSocketTimeout(1);
                    KBLOGGER.log(Level.INFO, "socketTimeout is " + millisecs, new Object[0]);
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbStream.getSocket().setSoTimeout(millisecs);
                }
            }
        }
        catch (SocketException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("An _error occurred while trying to reset the socket _timeout.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    private byte[] receiveFastpathResult() throws IOException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean endQueryT = false;
        SQLException errorException = null;
        byte[] returnValueT = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        block7: while (!endQueryT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int cT = this.kbStream.receiveChar();
            switch (cT) {
                case 69: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    SQLException newErrorException = this.receiveErrorResponse();
                    if (errorException == null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        errorException = newErrorException;
                        continue block7;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    errorException.setNextException(newErrorException);
                    continue block7;
                }
                case 78: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    SQLWarning _warning = this.receiveNoticeResponse();
                    this.addWarning(_warning);
                    continue block7;
                }
                case 65: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveAsyncNotify_();
                    continue block7;
                }
                case 90: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveRFQ_();
                    endQueryT = true;
                    continue block7;
                }
                case 86: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int msgLen = this.kbStream.receiveInteger4();
                    int _valueLen = this.kbStream.receiveInteger4();
                    KBLOGGER.log(Level.FINEST, " <=BE FunctionCallResponse({0} _bytes)", _valueLen);
                    if (_valueLen == -1) continue block7;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    byte[] _buf = new byte[_valueLen];
                    this.kbStream.receive(_buf, 0, _valueLen);
                    returnValueT = _buf;
                    continue block7;
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unknown Response Type {0}.", Character.valueOf((char)cT)), KSQLState.CONNECTION_FAILURE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (errorException != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw errorException;
        }
        return returnValueT;
    }

    private synchronized void initCopy(CopyOperationImpl operation) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.receiveInteger4();
        int rowFormat = this.kbStream.receiveChar();
        int numFields = this.kbStream.receiveInteger2();
        int[] _fieldFormats = new int[numFields];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = 0; i < numFields; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fieldFormats[i] = this.kbStream.receiveInteger2();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.lock(operation);
        operation.init(this, rowFormat, _fieldFormats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCopy(CopyOperationImpl operation) throws SQLException {
        int _errors;
        SQLException _error;
        block26: {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!this.hasLock(operation)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Tried to cancel an inactive copy operation", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
            }
            _error = null;
            _errors = 0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                if (operation instanceof CopyIn) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    QueryExecutorImpl queryExecutorImpl = this;
                    synchronized (queryExecutorImpl) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, "FE => CopyFail", new Object[0]);
                        byte[] msg = Utils._encodeUTF8("Copy cancel requested");
                        this.kbStream.sendChar(102);
                        this.kbStream.sendInteger4(5 + msg.length);
                        this.kbStream.send(msg);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.kbStream.sendChar(0);
                        this.kbStream.flush();
                        do {
                            try {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                this.processCopyResults(operation, true);
                            }
                            catch (SQLException se) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                ++_errors;
                                if (_error != null) {
                                    SQLException next;
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    SQLException e = se;
                                    while ((next = e.getNextException()) != null) {
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        e = next;
                                    }
                                    e.setNextException(_error);
                                }
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                _error = se;
                            }
                        } while (this.hasLock(operation));
                        break block26;
                    }
                }
                if (operation instanceof CopyOut) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.sendQueryCancel();
                }
            }
            catch (IOException ioe) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Database _connection failed when canceling copy operation", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ioe);
            }
            finally {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                QueryExecutorImpl queryExecutorImpl = this;
                synchronized (queryExecutorImpl) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (this.hasLock(operation)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.unlock(operation);
                    }
                }
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (operation instanceof CopyIn) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_errors < 1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Missing expected _error response to copy cancel request", new Object[0]), KSQLState.COMMUNICATION_ERROR);
            }
            if (_errors > 1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Got {0} _error responses to single copy cancel request", String.valueOf(_errors)), KSQLState.COMMUNICATION_ERROR, _error);
            }
        }
    }

    public synchronized long endCopy(CopyOperationImpl operation) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.hasLock(operation)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Tried to end inactive copy", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, " FE=> CopyDone", new Object[0]);
            this.kbStream.sendChar(99);
            this.kbStream.sendInteger4(4);
            this.kbStream.flush();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            do {
                this.processCopyResults(operation, true);
            } while (this.hasLock(operation));
            return operation.getHandledRowCount();
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Database _connection failed when ending copy", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    public synchronized void writeToCopy(CopyOperationImpl operation, byte[] data, int off, int siz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.hasLock(operation)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Tried to write to an inactive copy operation", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
        }
        KBLOGGER.log(Level.FINEST, " FE=> CopyData({0})", siz);
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.sendChar(100);
            this.kbStream.sendInteger4(siz + 4);
            this.kbStream.send(data, off, siz);
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Database _connection failed when writing to copy", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    public synchronized void flushCopy(CopyOperationImpl operation) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.hasLock(operation)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Tried to write to an inactive copy operation", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.flush();
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Database _connection failed when writing to copy", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    synchronized void readFromCopy(CopyOperationImpl operation, boolean block) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.hasLock(operation)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Tried to read from inactive copy", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.processCopyResults(operation, block);
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Database _connection failed when reading from copy", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CopyOperationImpl processCopyResults(CopyOperationImpl operation, boolean blockT) throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.processingCopyResults.compareAndSet(false, true)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.INFO, "Ignoring request to process copy _results, already processing", new Object[0]);
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            boolean endReceivingT = false;
            SQLException errorException = null;
            SQLException errorsException = null;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (!endReceivingT && (blockT || this.kbStream.hasMessagePending())) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!blockT) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int c = this.kbStream.peekChar();
                    if (c == 67) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, " <=BE CommandStatus, Ignored until CopyDone", new Object[0]);
                        break;
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int cT = this.kbStream.receiveChar();
                switch (cT) {
                    case 65: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, " <=BE Asynchronous Notification while copying", new Object[0]);
                        this.receiveAsyncNotify_();
                        break;
                    }
                    case 67: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        String status = this.receiveCommandStatus();
                        try {
                            if (operation == null) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                throw new KSQLException(GT.tr("Received CommandComplete ''{0}'' without an active copy operation", status), KSQLState.OBJECT_NOT_IN_STATE);
                            }
                            operation.handleCommandStatus(status);
                        }
                        catch (SQLException se) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            errorException = se;
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        blockT = true;
                        break;
                    }
                    case 78: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, " <=BE Notification while copying", new Object[0]);
                        this.addWarning(this.receiveNoticeResponse());
                        break;
                    }
                    case 69: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        errorException = this.receiveErrorResponse();
                        blockT = true;
                        break;
                    }
                    case 71: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, " <=BE CopyInResponse", new Object[0]);
                        if (operation != null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            errorException = new KSQLException(GT.tr("Got CopyInResponse from server during an active {0}", operation.getClass().getName()), KSQLState.OBJECT_NOT_IN_STATE);
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        operation = new CopyInImpl();
                        this.initCopy(operation);
                        endReceivingT = true;
                        break;
                    }
                    case 72: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, " <=BE CopyOutResponse", new Object[0]);
                        if (operation != null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            errorException = new KSQLException(GT.tr("Got CopyOutResponse from server during an active {0}", operation.getClass().getName()), KSQLState.OBJECT_NOT_IN_STATE);
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        operation = new CopyOutImpl();
                        this.initCopy(operation);
                        endReceivingT = true;
                        break;
                    }
                    case 87: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, " <=BE CopyBothResponse", new Object[0]);
                        if (operation != null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            errorException = new KSQLException(GT.tr("Got CopyBothResponse from server during an active {0}", operation.getClass().getName()), KSQLState.OBJECT_NOT_IN_STATE);
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        operation = new CopyDualImpl();
                        this.initCopy(operation);
                        endReceivingT = true;
                        break;
                    }
                    case 100: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, " <=BE CopyData", new Object[0]);
                        int leng = this.kbStream.receiveInteger4() - 4;
                        assert (leng > 0) : "Copy Data length must be greater than 4";
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        byte[] _buf = this.kbStream.receive(leng);
                        if (operation == null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            errorException = new KSQLException(GT.tr("Got CopyData without an active copy operation", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
                        } else if (!(operation instanceof CopyOut)) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            errorException = new KSQLException(GT.tr("Unexpected copydata from server for {0}", operation.getClass().getName()), KSQLState.COMMUNICATION_ERROR);
                        } else {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            operation.handleCopydata(_buf);
                        }
                        endReceivingT = true;
                        break;
                    }
                    case 99: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, " <=BE CopyDone", new Object[0]);
                        int leng = this.kbStream.receiveInteger4() - 4;
                        if (leng > 0) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.kbStream.receive(leng);
                        }
                        if (!(operation instanceof CopyOut)) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            errorException = new KSQLException("Got CopyDone while not copying from server", KSQLState.OBJECT_NOT_IN_STATE);
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        blockT = true;
                        break;
                    }
                    case 83: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        try {
                            this.receiveParameterStatus();
                        }
                        catch (SQLException sqlException) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            errorException = sqlException;
                            endReceivingT = true;
                        }
                        break;
                    }
                    case 90: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.receiveRFQ_();
                        if (this.hasLock(operation)) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.unlock(operation);
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        operation = null;
                        endReceivingT = true;
                        break;
                    }
                    case 84: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, " <=BE RowDescription (during copy ignored)", new Object[0]);
                        this.skipMessage_();
                        break;
                    }
                    case 68: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, " <=BE DataRow (during copy ignored)", new Object[0]);
                        this.skipMessage_();
                        break;
                    }
                    default: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throw new IOException(GT.tr("Unexpected packet type during copy: {0}", Integer.toString(cT)));
                    }
                }
                if (errorException == null) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (errorsException != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    errorException.setNextException(errorsException);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                errorsException = errorException;
                errorException = null;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (errorsException != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw errorsException;
            }
            CopyOperationImpl copyOperationImpl = operation;
            return copyOperationImpl;
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.processingCopyResults.set(false);
        }
    }

    private void flushIfDeadlockRisk(Query query, boolean disallowBatchingT, ResultHandler _resultHandler, BatchResultHandler _batchHandler, int _flags) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._estimatedReceiveBufferBytes += 250;
        SimpleQuery simpleQuery = (SimpleQuery)query;
        if (simpleQuery.isStatementDescribed()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int maxResultRowSizeT = simpleQuery.getMaxResultRowSize();
            if (maxResultRowSizeT >= 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._estimatedReceiveBufferBytes += maxResultRowSizeT;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                KBLOGGER.log(Level.FINEST, "Couldn't estimate _result size or _result size unbounded, disabling batching for this query.", new Object[0]);
                disallowBatchingT = true;
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        if (disallowBatchingT || this._estimatedReceiveBufferBytes >= 64000) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, "Forcing Sync, receive _buffer full or batching disallowed", new Object[0]);
            this.sendSync_();
            this.processResults(_resultHandler, _flags);
            this._estimatedReceiveBufferBytes = 0;
            if (_batchHandler != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _batchHandler.secureProgress();
            }
        }
    }

    private void sendQuery(Query query, V3ParameterList[] _parameters, int maxRows, int fetchSize, int _flags, ResultHandler _resultHandler, BatchResultHandler _batchHandler, boolean reWrite) throws IOException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Query[] sub_queries = query.getSubqueries();
        SimpleParameterList[] sub_params = _parameters[0].getSub_params();
        boolean disallowBatching = (_flags & 0x80) != 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sub_queries == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.flushIfDeadlockRisk(query, disallowBatching, _resultHandler, _batchHandler, _flags);
            if (_resultHandler.getException() == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.sendOneQuery((SimpleQuery)query, (SimpleParameterList[])_parameters, maxRows, fetchSize, _flags, reWrite);
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < sub_queries.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Query subquery = sub_queries[i];
                this.flushIfDeadlockRisk(subquery, disallowBatching, _resultHandler, _batchHandler, _flags);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_resultHandler.getException() != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                SimpleParameterList sub_param = SimpleQuery.NO_PARAMETERS;
                if (sub_params != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sub_param = sub_params[i];
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.sendOneQuery((SimpleQuery)subquery, new SimpleParameterList[]{sub_param}, maxRows, fetchSize, _flags, false);
            }
        }
    }

    private void sendSync_() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBLOGGER.log(Level.FINEST, " FE=> Sync", new Object[0]);
        this.kbStream.sendChar(83);
        this.kbStream.sendInteger4(4);
        this.kbStream.flush();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._pendingExecuteQueue.add(new ExecuteRequest(this.sync, null, false));
        this._pendingDescribePortalQueue.add(this.sync);
    }

    private void sendParse(SimpleQuery query, SimpleParameterList _params, boolean oneShot) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int[] typeOIDs = _params.getTypeOIDs();
        if (query.isPreparedFor(typeOIDs, this._deallocateEpoch)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        query.reset();
        this.processDeadParsedQueries();
        query.setFields(null);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String stmtName = null;
        if (!oneShot) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stmtName = "S_" + this.nextUniqueID++;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            query.setStatementName(stmtName, this._deallocateEpoch);
            query.setPrepareTypes(typeOIDs);
            this.registerParsedQuery(query, stmtName);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        byte[] _encodedStatementName = query.getEncodedStatementName();
        String nativeSql = query.getNativeSql();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder s_buf = new StringBuilder(" FE=> Parse(stm=" + stmtName + ",query=\"");
            s_buf.append(nativeSql);
            s_buf.append("\",_oids={");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 1; i <= _params.getParameterCount(); ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (i != 1) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    s_buf.append(",");
                }
                s_buf.append(_params.getTypeOID(i));
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            s_buf.append("})");
            KBLOGGER.log(Level.FINEST, s_buf.toString(), new Object[0]);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] queryUtf8 = Utils.encode(nativeSql, this.client_encoding);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _encodedSize = 4 + (_encodedStatementName == null ? 0 : _encodedStatementName.length) + 1 + queryUtf8.length + 1 + 2 + 4 * _params.getParameterCount();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(80);
        this.kbStream.sendInteger4(_encodedSize);
        if (_encodedStatementName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.send(_encodedStatementName);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(0);
        this.kbStream.send(queryUtf8);
        this.kbStream.sendChar(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendInteger2(_params.getParameterCount());
        for (int i = 1; i <= _params.getParameterCount(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _oid = _params.getTypeOID(i);
            if (CompatibleDB.notPg(this.getCompatibleLevel())) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if ((_params.getFlags()[i - 1] & 1) == 1) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _oid |= 0x20000000;
                }
                if ((_params.getFlags()[i - 1] & 2) == 2) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _oid |= 0x40000000;
                }
                if ((_params.getFlags()[i - 1] & 8) == 8) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _oid |= Integer.MIN_VALUE;
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.sendInteger4(_oid);
        }
        this._pendingParseQueue.add(query);
    }

    private void sendBind(SimpleQuery query, SimpleParameterList[] _paramss, Portal _portal, boolean noBinaryTransfer, boolean reWriteBind) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String stmtName = query.getStatementName();
        byte[] _encodedStatementName = query.getEncodedStatementName();
        byte[] _encodedPortalName = _portal == null ? null : _portal.getEncodedPortalName();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SimpleParameterList _params = _paramss[0];
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder s_buf = new StringBuilder(" FE=> Bind(stm=" + stmtName + ",_portal=" + _portal);
            for (int j = 0; j < _paramss.length; ++j) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _params = _paramss[j];
                for (int i = 1; i <= _params.getParameterCount(); ++i) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    s_buf.append(",$").append(i).append("=<").append(_params.toString(i, true)).append(">,type=").append(Oid.toString(_params.getTypeOID(i)));
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            s_buf.append(")");
            KBLOGGER.log(Level.FINEST, s_buf.toString(), new Object[0]);
        }
        long _encodedSize = 0L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int j = 0; j < _paramss.length; ++j) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _params = _paramss[j];
            for (int i = 1; i <= _params.getParameterCount(); ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_params.isNull(i)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _encodedSize += 4L;
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _encodedSize += 4L + (long)_params.getV3Length(i, this.client_encoding);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (reWriteBind) {
            _encodedSize += 4L;
        }
        Field[] _fields = query.getFields();
        if (!noBinaryTransfer && query.needUpdateFieldFormats()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (Field _field : _fields) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!this.useBinary(_field)) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _field.setFormat(1);
                query.setHasBinaryFields(true);
            }
        }
        if (noBinaryTransfer && query.hasBinaryFields()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (Field _field : _fields) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_field.getFormat() == 0) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _field.setFormat(0);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            query.resetNeedUpdateFieldFormats();
            query.setHasBinaryFields(false);
        }
        int numBinaryFields = !noBinaryTransfer && query.hasBinaryFields() ? _fields.length : 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _encodedSize = (long)(4 + (_encodedPortalName == null ? 0 : _encodedPortalName.length) + 1 + (_encodedStatementName == null ? 0 : _encodedStatementName.length) + 1 + 2 + _params.getParameterCount() * 2 + 2) + _encodedSize + 2L + (long)(numBinaryFields * 2);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_encodedSize > 0x3FFFFFFFL) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KBBindException(new IOException(GT.tr("Bind message length {0} too long.  This can be caused by very large or incorrect length specifications on InputStream _parameters.", _encodedSize)));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(66);
        this.kbStream.sendInteger4((int)_encodedSize);
        if (_encodedPortalName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.send(_encodedPortalName);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(0);
        if (_encodedStatementName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.send(_encodedStatementName);
        }
        this.kbStream.sendChar(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int codeCount = _params.getParameterCount();
        if (reWriteBind) {
            codeCount |= 0x8000;
        }
        this.kbStream.sendInteger2(codeCount);
        for (int i = 1; i <= _params.getParameterCount(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.sendInteger2(_params.isBinary(i) ? 1 : 0);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (reWriteBind) {
            this.kbStream.sendInteger4(_paramss.length);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendInteger2(_params.getParameterCount());
        KBBindException _bindException = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int j = 0; j < _paramss.length; ++j) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _params = _paramss[j];
            for (int i = 1; i <= _params.getParameterCount(); ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_params.isNull(i)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbStream.sendInteger4(-1);
                    continue;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.kbStream.sendInteger4(_params.getV3Length(i, this.client_encoding));
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _params.writeV3Value(i, this.kbStream, this.client_encoding);
                    continue;
                }
                catch (KBBindException be) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _bindException = be;
                }
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendInteger2(numBinaryFields);
        for (int i = 0; i < numBinaryFields; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.sendInteger2(_fields[i].getFormat());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._pendingBindQueue.add(_portal == null ? UNNAMED_PORTAL : _portal);
        if (_bindException != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw _bindException;
        }
    }

    private boolean useBinary(Field _field) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _oid = _field.getOID();
        return this.useBinaryForReceive(_oid);
    }

    private void sendDescribePortal(SimpleQuery query, Portal _portal) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBLOGGER.log(Level.FINEST, " FE=> Describe(_portal={0})", _portal);
        byte[] _encodedPortalName = _portal == null ? null : _portal.getEncodedPortalName();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _encodedSize = 5 + (_encodedPortalName == null ? 0 : _encodedPortalName.length) + 1;
        this.kbStream.sendChar(68);
        this.kbStream.sendInteger4(_encodedSize);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(80);
        if (_encodedPortalName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.send(_encodedPortalName);
        }
        this.kbStream.sendChar(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._pendingDescribePortalQueue.add(query);
        query.setPortalDescribed(true);
    }

    private void sendDescribeStatement(SimpleQuery query, SimpleParameterList _params, boolean describeOnly) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBLOGGER.log(Level.FINEST, " FE=> Describe(stmt={0})", query.getStatementName());
        byte[] _encodedStatementName = query.getEncodedStatementName();
        int _encodedSize = 5 + (_encodedStatementName == null ? 0 : _encodedStatementName.length) + 1;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(68);
        this.kbStream.sendInteger4(_encodedSize);
        this.kbStream.sendChar(83);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_encodedStatementName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.send(_encodedStatementName);
        }
        this.kbStream.sendChar(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._pendingDescribeStatementQueue.add(new DescribeRequest(query, _params, describeOnly, query.getStatementName()));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._pendingDescribePortalQueue.add(query);
        query.setStatementDescribed(true);
        query.setPortalDescribed(true);
    }

    private void sendExecute(SimpleQuery query, Portal _portal, int limit) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            KBLOGGER.log(Level.FINEST, " FE=> Execute(_portal={0},limit={1})", _portal, limit);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] _encodedPortalName = _portal == null ? null : _portal.getEncodedPortalName();
        int _encodedSize = _encodedPortalName == null ? 0 : _encodedPortalName.length;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(69);
        this.kbStream.sendInteger4(5 + _encodedSize + 4);
        if (_encodedPortalName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.send(_encodedPortalName);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(0);
        this.kbStream.sendInteger4(limit);
        this._pendingExecuteQueue.add(new ExecuteRequest(query, _portal, false));
    }

    private void sendClosePortal(String _portalName) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBLOGGER.log(Level.FINEST, " FE=> ClosePortal({0})", _portalName);
        byte[] _encodedPortalName = _portalName == null ? null : Utils._encodeUTF8(_portalName);
        int _encodedSize = _encodedPortalName == null ? 0 : _encodedPortalName.length;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(67);
        this.kbStream.sendInteger4(6 + _encodedSize);
        this.kbStream.sendChar(80);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_encodedPortalName != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.send(_encodedPortalName);
        }
        this.kbStream.sendChar(0);
    }

    private void sendCloseStatement(String stmtName) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBLOGGER.log(Level.FINEST, " FE=> CloseStatement({0})", stmtName);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] _encodedStatementName = Utils._encodeUTF8(stmtName);
        this.kbStream.sendChar(67);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendInteger4(5 + _encodedStatementName.length + 1);
        this.kbStream.sendChar(83);
        this.kbStream.send(_encodedStatementName);
        this.kbStream.sendChar(0);
    }

    private void sendSimpleQuery(SimpleQuery query, SimpleParameterList _params) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String nativeSql = query.toString(_params);
        String info = " FE=> SimpleQuery(query=\"{0}\")";
        KBLOGGER.log(Level.FINEST, " FE=> SimpleQuery(query=\"{0}\")", nativeSql);
        Encoding _encoding = this.kbStream.getEncoding();
        byte[] _encoded = _encoding.encode(nativeSql);
        this.kbStream.sendChar(81);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendInteger4(_encoded.length + 4 + 1);
        this.kbStream.send(_encoded);
        this.kbStream.sendChar(0);
        this.kbStream.flush();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._pendingExecuteQueue.add(new ExecuteRequest(query, null, true));
        this._pendingDescribePortalQueue.add(query);
    }

    private void registerParsedQuery(SimpleQuery query, String stmtName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (stmtName == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        PhantomReference<SimpleQuery> cleanupReference = new PhantomReference<SimpleQuery>(query, this.parsedQueryCleanupQueue);
        this.parsedQueryMap.put(cleanupReference, stmtName);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        query.setCleanupRef(cleanupReference);
    }

    private void processDeadParsedQueries() throws IOException {
        Reference<SimpleQuery> deadQueryReference;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while ((deadQueryReference = this.parsedQueryCleanupQueue.poll()) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String stmtName = this.parsedQueryMap.remove(deadQueryReference);
            this.sendCloseStatement(stmtName);
            deadQueryReference.clear();
        }
    }

    private void registerOpenPortal(Portal _portal) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_portal == UNNAMED_PORTAL) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _portalName = _portal.getPortalName();
        PhantomReference<Portal> cleanupRef = new PhantomReference<Portal>(_portal, this.openPortalCleanupQueue);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.openPortalMap.put(cleanupRef, _portalName);
        _portal.setCleanupRef(cleanupRef);
    }

    private void processDeadPortals() throws IOException {
        Reference<Portal> deadPortal;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while ((deadPortal = this.openPortalCleanupQueue.poll()) != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _portalName = this.openPortalMap.remove(deadPortal);
            this.sendClosePortal(_portalName);
            deadPortal.clear();
        }
    }

    @Override
    public synchronized CopyOperation startCopy(String _sql, boolean suppressBegin) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.waitOnLock_();
        if (!suppressBegin) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.doSubprotocolBegin();
        }
        byte[] bufffer = null;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            bufffer = Utils.encode(_sql, this.client_encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            unsupportedEncodingException.printStackTrace();
        }
        try {
            KBLOGGER.log(Level.FINEST, " FE=> Query(CopyStart)", new Object[0]);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.sendChar(81);
            this.kbStream.sendInteger4(bufffer.length + 4 + 1);
            this.kbStream.send(bufffer);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbStream.sendChar(0);
            this.kbStream.flush();
            return this.processCopyResults(null, true);
        }
        catch (IOException ioException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Database _connection failed when starting copy", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ioException);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void processResults(ResultHandler _handler, int _flags) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        noResults = (_flags & 4) != 0;
        bothRowsAndStatus = (_flags & 64) != 0;
        _tuples = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        endQueryT = false;
        lastMsg = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        doneAfterRowDescNoDataT = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        block25: while (!endQueryT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            charT = this.kbStream.receiveChar();
            switch (charT) {
                case 65: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveAsyncNotify_();
                    continue block25;
                }
                case 49: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbStream.receiveInteger4();
                    parsedQuery = this._pendingParseQueue.removeFirst();
                    parsedStatementName = parsedQuery.getStatementName();
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBLOGGER.log(Level.FINEST, " <=BE ParseComplete [{0}]", new Object[]{parsedStatementName});
                    if (this.isEnd) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.describeOnly = false;
                        this.hast = false;
                        this.lastQueries.clear();
                        this.lastQuery = null;
                        this.level = -1;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.isEnd = false;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    lastMsg = 49;
                    continue block25;
                }
                case 116: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbStream.receiveInteger4();
                    KBLOGGER.log(Level.FINEST, " <=BE ParameterDescription", new Object[0]);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    describeData = this._pendingDescribeStatementQueue.getFirst();
                    simpleQuery = describeData.query;
                    _params = describeData._parameterList;
                    this.describeOnly = describeData.describeOnly;
                    this.hast = true;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    origStatNameT = describeData.stmtName;
                    numParams = this.kbStream.receiveInteger2();
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    for (i = 1; i <= numParams; ++i) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        typeOid = this.kbStream.receiveInteger4();
                        _params.setResolvedType(i, typeOid);
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (origStatNameT == null && simpleQuery.getStatementName() == null || origStatNameT != null && origStatNameT.equals(simpleQuery.getStatementName())) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        simpleQuery.setPrepareTypes(_params.getTypeOIDs());
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (this.describeOnly) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        doneAfterRowDescNoDataT = true;
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this._pendingDescribeStatementQueue.removeFirst();
                    }
                    lastMsg = 116;
                    continue block25;
                }
                case 50: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbStream.receiveInteger4();
                    boundPortal = this._pendingBindQueue.removeFirst();
                    KBLOGGER.log(Level.FINEST, " <=BE BindComplete [{0}]", new Object[]{boundPortal});
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.registerOpenPortal(boundPortal);
                    lastMsg = 50;
                    continue block25;
                }
                case 51: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbStream.receiveInteger4();
                    KBLOGGER.log(Level.FINEST, " <=BE CloseComplete", new Object[0]);
                    lastMsg = 51;
                    continue block25;
                }
                case 110: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbStream.receiveInteger4();
                    KBLOGGER.log(Level.FINEST, " <=BE NoData", new Object[0]);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.lastQuery = query22 = this._pendingDescribePortalQueue.removeFirst();
                    if (doneAfterRowDescNoDataT) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        describeData = this._pendingDescribeStatementQueue.removeFirst();
                        currentQuery = describeData.query;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _fields = currentQuery.getFields();
                        if (_fields != null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuples = new ArrayList<E>();
                            _handler.handleResultRows(currentQuery, _fields, _tuples, null);
                            _tuples = null;
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.lastQueries.add(currentQuery);
                    }
                    if (this.level == -1) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.level = 1;
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++this.level;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    lastMsg = 110;
                    continue block25;
                }
                case 115: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbStream.receiveInteger4();
                    KBLOGGER.log(Level.FINEST, " <=BE PortalSuspended", new Object[0]);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    executeData = this._pendingExecuteQueue.removeFirst();
                    currentQuery = executeData.query;
                    currentPortal = executeData._portal;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _fields = currentQuery.getFields();
                    if (_fields != null && _tuples == null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuples = noResults != false ? Collections.emptyList() : new ArrayList<byte[][]>();
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _handler.handleResultRows(currentQuery, _fields, _tuples, currentPortal);
                    _tuples = null;
                    lastMsg = 115;
                    continue block25;
                }
                case 67: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    statusT = this.receiveCommandStatus();
                    if (this.isFlushCacheOnDeallocate() && (statusT.startsWith("DEALLOCATE ALL") || statusT.startsWith("DISCARD ALL"))) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this._deallocateEpoch = (short)(this._deallocateEpoch + 1);
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    doneAfterRowDescNoDataT = false;
                    executeDataT = this._pendingExecuteQueue.peekFirst();
                    currentQueryT = executeDataT.query;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (lastMsg == 67) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.resetField = true;
                    }
                    isLastResultSet = this.resetField;
                    if (this.resetField) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        currentQueryT.setFields(this.firstFields);
                    }
                    if (this.level > 0) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        --this.level;
                    }
                    if (this.resetField || this.level == 0) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.lastQuery = null;
                        this.firstFields = null;
                        this.resetField = false;
                        this.popStack = true;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    currentPortal = executeDataT._portal;
                    if (statusT.startsWith("SET")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        nativeSqlStr = currentQueryT.getNativeQuery().nativeSql;
                        if (nativeSqlStr.lastIndexOf("search_path", 1024) != -1 && !nativeSqlStr.equals(this.lastSetSearchPathQuery)) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.lastSetSearchPathQuery = nativeSqlStr;
                            this._deallocateEpoch = (short)(this._deallocateEpoch + 1);
                        }
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (!executeDataT.asSimple) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (this.popStack) {
                            this._pendingExecuteQueue.removeFirst();
                        }
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    }
                    if (currentQueryT == this.autoSaveQuery || currentQueryT == this.releaseAutoSave) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        continue block25;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _fields = currentQueryT.getFields();
                    if (_fields != null && _tuples == null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuples = noResults != false ? Collections.emptyList() : new ArrayList<byte[][]>();
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (_fields == null && _tuples != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throw new IllegalStateException("Received _resultset _tuples, but no _field structure for them");
                    }
                    if (_fields != null || _tuples != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _handler.handleResultRows(this.firstFields != null ? null : currentQueryT, _fields, _tuples, null, isLastResultSet);
                        _tuples = null;
                        if (bothRowsAndStatus) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.interpretCommandStatus(statusT, _handler);
                        }
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.interpretCommandStatus(statusT, _handler);
                    }
                    if (executeDataT.asSimple) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        currentQueryT.setFields(null);
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (currentPortal != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        currentPortal.close();
                    }
                    lastMsg = 67;
                    continue block25;
                }
                case 68: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    tupleT = null;
                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        tupleT = this.kbStream.receiveTupleV3();
                    }
                    catch (OutOfMemoryError oome) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (noResults) ** GOTO lbl226
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _handler.handleError(new KSQLException(GT.tr("Ran out of memory retrieving query _results.", new Object[0]), KSQLState.OUT_OF_MEMORY, (Throwable)oome));
                    }
lbl226:
                    // 3 sources

                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (!noResults) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (_tuples == null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _tuples = new ArrayList<E>();
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _tuples.add(tupleT);
                    }
                    if (KBLOGGER.isLoggable(Level.FINEST)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (tupleT == null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            len = -1;
                        } else {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            len = 0;
                            for (byte[] aTupleT : tupleT) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                if (aTupleT == null) {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    continue;
                                }
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                len += aTupleT.length;
                            }
                        }
                        KBLOGGER.log(Level.FINEST, " <=BE DataRow(leng={0})", new Object[]{len});
                    }
                    if (lastMsg == 67) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.resetField = true;
                    }
                    lastMsg = 68;
                    continue block25;
                }
                case 69: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _error = this.receiveErrorResponse();
                    _handler.handleError(_error);
                    if (this.willHealViaReparse(_error)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this._deallocateEpoch = (short)(this._deallocateEpoch + 1);
                        if (KBLOGGER.isLoggable(Level.FINEST)) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            KBLOGGER.log(Level.FINEST, " FE: received {0}, will invalidate stmts. _deallocateEpoch is now {1}", new Object[]{_error.getSQLState(), this._deallocateEpoch});
                        }
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.lastQuery = null;
                    this.firstFields = null;
                    this.describeOnly = false;
                    this.hast = false;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.resetField = false;
                    this.popStack = true;
                    this.currentIsBatch = false;
                    this.lastQueries.clear();
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.level = -1;
                    lastMsg = 69;
                    continue block25;
                }
                case 73: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbStream.receiveInteger4();
                    KBLOGGER.log(Level.FINEST, " <=BE EmptyQuery", new Object[0]);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    executeData = this._pendingExecuteQueue.removeFirst();
                    currentPortal = executeData._portal;
                    _handler.handleCommandStatus("EMPTY", 0L, 0L);
                    if (currentPortal != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        currentPortal.close();
                    }
                    lastMsg = 73;
                    continue block25;
                }
                case 78: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _warning = this.receiveNoticeResponse();
                    _handler.handleWarning(_warning);
                    continue block25;
                }
                case 83: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    try {
                        this.receiveParameterStatus();
                    }
                    catch (SQLException sqlException) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _handler.handleError(sqlException);
                        endQueryT = true;
                    }
                    continue block25;
                }
                case 84: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _fields = this.receiveFields();
                    _tuples = new ArrayList<byte[][]>();
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    query = this._pendingDescribePortalQueue.peekFirst();
                    if (lastMsg == 110 || lastMsg == 84 || (this.hast || this.describeOnly) && lastMsg == 50 && !this.currentIsBatch || lastMsg == 50 && query.getNativeSql().equals("SYNC")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.popStack = false;
                        if ((this.hast || this.describeOnly) && lastMsg == 50 && !this.lastQueries.isEmpty() && this.lastQueries.peekFirst().getNativeSql().equalsIgnoreCase(this._pendingExecuteQueue.peekFirst().query.getNativeSql())) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.lastQuery = this.lastQueries.removeFirst();
                        }
                        if (this.lastQuery == null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.lastQuery = this._pendingExecuteQueue.peekFirst().query;
                            if (this.level == -1 || this.level == 0) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                this.level = 1;
                            }
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        query = this.lastQuery;
                        this.firstFields = query.getFields();
                    }
                    if (!this._pendingExecuteQueue.isEmpty() && !this._pendingExecuteQueue.peekFirst().asSimple && !query.getNativeSql().equalsIgnoreCase("SYNC") && this.popStack) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this._pendingDescribePortalQueue.removeFirst();
                    }
                    if (!this.popStack) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        query = this.lastQuery;
                    }
                    query.setFields(_fields);
                    if (doneAfterRowDescNoDataT) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        describeData = this._pendingDescribeStatementQueue.removeFirst();
                        currentQuery = describeData.query;
                        currentQuery.setFields(_fields);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _handler.handleResultRows(currentQuery, _fields, _tuples, null);
                        _tuples = null;
                        this.lastQueries.add(currentQuery);
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.lastQuery = query;
                    if (this.level == -1) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.level = 1;
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++this.level;
                    }
                    lastMsg = 84;
                    continue block25;
                }
                case 90: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveRFQ_();
                    if (!this._pendingExecuteQueue.isEmpty() && this._pendingExecuteQueue.peekFirst().asSimple) {
                        _tuples = null;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        executeRequest = this._pendingExecuteQueue.removeFirst();
                        executeRequest.query.setFields(null);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this._pendingDescribePortalQueue.removeFirst();
                        if (!this._pendingExecuteQueue.isEmpty()) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (this.getTransactionState() == TransactionState.IDLE) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                _handler.secureProgress();
                            }
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            continue block25;
                        }
                    }
                    endQueryT = true;
                    while (!this._pendingParseQueue.isEmpty()) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        failedQuery = this._pendingParseQueue.removeFirst();
                        failedQuery.reset();
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this._pendingParseQueue.clear();
                    while (!this._pendingDescribeStatementQueue.isEmpty()) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        request = this._pendingDescribeStatementQueue.removeFirst();
                        KBLOGGER.log(Level.FINEST, " FE marking setStatementDescribed(false) for query {0}", new Object[]{request.query});
                        request.query.setStatementDescribed(false);
                    }
                    while (!this._pendingDescribePortalQueue.isEmpty()) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        describePortalQuery = this._pendingDescribePortalQueue.removeFirst();
                        KBLOGGER.log(Level.FINEST, " FE marking setPortalDescribed(false) for query {0}", new Object[]{describePortalQuery});
                        describePortalQuery.setPortalDescribed(false);
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this._pendingBindQueue.clear();
                    this._pendingExecuteQueue.clear();
                    lastMsg = 90;
                    this.isEnd = true;
                    this.hast = false;
                    continue block25;
                }
                case 71: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBLOGGER.log(Level.FINEST, " <=BE CopyInResponse", new Object[0]);
                    KBLOGGER.log(Level.FINEST, " FE=> CopyFail", new Object[0]);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _buf = Utils._encodeUTF8("COPY commands are only supported using the CopyManager API.");
                    this.kbStream.sendChar(102);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.kbStream.sendInteger4(_buf.length + 4 + 1);
                    this.kbStream.send(_buf);
                    this.kbStream.sendChar(0);
                    this.kbStream.flush();
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.sendSync_();
                    this.skipMessage_();
                    lastMsg = 71;
                    continue block25;
                }
                case 72: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBLOGGER.log(Level.FINEST, " <=BE CopyOutResponse", new Object[0]);
                    this.skipMessage_();
                    _handler.handleError(new KSQLException(GT.tr("COPY commands are only supported using the CopyManager API.", new Object[0]), KSQLState.NOT_IMPLEMENTED));
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    lastMsg = 72;
                    continue block25;
                }
                case 99: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.skipMessage_();
                    KBLOGGER.log(Level.FINEST, " <=BE CopyDone", new Object[0]);
                    lastMsg = 99;
                    continue block25;
                }
                case 100: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.skipMessage_();
                    KBLOGGER.log(Level.FINEST, " <=BE CopyData", new Object[0]);
                    lastMsg = 100;
                    continue block25;
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException("Unexpected packet type: " + charT);
        }
    }

    private void skipMessage_() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int leng = this.kbStream.receiveInteger4();
        assert (leng >= 4) : "Length from skip message must be at least 4 ";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.skip(leng - 4);
    }

    @Override
    public synchronized void fetch(ResultCursor cursor, ResultHandler _handler, int fetchSize) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.waitOnLock_();
        final Portal _portal = (Portal)cursor;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultHandler _delegateHandler = _handler;
        _handler = new ResultHandlerDelegate(_delegateHandler){

            @Override
            public void handleCommandStatus(String status, long updateNum, long insertOID) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.handleResultRows(_portal.getQuery(), null, new ArrayList<byte[][]>(), null);
            }
        };
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.processDeadParsedQueries();
            this.processDeadPortals();
            this.sendExecute(_portal.getQuery(), _portal, fetchSize);
            this.sendSync_();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.processResults(_handler, 0);
            this._estimatedReceiveBufferBytes = 0;
        }
        catch (IOException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.abort();
            _handler.handleError(new KSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _handler.handleCompletion();
    }

    private void sendOneQuery(SimpleQuery query, SimpleParameterList[] _params, int maxRows, int fetchSize, int _flags, boolean reWrite) throws IOException {
        boolean describeStatement;
        int rowsNum;
        boolean asSimple;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean bl = asSimple = (_flags & 0x400) != 0;
        if (asSimple) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            assert ((_flags & 0x20) == 0) : "Simple mode does not support describe requests. _sql = " + query.getNativeSql() + ", _flags = " + _flags;
            this.sendSimpleQuery(query, _params[0]);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        assert (!query.getNativeQuery().isMultiStat) : "Queries that might contain ; must be executed with QueryExecutor.QUERY_EXECUTE_AS_SIMPLE mode. Given query is " + query.getNativeSql();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean noResultsT = (_flags & 4) != 0;
        boolean noMeta = (_flags & 2) != 0;
        boolean describeOnly = (_flags & 0x20) != 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean usePortal = (_flags & 8) != 0 && !noResultsT && !noMeta && fetchSize > 0 && !describeOnly;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean oneShot = (_flags & 1) != 0;
        boolean noBinaryTransfer = (_flags & 0x100) != 0;
        boolean forceDescribePortal = (_flags & 0x200) != 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (noResultsT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            rowsNum = 1;
        } else if (!usePortal) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            rowsNum = maxRows;
        } else if (maxRows != 0 && fetchSize > maxRows) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            rowsNum = maxRows;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            rowsNum = fetchSize;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.sendParse(query, _params[0], oneShot);
        boolean queryHasUnknown = query.hasUnresolvedTypes();
        boolean _paramsHasUnknown = _params[0].hasUnresolvedTypes();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean bl2 = describeStatement = describeOnly || !oneShot && _paramsHasUnknown && queryHasUnknown && !query.isStatementDescribed();
        if (!describeStatement && _paramsHasUnknown && !queryHasUnknown) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int[] queryOIDs = query.getPrepareTypes();
            int[] _paramOIDs = _params[0].getTypeOIDs();
            for (int i = 0; i < _paramOIDs.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (_paramOIDs[i] != 0) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _params[0].setResolvedType(i + 1, queryOIDs[i]);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (describeStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.sendDescribeStatement(query, _params[0], describeOnly);
            if (describeOnly) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return;
            }
        }
        Portal _portal = null;
        if (usePortal) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _portalName = "C_" + this.nextUniqueID++;
            _portal = new Portal(query, _portalName);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.sendBind(query, _params, _portal, noBinaryTransfer, reWrite);
        if (!noMeta && !describeStatement) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!query.isPortalDescribed() || forceDescribePortal) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.sendDescribePortal(query, _portal);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.sendExecute(query, _portal, rowsNum);
    }

    private Field[] receiveFields() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.receiveInteger4();
        int size = this.kbStream.receiveInteger2();
        Field[] _fields = new Field[size];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            KBLOGGER.log(Level.FINEST, " <=BE RowDescription({0})", size);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = 0; i < _fields.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _columnLabel = this.kbStream.receiveString();
            int tablOid = this.kbStream.receiveInteger4();
            short positionInTable = (short)this.kbStream.receiveInteger2();
            int typeOid = this.kbStream.receiveInteger4();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int typeLength = this.kbStream.receiveInteger2();
            int typeModifier = this.kbStream.receiveInteger4();
            int formatType = this.kbStream.receiveInteger2();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _fields[i] = new Field(_columnLabel, typeOid, typeLength, typeModifier, tablOid, positionInTable);
            _fields[i].setFormat(formatType);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, "        {0}", _fields[i]);
        }
        return _fields;
    }

    private void receiveAsyncNotify_() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int leng = this.kbStream.receiveInteger4();
        assert (leng > 4) : "Length for AsyncNotify must be at least 4";
        int pid = this.kbStream.receiveInteger4();
        String msg = this.kbStream.receiveString();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _param = this.kbStream.receiveString();
        this.addNotification(new Notification(msg, pid, _param));
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, " <=BE AsyncNotify({0},{1},{2})", pid, msg, _param);
        }
    }

    private SQLException receiveErrorResponse() throws IOException {
        String _sql;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int eleng = this.kbStream.receiveInteger4();
        assert (eleng > 4) : "Error response length must be greater than 4";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        EncodingPredictor.DecodeResult totalMessage = this.kbStream.receiveErrorString(eleng - 4);
        String string = _sql = this._pendingDescribePortalQueue.peekFirst() == null ? null : this._pendingDescribePortalQueue.peekFirst().getNativeSql();
        if ("SYNC".equalsIgnoreCase(_sql)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = this._pendingExecuteQueue.peekFirst() == null ? null : this._pendingExecuteQueue.peekFirst().query.getNativeSql();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ServerErrorMessage _errorMsg = new ServerErrorMessage(totalMessage, _sql);
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            KBLOGGER.log(Level.FINEST, " <=BE ErrorMessage({0})", _errorMsg.toString());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KSQLException _error = new KSQLException(_errorMsg, this.logServerErrorDetail);
        if (this.transactionFailedCauseT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.transactionFailedCauseT = _error;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _error.initCause(this.transactionFailedCauseT);
        }
        return _error;
    }

    private SQLWarning receiveNoticeResponse() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int nleng = this.kbStream.receiveInteger4();
        assert (nleng > 4) : "Notice Response length must be greater than 4";
        ServerErrorMessage warnMsg = new ServerErrorMessage(this.kbStream.receiveString(nleng - 4), null);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, " <=BE NoticeResponse({0})", warnMsg.toString());
        }
        KSQLWarning ksqlWarning = new KSQLWarning(warnMsg);
        return ksqlWarning;
    }

    private void interpretCommandStatus(String status, ResultHandler _handler) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            this.commandCompleteParser.parse(status);
        }
        catch (SQLException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _handler.handleError(e);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long _oid = this.commandCompleteParser.getOid();
        long _count = this.commandCompleteParser.getRows();
        _handler.handleCommandStatus(status, _count, _oid);
    }

    private String receiveCommandStatus() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int leng = this.kbStream.receiveInteger4();
        String status = this.kbStream.receiveString(leng - 5);
        this.kbStream.receiveChar();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBLOGGER.log(Level.FINEST, " <=BE CommandStatus({0})", status);
        return status;
    }

    private void receiveRFQ_() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.kbStream.receiveInteger4() != 5) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException("unexpected length of ReadyForQuery message");
        }
        char transactionStatus = (char)this.kbStream.receiveChar();
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, " <=BE ReadyForQuery({0})", Character.valueOf(transactionStatus));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ('T' == transactionStatus) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.transactionFailedCauseT = null;
            this.setTransactionState(TransactionState.OPEN);
        } else if ('I' == transactionStatus) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.transactionFailedCauseT = null;
            this.setTransactionState(TransactionState.IDLE);
        } else if ('E' == transactionStatus) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setTransactionState(TransactionState.FAILED);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException("unexpected transaction state in ReadyForQuery message: " + transactionStatus);
        }
    }

    @Override
    protected void sendCloseMessage() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(88);
        this.kbStream.sendInteger4(4);
    }

    public void readStartupMessages() throws IOException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        block7: for (int j = 0; j < 1000; ++j) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int receiveChar = this.kbStream.receiveChar();
            switch (receiveChar) {
                case 90: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveRFQ_();
                    return;
                }
                case 75: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int massageLength = this.kbStream.receiveInteger4();
                    if (massageLength != 12) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        throw new KSQLException(GT.tr("Protocol _error.  Session setup failed.", new Object[0]), KSQLState.PROTOCOL_VIOLATION);
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int pidT = this.kbStream.receiveInteger4();
                    int c_key = this.kbStream.receiveInteger4();
                    if (KBLOGGER.isLoggable(Level.FINEST)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, " <=BE BackendKeyData(pid={0},c_key={1})", pidT, c_key);
                    }
                    this.setBackendKeyData(pidT, c_key);
                    continue block7;
                }
                case 78: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.addWarning(this.receiveNoticeResponse());
                    continue block7;
                }
                case 69: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw this.receiveErrorResponse();
                }
                case 83: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveParameterStatus();
                    continue block7;
                }
                default: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (KBLOGGER.isLoggable(Level.FINEST)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        KBLOGGER.log(Level.FINEST, "  invalid message type={0}", Character.valueOf((char)receiveChar));
                    }
                    throw new KSQLException(GT.tr("Protocol _error.  Session setup failed.", new Object[0]), KSQLState.PROTOCOL_VIOLATION);
                }
            }
        }
        throw new KSQLException(GT.tr("Protocol _error.  Session setup failed.", new Object[0]), KSQLState.PROTOCOL_VIOLATION);
    }

    public void receiveParameterStatus() throws IOException, SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.receiveInteger4();
        String name = this.kbStream.receiveString();
        String _value = this.kbStream.receiveString();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, " <=BE ParameterStatus({0} = {1})", name, _value);
        }
        if (name != null && !name.equals("")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.onParameterStatus(name, _value);
        }
        if (name.equals("client_encoding")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.allowEncodingChanges) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (!Encoding.getDatabaseEncoding(_value).name().equalsIgnoreCase(Encoding.getDatabaseEncoding(this.client_encoding).name())) {
                    KBLOGGER.log(Level.FINE, "kbjdbc expects client_encoding to be {0} for proper operation. Actual _encoding is {1}", this.client_encoding, _value);
                }
            } else if (!Encoding.getDatabaseEncoding(_value).name().equalsIgnoreCase(Encoding.getDatabaseEncoding(this.client_encoding).name())) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.close();
                throw new KSQLException(GT.tr("The server''s client_encoding _parameter was changed to {0}. The JDBC driver requires client_encoding to be {1} for correct operation.", _value, this.client_encoding), KSQLState.CONNECTION_FAILURE);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.client_encoding = Encoding.getDatabaseEncoding(_value).name();
            this.kbStream.setEncoding(Encoding.getDatabaseEncoding(_value));
        }
        if (name.equals("DateStyle") && !_value.startsWith("ISO") && !_value.toUpperCase().startsWith("ISO")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.close();
            throw new KSQLException(GT.tr("The server''s DateStyle _parameter was changed to {0}. The JDBC driver requires DateStyle to begin with ISO for correct operation.", _value), KSQLState.CONNECTION_FAILURE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (name.equals("standard_conforming_strings")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_value.equals("on")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setStandardConformingStrings(true);
            } else if (_value.equals("off")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setStandardConformingStrings(false);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.close();
                throw new KSQLException(GT.tr("The server''s standard_conforming_strings _parameter was reported as {0}. The JDBC driver expected on or off.", _value), KSQLState.CONNECTION_FAILURE);
            }
            return;
        }
        if ("TimeZone".equals(name)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setTimeZone(TimestampUtils.parseBackendTimeZone(_value));
        } else if ("application_name".equals(name)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setApplicationName(_value);
        } else if ("server_version_num".equals(name)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setServerVersionNum(Integer.parseInt(_value));
        } else if ("server_version".equals(name)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setServerVersion(_value);
        } else if ("integer_datetimes".equals(name)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if ("on".equals(_value)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setIntegerDateTimes_(true);
            } else if ("off".equals(_value)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setIntegerDateTimes_(false);
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Protocol _error.  Session setup failed.", new Object[0]), KSQLState.PROTOCOL_VIOLATION);
            }
        }
    }

    public void setTimeZone(TimeZone tz) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.tz = tz;
    }

    @Override
    public TimeZone getTimeZone() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.tz;
    }

    public void setApplicationName(String _applicationName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.applicationNameT = _applicationName;
    }

    @Override
    public String getApplicationName() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.applicationNameT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "".intern();
        }
        return this.applicationNameT;
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.replicationProtocolT;
    }

    @Override
    public boolean useBinaryForReceive(int _oid) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.useBinaryReceiveForOids.contains(_oid);
    }

    @Override
    public void setBinaryReceiveOids(Set<Integer> _oids) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.useBinaryReceiveForOids.clear();
        this.useBinaryReceiveForOids.addAll(_oids);
    }

    @Override
    public boolean useBinaryForSend(int _oid) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.useBinarySendForOids.contains(_oid);
    }

    @Override
    public void setBinarySendOids(Set<Integer> oidsSet) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.useBinarySendForOids.clear();
        this.useBinarySendForOids.addAll(oidsSet);
    }

    @Override
    public boolean getIntegerDateTimes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.integerDateTimesT;
    }

    private void setIntegerDateTimes_(boolean stateT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.integerDateTimesT = stateT;
    }
}

