/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.core;

import com.kingbase8.Driver;
import com.kingbase8.KBProperty;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ConnectionMangerV2 {
    public static Map<String, ConnectionMangerV2> clustersMap = new HashMap<String, ConnectionMangerV2>();
    public static Object globallock = new Object();
    public Properties pros = new Properties();
    public String password;
    public String dbName;
    public String clusterKey;
    public ConcurrentHashMap<String, String> rates = new ConcurrentHashMap();
    public ConcurrentHashMap<String, AtomicInteger> _hostA_count = new ConcurrentHashMap();
    public ConcurrentHashMap<String, AtomicInteger> totalA_count = new ConcurrentHashMap();
    public AtomicInteger lastSlaveID = new AtomicInteger(0);
    public Object lock = new Object();
    public ClusterMonitorThread ctmonitor = null;
    public int monitor_retry_times = 0;
    public Thread thread_ct = null;
    public DispatchConnection ctmonitor_connect = null;
    public volatile String slave_online_ip = new String("");
    public volatile String master_online_ip = new String("");
    public Map<String, Integer> _connVersion = new HashMap<String, Integer>();
    public boolean monitorUp;
    public Map<String, String> nodeMap = new HashMap<String, String>();
    private BigDecimal differentLsn;
    public Map<String, BigDecimal> loadRateMap = new HashMap<String, BigDecimal>();
    public ConcurrentHashMap<String, BigDecimal> actualLoadRateMap = new ConcurrentHashMap();
    public ConcurrentHashMap<String, AtomicInteger> actualCounts = new ConcurrentHashMap();
    private volatile SQLException sqlException = null;
    private volatile Exception exception = null;

    public Exception getException() {
        Exception exception2 = this.exception;
        return exception2;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public SQLException getSqlException() {
        SQLException sqlException2 = this.sqlException;
        return sqlException2;
    }

    public void setSqlException(SQLException sqlException) {
        this.sqlException = sqlException;
    }

    public ConnectionMangerV2(String cluster_key, Properties ppros) throws KSQLException {
        String[] nodes;
        this.clusterKey = cluster_key;
        this.pros = new Properties(ppros);
        this.password = KBProperty.PASSWORD.get(this.pros);
        this.dbName = KBProperty.KB_DBNAME.get(this.pros);
        for (String node : nodes = KBProperty.NODE_LIST.get(this.pros) == null ? new String[]{} : KBProperty.NODE_LIST.get(this.pros).split(",")) {
            this._connVersion.put(node, 0);
        }
        this.initNodeMap(this.pros);
        if (KBProperty.READ_LIST_STRATEGY.getInt(this.pros) == 3) {
            try {
                this.differentLsn = new BigDecimal(KBProperty.DIFFERENT_LSN.get(this.pros));
            }
            catch (NumberFormatException e) {
                throw new KSQLException("The value of differentLsn must be a number,now is [" + KBProperty.DIFFERENT_LSN.get(this.pros) + "].", KSQLState.INVALID_PARAMETER_VALUE, (Throwable)e);
            }
        }
        if (KBProperty.LOADBALANCE_STRATEGY.getInt(this.pros) == 3) {
            this.initLoadRate(this.pros);
        }
        this.ctmonitor = new ClusterMonitorThread(this);
        this.thread_ct = new Thread((Runnable)this.ctmonitor, "JDBC cluster monitor [ " + this.clusterKey + " ] ");
        this.thread_ct.setDaemon(true);
        this.thread_ct.start();
        while (!this.monitorUp) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getClusterKey(Properties pros) throws SQLException {
        String temp;
        String[] slavePorts;
        String[] _hosts = KBProperty.KB_HOST.get(pros).split(",");
        String[] _hostPorts = KBProperty.KB_PORT.get(pros).split(",");
        String slaveList = KBProperty.SLAVE_ADD.get(pros);
        String slavePortList = KBProperty.SLAVE_PORT.get(pros);
        String[] slaves = slaveList == null || slaveList.isEmpty() ? new String[]{} : slaveList.split(",");
        String[] stringArray = slavePorts = slavePortList == null || slavePortList.isEmpty() ? new String[]{} : slavePortList.split(",");
        if (slaves.length != slavePorts.length || _hosts.length != _hostPorts.length) {
            throw new KSQLException("The number of cluster machines's address does not match the number of cluster machines's ports.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        Object[] cluster_key = new String[slaves.length + _hosts.length];
        int i = 0;
        int j = 0;
        for (i = 0; i < _hosts.length; ++i) {
            temp = _hosts[i] + ":" + _hostPorts[i];
            cluster_key[i] = temp;
        }
        for (j = 0; j < slaves.length; ++j) {
            temp = slaves[j] + ":" + slavePorts[j];
            cluster_key[j + i] = temp;
        }
        Arrays.sort(cluster_key);
        return Arrays.toString(cluster_key) + " readListStrategy=" + KBProperty.READ_LIST_STRATEGY.getInt(pros);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DispatchConnection createConnection(String url, String passward, String dbName, Properties pros) throws SQLException {
        String clusterKey = ConnectionMangerV2.getClusterKey(pros);
        if (clustersMap.get(clusterKey) == null) {
            Object object = globallock;
            synchronized (object) {
                if (clustersMap.get(clusterKey) == null) {
                    ConnectionMangerV2 tempCM2 = new ConnectionMangerV2(clusterKey, pros);
                    clustersMap.put(clusterKey, tempCM2);
                }
            }
        }
        ConnectionMangerV2 tempCM2 = clustersMap.get(clusterKey);
        DispatchConnection _conn = new DispatchConnection(null, passward, dbName, pros, tempCM2);
        if ((KBProperty.LOADBALANCE_STRATEGY.getInt(pros) == 1 || KBProperty.LOADBALANCE_STRATEGY.getInt(pros) == 2) && tempCM2.rates.get(_conn.countUrl) == null) {
            tempCM2.rates.put(_conn.countUrl, KBProperty.HOSTLOADRATE.get(pros));
            tempCM2._hostA_count.put(_conn.countUrl, new AtomicInteger(0));
            tempCM2.totalA_count.put(_conn.countUrl, new AtomicInteger(0));
        }
        return _conn;
    }

    public void initNodeMap(Properties pros) throws KSQLException {
        int i;
        String[] slavePorts;
        String nodeList = KBProperty.NODE_LIST.get(pros);
        if (nodeList == null || nodeList.isEmpty()) {
            throw new KSQLException("The nodeList cannot be empty.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        String[] nodes = nodeList.split(",");
        String[] _hosts = KBProperty.KB_HOST.get(pros).split(",");
        String[] _hostPorts = KBProperty.KB_PORT.get(pros).split(",");
        String slaveList = KBProperty.SLAVE_ADD.get(pros);
        String slavePortList = KBProperty.SLAVE_PORT.get(pros);
        String[] slaves = slaveList == null || slaveList.isEmpty() ? new String[]{} : slaveList.split(",");
        String[] stringArray = slavePorts = slavePortList == null || slavePortList.isEmpty() ? new String[]{} : slavePortList.split(",");
        if (slaves.length != slavePorts.length) {
            throw new KSQLException("The number of standby machines does not match the number of ports.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        if (slaves.length + _hosts.length != nodes.length) {
            throw new KSQLException("The number of _hosts does not match the number of nodes.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        for (i = 0; i < _hosts.length; ++i) {
            this.nodeMap.put(_hosts[i] + ":" + _hostPorts[i], nodes[i]);
        }
        for (i = _hosts.length; i < nodes.length; ++i) {
            this.nodeMap.put(slaves[i - _hosts.length] + ":" + slavePorts[i - _hosts.length], nodes[i]);
        }
    }

    public void initLoadRate(Properties pros) throws KSQLException {
        String[] nodes;
        String loadRates = KBProperty.LOAD_RATE.get(pros);
        if (loadRates == null || loadRates.isEmpty()) {
            throw new KSQLException("The loadRateList cannot be empty.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        String[] loadRate = loadRates.split(":");
        if (loadRate.length != (nodes = KBProperty.NODE_LIST.get(pros).split(",")).length) {
            throw new KSQLException("The number of load rate does not match the number of nodes.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (Integer.valueOf(loadRate[i]) > 0) {
                this.loadRateMap.put(nodes[i], new BigDecimal(loadRate[i]));
                this.actualLoadRateMap.put(nodes[i], new BigDecimal(loadRate[i]));
            }
            this.actualCounts.put(nodes[i], new AtomicInteger(0));
        }
        BigDecimal totalLoadRate = new BigDecimal(0);
        for (String key : this.loadRateMap.keySet()) {
            totalLoadRate = totalLoadRate.add(this.loadRateMap.get(key));
        }
        this.loadRateMap.put("all", totalLoadRate);
        this.actualCounts.put("all", new AtomicInteger(0));
    }

    public class ClusterMonitorThread
    implements Runnable {
        private ExecutorService executorService;
        private Properties pros;
        private ConnectionMangerV2 mCMV2;
        private int times = 0;

        ClusterMonitorThread(ConnectionMangerV2 pCMV2) {
            this.mCMV2 = pCMV2;
            this.pros = new Properties(this.mCMV2.pros);
            this.executorService = Executors.newCachedThreadPool();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            try {
                String lastMasterName = null;
                String lastMasterHost = null;
                HashMap<String, Boolean> lastSlaveStates = new HashMap<String, Boolean>();
                for (Map.Entry<String, String> entry : ConnectionMangerV2.this.nodeMap.entrySet()) {
                    lastSlaveStates.put(entry.getKey(), false);
                }
                ConnectionMangerV2.this.monitor_retry_times = KBProperty.MONITOR_RETRY_TIMES.getIntNoCheck(this.pros);
                while (true) {
                    int monitor_interval = KBProperty.MONITORINTERVAL.getIntNoCheck(this.pros);
                    int clearCountInterval = KBProperty.CLEAR_COUNT_INTERVAL.getIntNoCheck(this.pros);
                    try {
                        Map<String, Number> map;
                        if (ConnectionMangerV2.this.ctmonitor_connect == null) {
                            KBLOGGER.log(Level.SEVERE, "create new ctmonitor_connect", new Object[0]);
                            this.pros.setProperty("isMonitor", "true");
                            this.pros.setProperty("socketTimeout", KBProperty.MONITOR_SOCKET_TIMEOUT.getInt(this.pros) + "");
                            if (ConnectionMangerV2.this.monitor_retry_times == KBProperty.MONITOR_RETRY_TIMES.getIntNoCheck(this.pros)) {
                                map = ConnectionMangerV2.this._connVersion;
                                synchronized (map) {
                                    for (String ip : ConnectionMangerV2.this._connVersion.keySet()) {
                                        ConnectionMangerV2.this._connVersion.put(ip, ConnectionMangerV2.this._connVersion.get(ip) + 1);
                                    }
                                }
                            }
                            ConnectionMangerV2.this.ctmonitor_connect = new DispatchConnection(null, ConnectionMangerV2.this.password, ConnectionMangerV2.this.dbName, this.pros, this.mCMV2);
                            this.mCMV2.setSqlException(null);
                            this.mCMV2.setException(null);
                        }
                        if (clearCountInterval > 0 && this.times * monitor_interval >= clearCountInterval) {
                            if (KBProperty.LOADBALANCE_STRATEGY.getInt(this.pros) == 1 || KBProperty.LOADBALANCE_STRATEGY.getInt(this.pros) == 2) {
                                map = this.mCMV2.totalA_count;
                                synchronized (map) {
                                    if (!this.mCMV2.totalA_count.containsKey(ConnectionMangerV2.this.ctmonitor_connect.countUrl)) {
                                        this.mCMV2.totalA_count.put(ConnectionMangerV2.this.ctmonitor_connect.countUrl, new AtomicInteger(0));
                                    }
                                    if (!this.mCMV2._hostA_count.containsKey(ConnectionMangerV2.this.ctmonitor_connect.countUrl)) {
                                        this.mCMV2._hostA_count.put(ConnectionMangerV2.this.ctmonitor_connect.countUrl, new AtomicInteger(0));
                                    }
                                    this.mCMV2.totalA_count.get(ConnectionMangerV2.this.ctmonitor_connect.countUrl).set(0);
                                    this.mCMV2._hostA_count.get(ConnectionMangerV2.this.ctmonitor_connect.countUrl).set(0);
                                    this.times = 0;
                                }
                            }
                            if (KBProperty.LOADBALANCE_STRATEGY.getInt(this.pros) == 3) {
                                map = this.mCMV2.actualCounts;
                                synchronized (map) {
                                    for (String node : this.mCMV2.actualCounts.keySet()) {
                                        this.mCMV2.actualCounts.get(node).set(0);
                                    }
                                    this.times = 0;
                                }
                            }
                        }
                        ++this.times;
                        ConnectionMangerV2.this.master_online_ip = ConnectionMangerV2.this.nodeMap.get(((KbConnection)ConnectionMangerV2.this.ctmonitor_connect.getMainConn()).getHostIp() + ":" + ((KbConnection)ConnectionMangerV2.this.ctmonitor_connect.getMainConn()).getHostPort());
                        String _sql = "select application_name";
                        if (KBProperty.READ_LIST_STRATEGY.getInt(this.pros) == 2 || KBProperty.READ_LIST_STRATEGY.getInt(this.pros) == 4) {
                            _sql = _sql + ",sync_state";
                        } else if (KBProperty.READ_LIST_STRATEGY.getInt(this.pros) == 3) {
                            _sql = _sql + ",pg_wal_lsn_diff(pg_current_wal_flush_lsn(), replay_lsn)";
                        }
                        _sql = _sql + " from pg_stat_replication";
                        Statement stcheck = ConnectionMangerV2.this.ctmonitor_connect.getMainConn().createStatement();
                        ResultSet resultSet = stcheck.executeQuery(_sql);
                        String sip = "";
                        while (resultSet.next()) {
                            if (KBProperty.READ_LIST_STRATEGY.getInt(this.pros) == 2) {
                                if (!"sync".equalsIgnoreCase(resultSet.getString(2))) continue;
                                sip = sip + resultSet.getString(1);
                                sip = sip + ",";
                                continue;
                            }
                            if (KBProperty.READ_LIST_STRATEGY.getInt(this.pros) == 3) {
                                if (resultSet.getBigDecimal(2).compareTo(ConnectionMangerV2.this.differentLsn) > 0) continue;
                                sip = sip + resultSet.getString(1);
                                sip = sip + ",";
                                continue;
                            }
                            if (KBProperty.READ_LIST_STRATEGY.getInt(this.pros) == 4) {
                                if ("sync".equalsIgnoreCase(resultSet.getString(2))) continue;
                                sip = sip + resultSet.getString(1);
                                sip = sip + ",";
                                continue;
                            }
                            sip = sip + resultSet.getString(1);
                            sip = sip + ",";
                        }
                        resultSet.close();
                        String[] nodeNames = sip.split(",");
                        HashMap<String, Future<Boolean>> tryConnectResult = new HashMap<String, Future<Boolean>>();
                        for (String nodeName : nodeNames) {
                            if (nodeName.isEmpty()) continue;
                            for (Map.Entry<String, String> entry : ConnectionMangerV2.this.nodeMap.entrySet()) {
                                String[] split;
                                String key = entry.getKey();
                                String value = entry.getValue();
                                if (!nodeName.equalsIgnoreCase(value) || (split = key.split(":")).length != 2) continue;
                                String host = split[0];
                                String port = split[1];
                                String dbName = ConnectionMangerV2.this.ctmonitor_connect.m_pros.getProperty("DBNAME");
                                String url = "jdbc:kingbase8://" + host + ":" + port + "/" + dbName;
                                Properties slaveprop = new Properties(ConnectionMangerV2.this.ctmonitor_connect.m_pros);
                                slaveprop.setProperty("HOST", host);
                                slaveprop.setProperty("PORT", port);
                                slaveprop.setProperty("URL", url);
                                Future<Boolean> submit = this.executorService.submit(new TryConnect(slaveprop));
                                tryConnectResult.put(key, submit);
                            }
                        }
                        String slave_ip = "";
                        for (Map.Entry entry : tryConnectResult.entrySet()) {
                            String key = (String)entry.getKey();
                            Future value = (Future)entry.getValue();
                            String nodeName = ConnectionMangerV2.this.nodeMap.get(key);
                            if (!((Boolean)value.get()).booleanValue()) {
                                if (!((Boolean)lastSlaveStates.get(key)).booleanValue()) continue;
                                ConnectionMangerV2.this._connVersion.put(nodeName, ConnectionMangerV2.this._connVersion.get(nodeName) + 1);
                                lastSlaveStates.put(key, false);
                                continue;
                            }
                            lastSlaveStates.put(key, true);
                            if (slave_ip.contains(nodeName)) continue;
                            slave_ip = slave_ip + nodeName;
                            slave_ip = slave_ip + ",";
                        }
                        ConnectionMangerV2.this.slave_online_ip = slave_ip;
                        if (ConnectionMangerV2.this.slave_online_ip.isEmpty()) {
                            Boolean bmaster = false;
                            _sql = String.format("select * from pg_is_in_recovery()", new Object[0]);
                            resultSet = stcheck.executeQuery(_sql);
                            if (resultSet.next()) {
                                bmaster = !resultSet.getBoolean(1);
                            }
                            resultSet.close();
                            if (!bmaster.booleanValue()) {
                                try {
                                    ConnectionMangerV2.this.master_online_ip = "";
                                    ConnectionMangerV2.this.ctmonitor_connect.CloseConnectCluter();
                                    ConnectionMangerV2.this.ctmonitor_connect = null;
                                }
                                catch (SQLException e1) {
                                    ConnectionMangerV2.this.ctmonitor_connect = null;
                                }
                            }
                        }
                        KBLOGGER.log(Level.SEVERE, "ClusterMonitorThread master online: {0}, current slave online: {1}, cluster_key: {2}", ConnectionMangerV2.this.master_online_ip, ConnectionMangerV2.this.slave_online_ip, this.mCMV2.clusterKey);
                        stcheck.close();
                        ConnectionMangerV2.this.monitor_retry_times = KBProperty.MONITOR_RETRY_TIMES.getIntNoCheck(this.pros);
                        if (ConnectionMangerV2.this.ctmonitor_connect != null) {
                            String cur = ConnectionMangerV2.this.ctmonitor_connect.getQueryExecutor().getHostSpec().getHost();
                            if (ConnectionMangerV2.this.master_online_ip != "" && ConnectionMangerV2.this.master_online_ip.equals(lastMasterName) && !cur.equals(lastMasterHost)) {
                                ConnectionMangerV2.this._connVersion.put(ConnectionMangerV2.this.master_online_ip, ConnectionMangerV2.this._connVersion.get(ConnectionMangerV2.this.master_online_ip) + 1);
                                lastMasterHost = cur;
                            } else {
                                lastMasterName = ConnectionMangerV2.this.master_online_ip;
                                lastMasterHost = cur;
                            }
                        }
                    }
                    catch (SQLException e) {
                        KBLOGGER.log(Level.SEVERE, "ClusterMonitorThread check slave info Exception: {0} {1}", e.getMessage(), this.mCMV2.clusterKey);
                        KBLOGGER.log(Level.SEVERE, e);
                        if (ConnectionMangerV2.this.monitor_retry_times > 0 && (e.getCause() != null && "Read timed out".equals(e.getCause().getMessage()) || e.getMessage().contains("connect timed out"))) {
                            --ConnectionMangerV2.this.monitor_retry_times;
                            int retry_times = KBProperty.MONITOR_RETRY_TIMES.getIntNoCheck(this.pros);
                            KBLOGGER.log(Level.SEVERE, "Start ClusterMonitorThread retry check slave info, total times: " + retry_times + " current times: " + (retry_times - ConnectionMangerV2.this.monitor_retry_times), new Object[0]);
                        } else {
                            ConnectionMangerV2.this.monitor_retry_times = KBProperty.MONITOR_RETRY_TIMES.getIntNoCheck(this.pros);
                            ConnectionMangerV2.this.slave_online_ip = "";
                            ConnectionMangerV2.this.master_online_ip = "";
                        }
                        this.mCMV2.setSqlException(e);
                        if (ConnectionMangerV2.this.ctmonitor_connect != null) {
                            try {
                                ConnectionMangerV2.this.ctmonitor_connect.CloseConnectCluter();
                                ConnectionMangerV2.this.ctmonitor_connect = null;
                                KBLOGGER.log(Level.SEVERE, "close CloseConnectCluter normal", new Object[0]);
                            }
                            catch (SQLException e1) {
                                ConnectionMangerV2.this.ctmonitor_connect = null;
                                KBLOGGER.log(Level.SEVERE, "close CloseConnectCluter exception:{0}", e1);
                            }
                        }
                    }
                    catch (Exception e2) {
                        this.mCMV2.setException(e2);
                        ConnectionMangerV2.this.monitor_retry_times = KBProperty.MONITOR_RETRY_TIMES.getIntNoCheck(this.pros);
                        ConnectionMangerV2.this.ctmonitor_connect = null;
                        KBLOGGER.log(Level.SEVERE, "close CloseConnectCluter exception:{0}", e2);
                        KBLOGGER.log(Level.SEVERE, e2);
                    }
                    finally {
                        ConnectionMangerV2.this.monitorUp = true;
                    }
                    try {
                        Thread.sleep(monitor_interval * 1000);
                    }
                    catch (InterruptedException e) {
                        KBLOGGER.log(Level.SEVERE, "ClusterMonitorThread InterruptedException: {0} {1}", e.getMessage(), this.mCMV2.clusterKey);
                        KBLOGGER.log(Level.SEVERE, e);
                    }
                }
            }
            catch (Exception e) {
                KBLOGGER.log(Level.SEVERE, "ClusterMonitorThread has occurred the most severe exception,causing the heartbeat thread to exit!  Exception: {0} {1}", e.getMessage(), this.mCMV2.clusterKey);
                KBLOGGER.log(Level.SEVERE, e);
                return;
            }
        }
    }

    private static class TryConnect
    implements Callable<Boolean> {
        private Properties properties;

        public TryConnect(Properties properties) {
            this.properties = properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            Boolean connectSuccess = false;
            Connection conn = null;
            try {
                String url = this.properties.getProperty("URL");
                conn = new KbConnection(Driver._hostSpecs(this.properties), Driver.user(this.properties), Driver.database(this.properties), this.properties, url, -1, null);
                connectSuccess = true;
            }
            catch (Exception exception) {
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return connectSuccess;
        }
    }
}

