/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.Driver;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.Query;
import com.kingbase8.core.ServerVersion;
import com.kingbase8.core.TypeInfo;
import com.kingbase8.core.v3.BatchedQuery;
import com.kingbase8.core.v3.SimpleQuery;
import com.kingbase8.jdbc.BooleanTypeUtil;
import com.kingbase8.jdbc.CompatibleDB;
import com.kingbase8.jdbc.KbArray;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.jdbc.KbParameterMetaData;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.jdbc.KbSQLXML;
import com.kingbase8.jdbc.KbStatement;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.jdbc.PrimitiveArraySupport;
import com.kingbase8.jdbc.ResultWrapper;
import com.kingbase8.jdbc.TimestampUtils;
import com.kingbase8.largeobject.LargeObject;
import com.kingbase8.largeobject.LargeObjectManager;
import com.kingbase8.util.ByteConverter;
import com.kingbase8.util.GT;
import com.kingbase8.util.HStoreConverter;
import com.kingbase8.util.KBBinaryObject;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KBTime;
import com.kingbase8.util.KBTimestamp;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.ReaderInputStream;
import com.kingbase8.util.TraceLogger;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;

public class KbPreparedStatement
extends KbStatement
implements PreparedStatement {
    private static final boolean TRUE = true;
    protected ParameterList preparedParameterList;
    protected final CachedQuery preparedQuery;
    private TimeZone defaultTimeZoneT;
    protected List<String> preparedParameterNames = new ArrayList<String>();

    KbPreparedStatement(KbConnection _connection, String _sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this(_connection, _connection.borrowQuery(_sql), resultSetType, resultSetConcurrency, resultSetHoldability);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public void copyPreparedStatementInfo(KbPreparedStatement stnew) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.preparedParameterList = stnew.preparedParameterList;
        this.defaultTimeZoneT = stnew.defaultTimeZoneT;
    }

    KbPreparedStatement(KbConnection _connection, CachedQuery query, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(_connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.preparedQuery = query;
        this.preparedParameterList = this.preparedQuery.query.createParameterList();
        Query[] queries = this.preparedQuery.query.getSubqueries();
        if (queries == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.preparedParameterNames.addAll(((SimpleQuery)this.preparedQuery.query).getNativeQuery()._bindParamNames);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int i = 0; i < queries.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.preparedParameterNames.addAll(((SimpleQuery)queries[i]).getNativeQuery()._bindParamNames);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_connection.isOptimizeBatchedDML() && _connection.getPreferQueryMode().compareTo(PreferQueryMode.SIMPLE) > 0 && this.preparedQuery.query.getSqlCommand() != null && this.preparedQuery.query.getSqlCommand().isDML() && this.preparedParameterList.getParameterCount() > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.reWriteBind = true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setPoolable(true);
    }

    public ParameterList getPreParmlist() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.preparedParameterList;
    }

    public void setPreParmlist(ParameterList preParm) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.preparedParameterList = preParm;
    }

    @Override
    public ResultSet executeQuery(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Can''t use query mtds that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.executeWithFlags(0)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSingleResultSetT();
    }

    @Override
    public int executeUpdate(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Can''t use query mtds that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public int executeUpdate() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.executeWithFlags(4);
        this.checkNoResultUpdate_();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int count = this.getUpdateCount();
        return count;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.executeWithFlags(4);
        this.checkNoResultUpdate_();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long count = this.getLargeUpdateCount();
        return count;
    }

    @Override
    public boolean execute(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Can''t use query mtds that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public boolean execute() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.executeWithFlags(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int _flags) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.checkIsClosed_();
            if (this.baseConnection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _flags |= 0x400;
            }
            this.execute(this.preparedQuery, this.preparedParameterList, _flags);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KbPreparedStatement kbPreparedStatement = this;
            synchronized (kbPreparedStatement) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.checkIsClosed_();
                boolean bl = this.resultT != null && this.resultT.getResultSet() != null;
                return bl;
            }
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.defaultTimeZoneT = null;
        }
    }

    @Override
    protected boolean isOneShotQuery(CachedQuery _cachedQuery) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_cachedQuery == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _cachedQuery = this.preparedQuery;
        }
        return super.isOneShotQuery(_cachedQuery);
    }

    @Override
    public void closeImpl_() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.preparedQuery != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ((KbConnection)this.baseConnection).releaseQuery(this.preparedQuery);
        }
    }

    @Override
    public void setNull(int _parameterIndex, int _sqlType) throws SQLException {
        int oidT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _sqlType: {1}", _parameterIndex, _sqlType);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_parameterIndex < 1 || _parameterIndex > this.preparedParameterList.getParameterCount()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("The _column _index is out of range: {0}, number of _columns: {1}.", _parameterIndex, this.preparedParameterList.getInParameterCount()), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        switch (_sqlType) {
            case 4: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 23;
                break;
            }
            case 2009: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 142;
                break;
            }
            case -6: 
            case 5: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 21;
                break;
            }
            case 6: 
            case 8: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 701;
                break;
            }
            case -5: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 20;
                break;
            }
            case 7: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 700;
                break;
            }
            case -9: 
            case -1: 
            case 12: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = this.baseConnection.getStringVarcharFlag() ? 1043 : 0;
                break;
            }
            case 2: 
            case 3: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 1700;
                break;
            }
            case 1: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 1042;
                break;
            }
            case 91: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 1082;
                if (!CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) break;
                oidT = 7944;
                break;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 0;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 0;
                break;
            }
            case -7: 
            case 16: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 16;
                break;
            }
            case 2004: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
                    oidT = 8013;
                    break;
                }
                oidT = 26;
                break;
            }
            case 2011: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
                    oidT = 8015;
                    break;
                }
                throw new KSQLException(GT.tr("Unknown Types _value.", new Object[0]), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2005: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
                    oidT = 8014;
                    break;
                }
                oidT = 26;
                break;
            }
            case -8: {
                if (this.baseConnection.isDatabaseSupportRowid()) {
                    oidT = 6123;
                    break;
                }
                oidT = 27;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 0;
                break;
            }
            default: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Unknown Types _value.", new Object[0]), KSQLState.INVALID_PARAMETER_TYPE);
            }
        }
        this.preparedParameterList.setNull(_parameterIndex, oidT);
    }

    @Override
    public void setByte(int _parameterIndex, byte x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setShort(_parameterIndex, x);
    }

    @Override
    public void setShort(int _parameterIndex, short x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.baseConnection.binaryTransferSend(21)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] value = new byte[2];
            ByteConverter.int2(value, 0, x);
            this._bindBytes(_parameterIndex, value, 21);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._bindLiteral(_parameterIndex, Integer.toString(x), 21);
    }

    @Override
    public void setBoolean(int _parameterIndex, boolean x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._bindLiteral(_parameterIndex, x ? "1" : "0", 23);
        } else if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._bindLiteral(_parameterIndex, x ? "1" : "0", 0);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._bindLiteral(_parameterIndex, x ? "TRUE" : "FALSE", 16);
        }
    }

    @Override
    public void setFloat(int _parameterIndex, float x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, Float.valueOf(x));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.baseConnection.binaryTransferSend(700)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] value = new byte[4];
            ByteConverter.float4(value, 0, x);
            this._bindBytes(_parameterIndex, value, 700);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._bindLiteral(_parameterIndex, Float.toString(x), 701);
    }

    @Override
    public void setDouble(int _parameterIndex, double x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.baseConnection.binaryTransferSend(701)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] value = new byte[8];
            ByteConverter.float8(value, 0, x);
            this._bindBytes(_parameterIndex, value, 701);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._bindLiteral(_parameterIndex, Double.toString(x), 701);
    }

    @Override
    public void setBigDecimal(int _parameterIndex, BigDecimal x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        this.setNumber(_parameterIndex, x);
    }

    @Override
    public void setString(int _parameterIndex, String x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setString(_parameterIndex, x, this.getStringType());
    }

    private int getStringType() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.baseConnection.getStringVarcharFlag() ? 1043 : 0;
    }

    protected void setString(int _parameterIndex, String x, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (x == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.preparedParameterList.setNull(_parameterIndex, oid);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.bindStringT(_parameterIndex, x, oid);
        }
    }

    @Override
    public void setBytes(int _parameterIndex, byte[] x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (null == x) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_parameterIndex, -3);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] copy = new byte[x.length];
        System.arraycopy(x, 0, copy, 0, x.length);
        this.preparedParameterList.setBytea(_parameterIndex, copy, 0, x.length);
    }

    @Override
    public void setDate(int _parameterIndex, java.sql.Date x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setDate(_parameterIndex, x, null);
    }

    @Override
    public void setTime(int _parameterIndex, Time x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setTime(_parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int _parameterIndex, Timestamp x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setTimestamp(_parameterIndex, x, null);
    }

    private void setCharacterStreamPost71(int _parameterIndex, InputStream x, int length, String _encoding) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (x == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_parameterIndex, 12);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (length < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            int charactersRead;
            char[] characters;
            block7: {
                int n;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                InputStreamReader inputStream = new InputStreamReader(x, _encoding);
                characters = new char[length];
                charactersRead = 0;
                do {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    n = inputStream.read(characters, charactersRead, length - charactersRead);
                    if (n == -1) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        break block7;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                } while ((charactersRead += n) != length);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setString(_parameterIndex, new String(characters, 0, charactersRead), 1043);
        }
        catch (UnsupportedEncodingException uee) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("The JVM claims not to support the {0} _encoding.", _encoding), KSQLState.UNEXPECTED_ERROR, (Throwable)uee);
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Provided InputStream failed.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setAsciiStream(int _parameterIndex, InputStream x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}, length: {2}", _parameterIndex, x, length);
        }
        this.setCharacterStreamPost71(_parameterIndex, x, length, "ASCII");
    }

    @Override
    public void setUnicodeStream(int _parameterIndex, InputStream x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}, length: {2}", _parameterIndex, x, length);
        }
        this.setCharacterStreamPost71(_parameterIndex, x, length, "UTF-8");
    }

    @Override
    public void setBinaryStream(int _parameterIndex, InputStream x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}, length: {2}", _parameterIndex, x, length);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (x == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_parameterIndex, -3);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (length < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.preparedParameterList.setBytea(_parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.preparedParameterList.clear();
    }

    private void setKBobject(int _parameterIndex, KBobject x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String typename = x.getType();
        int oid = this.baseConnection.getTypeInfo().getKBType(typename);
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unknown type {0}.", typename), KSQLState.INVALID_PARAMETER_TYPE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (x instanceof KBBinaryObject && this.baseConnection.binaryTransferSend(oid)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBBinaryObject binObj = (KBBinaryObject)((Object)x);
            byte[] data = new byte[binObj.lengthInBytes()];
            binObj.toBytes(data, 0);
            this._bindBytes(_parameterIndex, data, oid);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setString(_parameterIndex, x.getValue(), oid);
        }
    }

    private void setMap(int _parameterIndex, Map<?, ?> x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int oid = this.baseConnection.getTypeInfo().getKBType("hstore");
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No hstore extension installed.", new Object[0]), KSQLState.INVALID_PARAMETER_TYPE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.baseConnection.binaryTransferSend(oid)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] data = HStoreConverter.toBytes(x, this.baseConnection.getEncoding());
            this._bindBytes(_parameterIndex, data, oid);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setString(_parameterIndex, HStoreConverter.toString(x), oid);
        }
    }

    private void setNumber(int _parameterIndex, Number x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (x == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_parameterIndex, 3);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._bindLiteral(_parameterIndex, x.toString(), 1700);
        }
    }

    @Override
    public void setObject(int parameterIndexT, Object input, int targetSqlType, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}, targetSqlType: {2}, scale: {3}", parameterIndexT, input, targetSqlType, scale);
        }
        if (input == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(parameterIndexT, targetSqlType);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (targetSqlType == 1111 && input instanceof UUID && this.baseConnection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setUuid(parameterIndexT, (UUID)input);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        switch (targetSqlType) {
            case 2009: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof SQLXML) {
                    this.setSQLXML(parameterIndexT, (SQLXML)input);
                    break;
                }
                this.setSQLXML(parameterIndexT, new KbSQLXML(this.baseConnection, input.toString()));
                break;
            }
            case 4: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setInt(parameterIndexT, KbPreparedStatement.castToInt(input));
                break;
            }
            case -6: 
            case 5: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setShort(parameterIndexT, KbPreparedStatement.castToShort(input));
                break;
            }
            case -5: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setLong(parameterIndexT, KbPreparedStatement.castToLong(input));
                break;
            }
            case 7: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setFloat(parameterIndexT, KbPreparedStatement.castToFloat(input));
                break;
            }
            case 6: 
            case 8: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setDouble(parameterIndexT, KbPreparedStatement.castToDouble(input));
                break;
            }
            case 2: 
            case 3: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setBigDecimal(parameterIndexT, KbPreparedStatement.castToBigDecimal(input, scale));
                break;
            }
            case 1: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setString(parameterIndexT, KbPreparedStatement.castToString(input), 1042);
                break;
            }
            case -9: 
            case 12: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setString(parameterIndexT, KbPreparedStatement.castToString(input), this.getStringType());
                break;
            }
            case -1: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof InputStream) {
                    this.preparedParameterList.setText(parameterIndexT, (InputStream)input);
                    break;
                }
                this.setString(parameterIndexT, KbPreparedStatement.castToString(input), this.getStringType());
                break;
            }
            case 91: {
                java.sql.Date tmpd;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof java.sql.Date) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setDate(parameterIndexT, (java.sql.Date)input);
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof Date) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    tmpd = new java.sql.Date(((Date)input).getTime());
                } else {
                    if (input instanceof LocalDate) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.setDate(parameterIndexT, (LocalDate)input);
                        break;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    tmpd = this.baseConnection.getTimestampUtils().toDate(this.getDefaultCalendar(), input.toString());
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setDate(parameterIndexT, tmpd);
                break;
            }
            case 92: {
                Time tmpt;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof Time) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setTime(parameterIndexT, (Time)input);
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof Date) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    tmpt = new Time(((Date)input).getTime());
                } else {
                    if (input instanceof LocalTime) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.setTime(parameterIndexT, (LocalTime)input);
                        break;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    tmpt = this.baseConnection.getTimestampUtils().toTime(this.getDefaultCalendar(), input.toString());
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setTime(parameterIndexT, tmpt);
                break;
            }
            case 93: {
                Timestamp tmpts;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof KBTimestamp) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setObject(parameterIndexT, input);
                    break;
                }
                if (input instanceof Timestamp) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setTimestamp(parameterIndexT, (Timestamp)input);
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof Date) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    tmpts = new Timestamp(((Date)input).getTime());
                } else {
                    if (input instanceof LocalDateTime) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.setTimestamp(parameterIndexT, (LocalDateTime)input);
                        break;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    tmpts = this.baseConnection.getTimestampUtils().toTimestamp(this.getDefaultCalendar(), input.toString());
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setTimestamp(parameterIndexT, tmpts);
                break;
            }
            case 2014: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof OffsetDateTime) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setTimestamp(parameterIndexT, (OffsetDateTime)input);
                    break;
                }
                if (input instanceof KBTimestamp) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setObject(parameterIndexT, input);
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", input.getClass().getName(), "Types.TIMESTAMP_WITH_TIMEZONE"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case -7: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
                    if (input instanceof Boolean) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.setBoolean(parameterIndexT, BooleanTypeUtil.castToBoolean(input, this.baseConnection.getCompatibleLevel()));
                        break;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setString(parameterIndexT, input.toString(), 0);
                    break;
                }
            }
            case 16: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setBoolean(parameterIndexT, BooleanTypeUtil.castToBoolean(input, this.baseConnection.getCompatibleLevel()));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setObject(parameterIndexT, input);
                break;
            }
            case 2004: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof Blob) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setBlob(parameterIndexT, (Blob)input);
                    break;
                }
                if (input instanceof InputStream) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        this.setBinaryStream(parameterIndexT, (InputStream)input);
                        break;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    long oid = this.createBlob(parameterIndexT, (InputStream)input, -1L);
                    this.setLong(parameterIndexT, oid);
                    break;
                }
                if (input instanceof byte[] && CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setBytes(parameterIndexT, (byte[])input);
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", input.getClass().getName(), "Types.BLOB"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2005: 
            case 2011: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof Clob) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setClob(parameterIndexT, (Clob)input);
                    break;
                }
                if (input instanceof String && CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setString(parameterIndexT, (String)input);
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", input.getClass().getName(), "Types.CLOB"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2003: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof Array) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setArray(parameterIndexT, (Array)input);
                    break;
                }
                if (PrimitiveArraySupport.isSupportedPrimitiveArray(input)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setPrimitiveArray(parameterIndexT, input);
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", input.getClass().getName(), "Types.ARRAY"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2001: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.bindStringT(parameterIndexT, input.toString(), 0);
                break;
            }
            case 1111: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof KBobject) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setKBobject(parameterIndexT, (KBobject)input);
                    break;
                }
                if (input instanceof Map) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setMap(parameterIndexT, (Map)input);
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.bindStringT(parameterIndexT, input.toString(), 0);
                break;
            }
            case 2002: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof KBobject) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setKBobject(parameterIndexT, (KBobject)input);
                    break;
                }
                if (!(input instanceof Struct)) break;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setStruct(parameterIndexT, (Struct)input);
                break;
            }
            case -8: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (input instanceof RowId) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setRowId(parameterIndexT, (RowId)input);
                    break;
                }
                if (input instanceof KBobject) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.setKBobject(parameterIndexT, (KBobject)input);
                    break;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.bindStringT(parameterIndexT, input.toString(), 0);
                break;
            }
            default: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Unsupported Types _value: {0}", targetSqlType), KSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    private <A> void setPrimitiveArray(int _parameterIndex, A input) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PrimitiveArraySupport<A> arrayToString = PrimitiveArraySupport.getArraySupport(input);
        TypeInfo typeInfo = this.baseConnection.getTypeInfo();
        int oid = arrayToString.getDefaultArrayTypeOid(typeInfo);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (arrayToString.supportBinaryRepresentation() && this.baseConnection.getPreferQueryMode() != PreferQueryMode.SIMPLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._bindBytes(_parameterIndex, arrayToString.toBinaryRepresentation(this.baseConnection, input), oid);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char delimiter = typeInfo.getArrayDelimiter(oid);
            this.setString(_parameterIndex, arrayToString.toArrayString(delimiter, input), oid);
        }
    }

    private static String asString(Clob input) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return input.getSubString(1L, (int)input.length());
    }

    private static int castToInt(Object input) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (input instanceof String) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Integer.parseInt((String)input);
            }
            if (input instanceof Number) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ((Number)input).intValue();
            }
            if (input instanceof Date) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return (int)((Date)input).getTime();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (input instanceof Boolean) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return (Boolean)input != false ? 1 : 0;
            }
            if (input instanceof Clob) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Integer.parseInt(KbPreparedStatement.asString((Clob)input));
            }
            if (input instanceof Character) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Integer.parseInt(input.toString());
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "int", e);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "int");
    }

    private static short castToShort(Object input) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (input instanceof String) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Short.parseShort((String)input);
            }
            if (input instanceof Number) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ((Number)input).shortValue();
            }
            if (input instanceof Date) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return (short)((Date)input).getTime();
            }
            if (input instanceof Boolean) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return (Boolean)input != false ? (short)1 : 0;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (input instanceof Clob) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Short.parseShort(KbPreparedStatement.asString((Clob)input));
            }
            if (input instanceof Character) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Short.parseShort(input.toString());
            }
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "short", e);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "short");
    }

    private static long castToLong(Object input) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (input instanceof String) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Long.parseLong((String)input);
            }
            if (input instanceof Number) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ((Number)input).longValue();
            }
            if (input instanceof Date) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ((Date)input).getTime();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (input instanceof Boolean) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return (Boolean)input != false ? 1L : 0L;
            }
            if (input instanceof Clob) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Long.parseLong(KbPreparedStatement.asString((Clob)input));
            }
            if (input instanceof Character) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Long.parseLong(input.toString());
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "long", e);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "long");
    }

    private static float castToFloat(Object input) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (input instanceof String) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Float.parseFloat((String)input);
            }
            if (input instanceof Number) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ((Number)input).floatValue();
            }
            if (input instanceof Date) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ((Date)input).getTime();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (input instanceof Boolean) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return (Boolean)input != false ? 1.0f : 0.0f;
            }
            if (input instanceof Clob) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Float.parseFloat(KbPreparedStatement.asString((Clob)input));
            }
            if (input instanceof Character) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Float.parseFloat(input.toString());
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "float", e);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "float");
    }

    private static double castToDouble(Object input) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (input instanceof String) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Double.parseDouble((String)input);
            }
            if (input instanceof Number) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ((Number)input).doubleValue();
            }
            if (input instanceof Date) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return ((Date)input).getTime();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (input instanceof Boolean) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return (Boolean)input != false ? 1.0 : 0.0;
            }
            if (input instanceof Clob) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Double.parseDouble(KbPreparedStatement.asString((Clob)input));
            }
            if (input instanceof Character) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Double.parseDouble(input.toString());
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "double", e);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "double");
    }

    @Override
    public void setInt(int _parameterIndex, int x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.baseConnection.binaryTransferSend(23)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] value = new byte[4];
            ByteConverter.int4(value, 0, x);
            this._bindBytes(_parameterIndex, value, 23);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._bindLiteral(_parameterIndex, Integer.toString(x), 23);
    }

    private static BigDecimal castToBigDecimal(Object input, int scaleT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            BigDecimal bigDecimal = null;
            if (input instanceof String) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                bigDecimal = new BigDecimal((String)input);
            } else if (input instanceof BigDecimal) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                bigDecimal = (BigDecimal)input;
            } else if (input instanceof BigInteger) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                bigDecimal = new BigDecimal((BigInteger)input);
            } else if (input instanceof Long || input instanceof Integer || input instanceof Short || input instanceof Byte) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                bigDecimal = BigDecimal.valueOf(((Number)input).longValue());
            } else if (input instanceof Double || input instanceof Float) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                bigDecimal = BigDecimal.valueOf(((Number)input).doubleValue());
            } else if (input instanceof Date) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                bigDecimal = BigDecimal.valueOf(((Date)input).getTime());
            } else if (input instanceof Boolean) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                bigDecimal = (Boolean)input != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (input instanceof Clob) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                bigDecimal = new BigDecimal(KbPreparedStatement.asString((Clob)input));
            } else if (input instanceof Character) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                bigDecimal = new BigDecimal(new char[]{((Character)input).charValue()});
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (bigDecimal != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (scaleT >= 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    bigDecimal = bigDecimal.setScale(scaleT, RoundingMode.HALF_UP);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return bigDecimal;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "BigDecimal", e);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "BigDecimal");
    }

    private static String castToString(Object input) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (input instanceof String) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return (String)input;
            }
            if (input instanceof Clob) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return KbPreparedStatement.asString((Clob)input);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return input.toString();
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw KbPreparedStatement.cannotCastException(input.getClass().getName(), "String", e);
        }
    }

    private static KSQLException cannotCastException(String fromType, String toType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return KbPreparedStatement.cannotCastException(fromType, toType, null);
    }

    private static KSQLException cannotCastException(String fromType, String toType, Exception cause) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new KSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", fromType, toType), KSQLState.INVALID_PARAMETER_TYPE, (Throwable)cause);
    }

    @Override
    public void setObject(int _parameterIndex, Object x, int targetSqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}, targetSqlType: {2}", _parameterIndex, x, targetSqlType);
        }
        this.setObject(_parameterIndex, x, targetSqlType, -1);
    }

    @Override
    public void setObject(int _parameterIndex, Object x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (x == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_parameterIndex, 1111);
        } else if (x instanceof UUID && this.baseConnection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setUuid(_parameterIndex, (UUID)x);
        } else if (x instanceof SQLXML) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setSQLXML(_parameterIndex, (SQLXML)x);
        } else if (x instanceof String) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (CompatibleDB.pg(this.baseConnection.getCompatibleLevel())) {
                this.setString(_parameterIndex, (String)x);
            } else {
                this.setString(_parameterIndex, (String)x, 0);
            }
        } else if (x instanceof BigDecimal) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBigDecimal(_parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setShort(_parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setInt(_parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setLong(_parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setFloat(_parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setDouble(_parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBytes(_parameterIndex, (byte[])x);
        } else if (x instanceof java.sql.Date) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setDate(_parameterIndex, (java.sql.Date)x);
        } else if (x instanceof Time) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setTime(_parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setTimestamp(_parameterIndex, (Timestamp)x);
        } else if (x instanceof Date) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setDate(_parameterIndex, new java.sql.Date(((Date)x).getTime()));
        } else if (x instanceof Boolean) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBoolean(_parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setByte(_parameterIndex, (Byte)x);
        } else if (x instanceof Blob) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBlob(_parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(_parameterIndex, (Clob)x);
        } else if (x instanceof Array) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setArray(_parameterIndex, (Array)x);
        } else if (x instanceof KBobject) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setKBobject(_parameterIndex, (KBobject)x);
        } else if (x instanceof Character) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setString(_parameterIndex, ((Character)x).toString());
        } else if (x instanceof LocalDate) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setDate(_parameterIndex, (LocalDate)x);
        } else if (x instanceof LocalTime) {
            this.setTime(_parameterIndex, (LocalTime)x);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else if (x instanceof LocalDateTime) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setTimestamp(_parameterIndex, (LocalDateTime)x);
        } else if (x instanceof OffsetDateTime) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setTimestamp(_parameterIndex, (OffsetDateTime)x);
        } else if (x instanceof Map) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setMap(_parameterIndex, (Map)x);
        } else if (x instanceof Number) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNumber(_parameterIndex, (Number)x);
        } else if (PrimitiveArraySupport.isSupportedPrimitiveArray(x)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setPrimitiveArray(_parameterIndex, x);
        } else if (x instanceof Struct) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setStruct(_parameterIndex, (Struct)x);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.setString(_parameterIndex, x.toString(), 0);
                return;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types _value to specify the type to use.", x.getClass().getName()), KSQLState.INVALID_PARAMETER_TYPE);
        }
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.preparedQuery == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return super.toString();
        }
        return this.preparedQuery.query.toString(this.preparedParameterList);
    }

    protected void _bindBytes(int _paramIndex, byte[] b, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.preparedParameterList.setBinaryParameter(_paramIndex, b, oid);
    }

    private void bindStringT(int _paramIndex, String s, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.preparedParameterList.setStringParameter(_paramIndex, s, oid);
    }

    @Override
    public boolean isUseServerPrepare() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.preparedQuery != null && this.mPrepareThreshold != 0 && this.preparedQuery.getExecuteCount() + 1 >= this.mPrepareThreshold;
    }

    @Override
    public void addBatch(String _sql) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        throw new KSQLException(GT.tr("Can''t use query mtds that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public void addBatch() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (this.batchStatementsList == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.batchParametersList = new ArrayList();
            this.batchStatementsList = new ArrayList();
        }
        this.batchParametersList.add(this.preparedParameterList.copy());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Query query = this.preparedQuery.query;
        if (!(query instanceof BatchedQuery) || this.batchStatementsList.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.batchStatementsList.add(query);
        }
    }

    @Override
    public void setArray(int parameterIndex, Array array) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", parameterIndex, array);
        }
        if (array == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(parameterIndex, 2003);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String typename = array.getBaseTypeName();
        int oid = this.baseConnection.getTypeInfo().getKBArrayType(typename);
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unknown type {0}.", typename), KSQLState.INVALID_PARAMETER_TYPE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (array instanceof KbArray) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KbArray arra = (KbArray)array;
            if (arra.isBinary()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._bindBytes(parameterIndex, arra.toBytes(), oid);
                return;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setString(parameterIndex, array.toString(), oid);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        ResultSet resultSet = this.getResultSet();
        if (resultSet == null || ((KbResultSet)resultSet).isResultSetClosed()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _flags = 49;
            KbStatement.StatementResultHandler _handler = new KbStatement.StatementResultHandler(this);
            this.baseConnection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameterList, _handler, 0, 0, _flags);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ResultWrapper wrapper = _handler.getResults();
            if (wrapper != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultSet = wrapper.getResultSet();
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (resultSet != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return resultSet.getMetaData();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ResultSetMetaData v = null;
        return v;
    }

    protected long createBlob(int i, InputStream inputStream, long lengthT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LargeObjectManager largeObjm = this.baseConnection.getLargeObjectAPI();
        long oid = largeObjm.createLO();
        LargeObject lob = largeObjm.open(oid);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        OutputStream outStream = lob.getOutputStream();
        byte[] _buf = new byte[4096];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            long remainingBytes;
            if (lengthT > 0L) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                remainingBytes = lengthT;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                remainingBytes = Long.MAX_VALUE;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int numOfRead = inputStream.read(_buf, 0, lengthT > 0L && remainingBytes < (long)_buf.length ? (int)remainingBytes : _buf.length);
            while (numOfRead != -1 && remainingBytes > 0L) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                outStream.write(_buf, 0, numOfRead);
                numOfRead = inputStream.read(_buf, 0, lengthT > 0L && remainingBytes < (long)_buf.length ? (int)(remainingBytes -= (long)numOfRead) : _buf.length);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (IOException se) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unexpected _error writing large object to database.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                outStream.close();
            }
            catch (Exception e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", i, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (x == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(i, 2004);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBinaryStream(i, x.getBinaryStream());
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        InputStream inputStream = x.getBinaryStream();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long oid = this.createBlob(i, inputStream, x.length());
            this.setLong(i, oid);
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                inputStream.close();
            }
            catch (Exception e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
    }

    private String readerToString(Reader _value, int maxLength) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            int _bufferSize = Math.min(maxLength, 1024);
            StringBuilder v = new StringBuilder(_bufferSize);
            char[] _buf = new char[_bufferSize];
            int nRead = 0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (nRead > -1 && v.length() < maxLength) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                nRead = _value.read(_buf, 0, Math.min(_bufferSize, maxLength - v.length()));
                if (nRead <= 0) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                v.append(_buf, 0, nRead);
            }
            return v.toString();
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Provided Reader failed.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    private String readerToString(Reader _value, long maxLength) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            int _bufferSize = (int)Math.min(maxLength, 1024L);
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            char[] _buf = new char[_bufferSize];
            int nRead = 0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (nRead > -1 && (long)charArrayWriter.size() < maxLength) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                nRead = _value.read(_buf, 0, (int)Math.min((long)_bufferSize, maxLength - (long)charArrayWriter.size()));
                if (nRead <= 0) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                charArrayWriter.append(new String(_buf), 0, nRead);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return charArrayWriter.toString();
        }
        catch (IOException ioe) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Provided Reader failed.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}, length: {2}", i, x, length);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (x == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(i, 12);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (length < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setString(i, this.readerToString(x, length));
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", i, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (x == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(i, 2005);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            this.setCharacterStream(i, x.getCharacterStream());
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Reader inputStream = x.getCharacterStream();
        int length = (int)x.length();
        LargeObjectManager largeObjm = this.baseConnection.getLargeObjectAPI();
        long oid = largeObjm.createLO();
        LargeObject lob = largeObjm.open(oid);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Charset connectionCharset = Charset.forName(this.baseConnection.getEncoding().name());
        OutputStream los = lob.getOutputStream();
        OutputStreamWriter streamWriter = new OutputStreamWriter(los, connectionCharset);
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int cT = inputStream.read();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int pT = 0; cT > -1 && pT < length; ++pT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ((Writer)streamWriter).write(cT);
                cT = inputStream.read();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ((Writer)streamWriter).close();
        }
        catch (IOException ioException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unexpected _error writing large object to database.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)ioException);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setLong(i, oid);
    }

    @Override
    public void setNull(int _parameterIndex, int t, String typeName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _sqlType: {1}, typeName: {2}", _parameterIndex, t, typeName);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (typeName == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_parameterIndex, t);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        TypeInfo typeInfo = this.baseConnection.getTypeInfo();
        int oid = typeInfo.getKBType(typeName);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.preparedParameterList.setNull(_parameterIndex, oid);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    @Override
    public void setDate(int i, java.sql.Date d, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, d: {1}, calendar: {2}", i, d, calendar);
        }
        if (d == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(i, 91);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.baseConnection.binaryTransferSend(1082)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] value = new byte[4];
            TimeZone timezone = calendar != null ? calendar.getTimeZone() : null;
            this.baseConnection.getTimestampUtils().toBinDate(timezone, value, d);
            this.preparedParameterList.setBinaryParameter(i, value, 1082);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (calendar == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            calendar = this.getDefaultCalendar();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Timestamp ts = new Timestamp(d.getTime());
            this.bindStringT(i, this.baseConnection.getTimestampUtils().toString(calendar, ts), ((KbConnection)this.baseConnection).getTimestamptype());
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bindStringT(i, this.baseConnection.getTimestampUtils().toString(calendar, d), 0);
    }

    @Override
    public void setTime(int i, Time t, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, t: {1}, calendar: {2}", i, t, calendar);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (t == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(i, 92);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int oid = 0;
        if (((KbConnection)this.baseConnection).getTimestamptype() == 1114) {
            oid = 1083;
        } else if (((KbConnection)this.baseConnection).getTimestamptype() == 1184) {
            oid = 1266;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (t instanceof KBTime) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBTime pgTime = (KBTime)t;
            if (pgTime.getCalendar() == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oid = 1083;
                if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
                    oid = 7950;
                }
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oid = 1266;
                if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
                    oid = 7950;
                }
                calendar = pgTime.getCalendar();
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (calendar == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            calendar = this.getDefaultCalendar();
        }
        this.bindStringT(i, this.baseConnection.getTimestampUtils().toString(calendar, t), oid);
    }

    @Override
    public void setTimestamp(int i, Timestamp t, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, t: {1}, calendar: {2}", i, t, calendar);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (t == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(i, 93);
            return;
        }
        int oidT = ((KbConnection)this.baseConnection).getTimestamptype();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (t instanceof KBTimestamp) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBTimestamp pgTimestamp = (KBTimestamp)t;
            if (pgTimestamp.getCalendar() == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 1114;
                if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
                    oidT = 7952;
                }
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                oidT = 1184;
                if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
                    oidT = 7954;
                }
                calendar = pgTimestamp.getCalendar();
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (calendar == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            calendar = this.getDefaultCalendar();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bindStringT(i, this.baseConnection.getTimestampUtils().toString(calendar, t), oidT);
    }

    private void setDate(int index, LocalDate localDateT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int oidT = 1082;
        if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
            oidT = 7944;
        }
        this.bindStringT(index, this.baseConnection.getTimestampUtils().toString(localDateT), oidT);
    }

    private void setTime(int index, LocalTime localDateT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int oidT = 1083;
        if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
            oidT = 7950;
        }
        this.bindStringT(index, this.baseConnection.getTimestampUtils().toString(localDateT), oidT);
    }

    private void setTimestamp(int i, OffsetDateTime _offsetDateTime) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int oid = 1184;
        if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
            oid = 7954;
        }
        this.bindStringT(i, this.baseConnection.getTimestampUtils().toString(_offsetDateTime), oid);
    }

    private void setTimestamp(int index, LocalDateTime localDateTimeT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int oidT = 1114;
        if (CompatibleDB.mysql(this.baseConnection.getCompatibleLevel())) {
            oidT = 7952;
        }
        this.bindStringT(index, this.baseConnection.getTimestampUtils().toString(localDateTimeT), oidT);
    }

    public ParameterMetaData createParameterMetaData(BaseConnection _conn, int[] oids) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new KbParameterMetaData(_conn, oids);
    }

    @Override
    public void setObject(int _parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setObject(int _parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setRowId(int _parameterIndex, RowId x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int oid = 27;
            if (this.baseConnection.isDatabaseSupportRowid()) {
                oid = 6123;
            }
            if (x == null || x.toString() == null) {
                this.preparedParameterList.setNull(_parameterIndex, oid);
            } else {
                this.bindStringT(_parameterIndex, x.toString(), oid);
            }
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "setRowId(int, RowId)");
    }

    @Override
    public void setNString(int _parameterIndex, String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setString(_parameterIndex, _value);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "setNString(int, String)");
    }

    @Override
    public void setNCharacterStream(int _parameterIndex, Reader _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader, long)");
    }

    @Override
    public void setNCharacterStream(int _parameterIndex, Reader _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader)");
    }

    @Override
    public void setCharacterStream(int _parameterIndex, Reader _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, _value);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.baseConnection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s = _value != null ? this.readerToString(_value, Integer.MAX_VALUE) : null;
            this.setString(_parameterIndex, s);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ReaderInputStream is = _value != null ? new ReaderInputStream(_value, this.baseConnection.getEncoding().name()) : null;
        this.setObject(_parameterIndex, (Object)is, -1);
    }

    @Override
    public void setBinaryStream(int _parameterIndex, InputStream _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (length > Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), KSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}, length: {2}", _parameterIndex, _value, length);
        }
        this.preparedParameterList.setBytea(_parameterIndex, _value, (int)length);
    }

    @Override
    public void setBinaryStream(int _parameterIndex, InputStream _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, _value);
        }
        this.preparedParameterList.setBytea(_parameterIndex, _value);
    }

    @Override
    public void setAsciiStream(int _parameterIndex, InputStream _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream, long)");
    }

    @Override
    public void setAsciiStream(int _parameterIndex, InputStream _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream)");
    }

    @Override
    public void setCharacterStream(int _parameterIndex, Reader _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}, length: {2}", _parameterIndex, _value, length);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_value == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_parameterIndex, 12);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (length < 0L) {
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setString(_parameterIndex, this.readerToString(_value, length));
    }

    @Override
    public void setNClob(int _parameterIndex, NClob _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setClob(_parameterIndex, _value);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setNClob(int, NClob)");
    }

    @Override
    public void setClob(int _parameterIndex, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setCharacterStream(_parameterIndex, reader);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setClob(int, Reader)");
    }

    @Override
    public void setBlob(int _parameterIndex, InputStream inputStream, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}, length: {2}", _parameterIndex, inputStream, length);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (inputStream == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_parameterIndex, 2004);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (length < 0L) {
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBinaryStream(_parameterIndex, inputStream, length);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long oid = this.createBlob(_parameterIndex, inputStream, length);
        this.setLong(_parameterIndex, oid);
    }

    @Override
    public void setBlob(int _parameterIndex, InputStream inputStream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, inputStream);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (inputStream == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_parameterIndex, 2004);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBinaryStream(_parameterIndex, inputStream);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long oid = this.createBlob(_parameterIndex, inputStream, -1L);
        this.setLong(_parameterIndex, oid);
    }

    @Override
    public void setNClob(int _parameterIndex, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setClob(_parameterIndex, reader, length);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader, long)");
    }

    @Override
    public void setClob(int _parameterIndex, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setCharacterStream(_parameterIndex, reader, (int)length);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "setClob(int, Reader, long)");
    }

    @Override
    public void setNClob(int _parameterIndex, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.notPg(this.baseConnection.getCompatibleLevel())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setClob(_parameterIndex, reader);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader)");
    }

    @Override
    public void setSQLXML(int _parameterIndex, SQLXML xmlObject) throws SQLException {
        String stringValue;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, xmlObject);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String string = stringValue = xmlObject == null ? null : xmlObject.getString();
        if (stringValue == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_parameterIndex, 2009);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setString(_parameterIndex, stringValue, 142);
        }
    }

    private void setUuid(int _parameterIndex, UUID uuid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.baseConnection.binaryTransferSend(2950)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] value = new byte[16];
            ByteConverter.int8(value, 0, uuid.getMostSignificantBits());
            ByteConverter.int8(value, 8, uuid.getLeastSignificantBits());
            this._bindBytes(_parameterIndex, value, 2950);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._bindLiteral(_parameterIndex, uuid.toString(), 2950);
        }
    }

    @Override
    public void setURL(int parameterIndexT, URL url) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw Driver.notImplemented(this.getClass(), "setURL(int,URL)");
    }

    private void setStruct(int _parameterIndex, Struct x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String typename = x.getSQLTypeName();
        int oid = this.baseConnection.getTypeInfo().getKBType(typename);
        if (oid == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unknown type {0}.", typename), KSQLState.INVALID_PARAMETER_TYPE);
        }
        this.setString(_parameterIndex, x.toString(), oid);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            if (this.batchParametersList != null && this.batchParametersList.size() > 1 && this.mPrepareThreshold > 0) {
                this.preparedQuery.increaseExecuteCount(this.mPrepareThreshold);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int[] nArray = super.executeBatch();
            return nArray;
        }
        finally {
            this.defaultTimeZoneT = null;
        }
    }

    private Calendar getDefaultCalendar() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils tsUtils = this.baseConnection.getTimestampUtils();
        if (tsUtils.hasFastDefaultTimeZone()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return tsUtils.getSharedCalendar(null);
        }
        Calendar sharedCalendar = tsUtils.getSharedCalendar(this.defaultTimeZoneT);
        if (this.defaultTimeZoneT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.defaultTimeZoneT = sharedCalendar.getTimeZone();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return sharedCalendar;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _flags = 49;
        KbStatement.StatementResultHandler _handler = new KbStatement.StatementResultHandler(this);
        this.baseConnection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameterList, _handler, 0, 0, _flags);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int[] oidsList = this.preparedParameterList.getTypeOIDs();
        if (oidsList != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.createParameterMetaData(this.baseConnection, oidsList);
        }
        return null;
    }

    @Override
    protected void transformQueriesAndParameters() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.batchParametersList.size() <= 1 || !(this.preparedQuery.query instanceof BatchedQuery)) {
            return;
        }
        BatchedQuery originalQueryT = (BatchedQuery)this.preparedQuery.query;
        int bindCountT = originalQueryT.getBindCount();
        int highestBlockCountT = 128;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int maxValueBlocksT = bindCountT == 0 ? 128 : Integer.highestOneBit(Math.min(Math.max(1, 32766 / bindCountT), 128));
        int unprocessedBatchCountT = this.batchParametersList.size();
        int partialValueBlocksCountT = Integer.bitCount(unprocessedBatchCountT % maxValueBlocksT);
        int fullValueBlocksCountT = unprocessedBatchCountT / maxValueBlocksT;
        int _count = fullValueBlocksCountT + partialValueBlocksCountT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<ParameterList> newBatchParameters = new ArrayList<ParameterList>(_count);
        ArrayList<BatchedQuery> newBatchStatements = new ArrayList<BatchedQuery>(_count);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _offset = 0;
        for (int i = 0; i < _count; ++i) {
            int _valueBlock;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (unprocessedBatchCountT >= maxValueBlocksT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _valueBlock = maxValueBlocksT;
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _valueBlock = Integer.highestOneBit(unprocessedBatchCountT);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            BatchedQuery bq = originalQueryT.deriveForMultiBatch(_valueBlock);
            ParameterList newPl = bq.createParameterList();
            for (int j = 0; j < _valueBlock; ++j) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ParameterList pl = (ParameterList)this.batchParametersList.get(_offset++);
                newPl.appendAll(pl);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newBatchStatements.add(bq);
            newBatchParameters.add(newPl);
            unprocessedBatchCountT -= _valueBlock;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.batchStatementsList = newBatchStatements;
        this.batchParametersList = newBatchParameters;
    }

    public List<Integer> findIndexByName(String name, List<String> parameterNames) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parameterNames == null || parameterNames.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Attempt to obtain a parameter name {0} that does not appear in SQL.", name), KSQLState.INVALID_NAME);
        }
        ArrayList<Integer> _indexes = new ArrayList<Integer>();
        for (int i = 0; i < parameterNames.size(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!name.equals(parameterNames.get(i))) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _indexes.add(i + 1);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_indexes.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Attempt to obtain a parameter name {0} that does not appear in SQL.", name), KSQLState.INVALID_NAME);
        }
        return _indexes;
    }

    public void setIntAtName(String parameterName, int x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setInt(_index, x);
        }
    }

    public void setArrayAtName(String parameterName, Array x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setArray(_index, x);
        }
    }

    public void setAsciiStreamAtName(String parameterName, InputStream _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, _value);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setAsciiStream(_index, _value);
        }
    }

    public void setAsciiStreamAtName(String parameterName, InputStream x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, length: {2}", parameterName, x, length);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setAsciiStream(_index, x, length);
        }
    }

    public void setAsciiStreamAtName(String parameterName, InputStream _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, length: {2}", parameterName, _value, length);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setAsciiStream(_index, _value, length);
        }
    }

    public void setBigDecimalAtName(String parameterName, BigDecimal x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBigDecimal(_index, x);
        }
    }

    public void setBinaryStreamAtName(String parameterName, InputStream _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, _value);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBinaryStream(_index, _value);
        }
    }

    public void setBinaryStreamAtName(String parameterName, InputStream x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, length: {2}", parameterName, x, length);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBinaryStream(_index, x, length);
        }
    }

    public void setBinaryStreamAtName(String parameterName, InputStream _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, length: {2}", parameterName, _value, length);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBinaryStream(_index, _value, length);
        }
    }

    public void setBlobAtName(String parameterName, Blob x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBlob(_index, x);
        }
    }

    public void setBlobAtName(String parameterName, InputStream inputStream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, inputStream);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBlob(_index, inputStream);
        }
    }

    public void setBlobAtName(String parameterName, InputStream inputStream, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, length: {2}", parameterName, inputStream, length);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBlob(_index, inputStream, length);
        }
    }

    public void setBooleanAtName(String parameterName, boolean x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBoolean(_index, x);
        }
    }

    public void setByteAtName(String parameterName, byte x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setByte(_index, x);
        }
    }

    public void setBytesAtName(String parameterName, byte[] x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setBytes(_index, x);
        }
    }

    public void setCharacterStreamAtName(String parameterName, Reader x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, length: {2}", parameterName, x, length);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setCharacterStream(_index, x, length);
        }
    }

    public void setCharacterStreamAtName(String parameterName, Reader _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, _value);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setCharacterStream(_index, _value);
        }
    }

    public void setCharacterStreamAtName(String parameterName, Reader _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, length: {2}", parameterName, _value, length);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setCharacterStream(_index, _value, length);
        }
    }

    public void setClobAtName(String parameterName, Clob x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setClob(_index, x);
        }
    }

    public void setClobAtName(String parameterName, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, reader);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setClob(_index, reader);
        }
    }

    public void setClobAtName(String parameterName, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, length: {2}", parameterName, reader, length);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setClob(_index, reader, length);
        }
    }

    public void setDateAtName(String parameterName, java.sql.Date x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setDate(_index, x);
        }
    }

    public void setDateAtName(String parameterName, java.sql.Date d, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, calendar: {2}", parameterName, d, calendar);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setDate(_index, d, calendar);
        }
    }

    public void setDoubleAtName(String parameterName, double x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setDouble(_index, x);
        }
    }

    public void setFloatAtName(String parameterName, float x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, Float.valueOf(x));
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setFloat(_index, x);
        }
    }

    @Override
    public void setLong(int _parameterIndex, long x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.checkIsClosed_();
        if (KBLOGGER.isLoggable(Level.FINE)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINE, "_parameterIndex: {0}, _parameter: {1}", _parameterIndex, x);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.baseConnection.binaryTransferSend(20)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] value = new byte[8];
            ByteConverter.int8(value, 0, x);
            this._bindBytes(_parameterIndex, value, 20);
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._bindLiteral(_parameterIndex, Long.toString(x), 20);
    }

    public void setLongAtName(String parameterName, long x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setLong(_index, x);
        }
    }

    public void setNCharacterStreamAtName(String parameterName, Reader _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, _value);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNCharacterStream(_index, _value);
        }
    }

    public void setNCharacterStreamAtName(String parameterName, Reader _value, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, length: {2}", parameterName, _value, length);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNCharacterStream(_index, _value, length);
        }
    }

    public void setNClobAtName(String parameterName, NClob _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, _value);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNClob(_index, _value);
        }
    }

    public void setNClobAtName(String parameterName, Reader reader) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, reader);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNClob(_index, reader);
        }
    }

    public void setNClobAtName(String parameterName, Reader reader, long length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, length: {2}", parameterName, reader, length);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setClob(_index, reader, length);
        }
    }

    public void setNStringAtName(String parameterName, String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, _value);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNString(_index, _value);
        }
    }

    public void setNullAtName(String parameterName, int _sqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _sqlType: {1}", parameterName, _sqlType);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_index, _sqlType);
        }
    }

    public void setNullAtName(String parameterName, int t, String typeName) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _sqlType: {1}, typeName: {2}", parameterName, t, typeName);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNull(_index, t, typeName);
        }
    }

    public void setObjectAtName(String parameterName, Object x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setObject(_index, x);
        }
    }

    protected void _bindLiteral(int _paramIndex, String s, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.preparedParameterList.setLiteralParameter(_paramIndex, s, oid);
    }

    public void setObjectAtName(String parameterName, Object x, int targetSqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, targetSqlType: {2}", parameterName, x, targetSqlType);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setObject(_index, x, targetSqlType);
        }
    }

    public void setObjectAtName(String parameterName, Object input, int targetSqlType, int scale) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, targetSqlType: {2}, scale: {3}", parameterName, input, targetSqlType, scale);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setObject(_index, input, targetSqlType, scale);
        }
    }

    public void setObjectAtName(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, targetSqlType: {2}", parameterName, x, targetSqlType);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setObject(_index, x, targetSqlType);
        }
    }

    public void setObjectAtName(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, targetSqlType: {2}, scaleOrLength: {3}", parameterName, x, targetSqlType, scaleOrLength);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setObject(_index, x, targetSqlType, scaleOrLength);
        }
    }

    public void setRefAtName(String parameterName, Ref x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setRef(_index, x);
        }
    }

    public void setRowIdAtName(String parameterName, RowId x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setRowId(_index, x);
        }
    }

    public void setShortAtName(String parameterName, short x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setShort(_index, x);
        }
    }

    public void setSQLXMLAtName(String parameterName, SQLXML xmlObject) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, xmlObject);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setSQLXML(_index, xmlObject);
        }
    }

    public void setStringAtName(String parameterName, String x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setString(_index, x);
        }
    }

    public void setTimeAtName(String parameterName, Time x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setTime(_index, x);
        }
    }

    public void setTimeAtName(String parameterName, Time t, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, calendar: {2}", parameterName, t, calendar);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setTime(_index, t, calendar);
        }
    }

    public void setTimestampAtName(String parameterName, Timestamp x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setTimestamp(_index, x);
        }
    }

    public void setTimestampAtName(String parameterName, Timestamp t, Calendar calendar) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, calendar: {2}", parameterName, t, calendar);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setTimestamp(_index, t, calendar);
        }
    }

    public void setUnicodeStreamAtName(String parameterName, InputStream x, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}, length: {2}", parameterName, x, length);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setUnicodeStream(_index, x, length);
        }
    }

    public void setURLAtName(String parameterName, URL x) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINE)) {
            KBLOGGER.log(Level.FINE, "parameterName: {0}, _parameter: {1}", parameterName, x);
        }
        List<Integer> _indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int _index : _indexes) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setURL(_index, x);
        }
    }
}

