/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.KBResultSetMetaData;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.Field;
import com.kingbase8.core.ServerVersion;
import com.kingbase8.jdbc.CompatibleDB;
import com.kingbase8.jdbc.FieldMetadata;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.util.GT;
import com.kingbase8.util.Gettable;
import com.kingbase8.util.GettableHashMap;
import com.kingbase8.util.JdbcBlackHole;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class KbResultSetMetaData
implements ResultSetMetaData,
KBResultSetMetaData {
    protected final BaseConnection _connection;
    protected final Field[] _fields;
    private boolean _fieldInfoFetched;

    public KbResultSetMetaData(BaseConnection _connection, Field[] _fields) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._connection = _connection;
        this._fields = _fields;
        this._fieldInfoFetched = false;
    }

    @Override
    public int getColumnCount() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._fields.length;
    }

    @Override
    public boolean isAutoIncrement(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.fetchFieldMetaData();
        Field _field = this.getField(_column);
        FieldMetadata metadata = _field.getMetadata();
        return metadata != null && metadata.autoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field _field = this.getField(_column);
        return this._connection.getTypeInfo().isCaseSensitive(_field.getOID());
    }

    @Override
    public boolean isSearchable(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    @Override
    public boolean isCurrency(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String typeName = this.getKBType(_column);
        return typeName.equals("cash") || typeName.equals("money");
    }

    @Override
    public int isNullable(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.fetchFieldMetaData();
        Field _field = this.getField(_column);
        FieldMetadata metadata = _field.getMetadata();
        return metadata == null ? 1 : metadata.nullable;
    }

    @Override
    public boolean isSigned(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field _field = this.getField(_column);
        return this._connection.getTypeInfo().isSigned(_field.getOID());
    }

    @Override
    public int getColumnDisplaySize(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field _field = this.getField(_column);
        return this._connection.getTypeInfo().getDisplaySize(_field.getOID(), _field.getMod());
    }

    @Override
    public String getColumnLabel(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field _field = this.getField(_column);
        return _field.getColumnLabel();
    }

    @Override
    public String getColumnName(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getColumnLabel(_column);
    }

    @Override
    public String getBaseColumnName(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field _field = this.getField(_column);
        if (_field.getTableOid() == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.fetchFieldMetaData();
        FieldMetadata metadata = _field.getMetadata();
        return metadata == null ? "" : metadata.columnNameStr;
    }

    @Override
    public String getSchemaName(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "";
    }

    private boolean populateFieldsWithMetadata(Gettable<FieldMetadata.Key, FieldMetadata> metadata) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean allOk = true;
        for (Field _field : this._fields) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_field.getMetadata() != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                continue;
            }
            FieldMetadata _fieldMetadata = metadata.get(new FieldMetadata.Key(_field.getTableOid(), _field.getPositionInTable()));
            if (_fieldMetadata == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                allOk = false;
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _field.setMetadata(_fieldMetadata);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._fieldInfoFetched |= allOk;
        return allOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFieldMetaData() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._fieldInfoFetched) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        if (this.populateFieldsWithMetadata(this._connection.getFieldMetadataCache())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        StringBuilder _sql = new StringBuilder("SELECT c.oid, a.attnum, a.attname, c.relname, n.nspname, a.attnotnull OR (t.typtype = 'd' AND t.typnotnull), ");
        if (this._connection.haveMinimumServerVersion(ServerVersion.v10)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql.append("a.attidentity != ");
            if ("on".equalsIgnoreCase(((KbConnection)this._connection).getOra_input_emptystr_isnull()) && CompatibleDB.oracle(this._connection.getCompatibleLevel())) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql.append("q'<>'");
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql.append("''");
            }
            _sql.append(" OR PG_CATALOG.PG_get_expr(d.adbin, d.adrelid) LIKE '%nextval(%' ");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql.append("PG_CATALOG.PG_get_expr(d.adbin, d.adrelid) LIKE '%nextval(%' ");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql.append(",strpos(array_to_string(a.attoptions,','),'column_id=null') ");
        _sql.append("FROM PG_CATALOG.PG_class c JOIN PG_CATALOG.PG_namespace n ON (c.relnamespace = n.oid) JOIN PG_CATALOG.PG_attribute a ON (c.oid = a.attrelid) JOIN PG_CATALOG.PG_type t ON (a.atttypid = t.oid) LEFT JOIN PG_CATALOG.PG_attrdef d ON (d.adrelid = a.attrelid AND d.adnum = a.attnum) JOIN (");
        boolean hasSourceInfo = false;
        for (Field _field : this._fields) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (_field.getMetadata() != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                continue;
            }
            if (hasSourceInfo) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql.append(" UNION ALL ");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql.append("SELECT ");
            _sql.append(_field.getTableOid());
            if (!hasSourceInfo) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql.append(" AS oid ");
            }
            _sql.append(", ");
            _sql.append(_field.getPositionInTable());
            if (!hasSourceInfo) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _sql.append(" AS attnum");
            }
            if (hasSourceInfo) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            hasSourceInfo = true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _sql.append(") val ON (c.oid = val.oid AND a.attnum = val.attnum) ");
        if (!hasSourceInfo) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._fieldInfoFetched = true;
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Statement stm = this._connection.createStatement();
        ResultSet resultSet = null;
        GettableHashMap<FieldMetadata.Key, FieldMetadata> md = new GettableHashMap<FieldMetadata.Key, FieldMetadata>();
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            resultSet = stm.executeQuery(_sql.toString());
            while (resultSet.next()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int table = (int)resultSet.getLong(1);
                int _column = (int)resultSet.getLong(2);
                String _columnName = resultSet.getString(3);
                String tablName = resultSet.getString(4);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String schemaName = resultSet.getString(5);
                int nullable = resultSet.getBoolean(6) ? 0 : 1;
                boolean autoIncrement = resultSet.getBoolean(7);
                boolean isInvisible = resultSet.getBoolean(8);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                FieldMetadata _fieldMetadata = new FieldMetadata(_columnName, tablName, schemaName, nullable, autoIncrement, isInvisible);
                FieldMetadata.Key _key = new FieldMetadata.Key(table, _column);
                md.put(_key, _fieldMetadata);
            }
        }
        catch (Throwable throwable) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            JdbcBlackHole.close(resultSet);
            JdbcBlackHole.close(stm);
            throw throwable;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        JdbcBlackHole.close(resultSet);
        JdbcBlackHole.close(stm);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.populateFieldsWithMetadata(md);
        this._connection.getFieldMetadataCache().putAll(md);
    }

    @Override
    public String getBaseSchemaName(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.fetchFieldMetaData();
        Field _field = this.getField(_column);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FieldMetadata metadata = _field.getMetadata();
        return metadata == null ? "" : metadata.schemaNameStr;
    }

    @Override
    public int getPrecision(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field _field = this.getField(_column);
        return this._connection.getTypeInfo().getPrecision(_field.getOID(), _field.getMod());
    }

    @Override
    public int getScale(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field _field = this.getField(_column);
        return this._connection.getTypeInfo().getScale(_field.getOID(), _field.getMod());
    }

    @Override
    public String getTableName(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getBaseTableName(_column);
    }

    @Override
    public String getBaseTableName(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.fetchFieldMetaData();
        Field _field = this.getField(_column);
        FieldMetadata metadata = _field.getMetadata();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return metadata == null ? "" : metadata.tableNameStr;
    }

    @Override
    public boolean isColumnInvisible(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.fetchFieldMetaData();
        Field _field = this.getField(_column);
        FieldMetadata metadata = _field.getMetadata();
        return metadata != null && metadata.isInvisible;
    }

    @Override
    public String getCatalogName(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "";
    }

    @Override
    public int getColumnType(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getSQLType(_column);
    }

    @Override
    public int getFormat(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.getField(_column).getFormat();
    }

    @Override
    public String getColumnTypeName(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String type = this.getKBType(_column);
        if (this.isAutoIncrement(_column)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if ("int4".equals(type)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return "serial";
            }
            if ("int8".equals(type)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return "bigserial";
            }
            if ("int2".equals(type)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return "smallserial";
            }
        }
        if (type.equalsIgnoreCase("interval")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this._connection.getTypeInfo().getKBTypeWithMod(this.getField(_column).getOID(), this.getField(_column).getMod());
        }
        return type;
    }

    @Override
    public boolean isReadOnly(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public boolean isWritable(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return !this.isReadOnly(_column);
    }

    @Override
    public boolean isDefinitelyWritable(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    protected Field getField(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_columnIndex < 1 || _columnIndex > this._fields.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("The _column _index is out of range: {0}, number of _columns: {1}.", _columnIndex, this._fields.length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        return this._fields[_columnIndex - 1];
    }

    protected String getKBType(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._connection.getTypeInfo().getKBType(this.getField(_columnIndex).getOID());
    }

    protected int getSQLType(int _columnIndex) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._connection.getTypeInfo().getSQLType(this.getField(_columnIndex).getOID());
    }

    @Override
    public String getColumnClassName(int _column) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Field _field = this.getField(_column);
        String _result = this._connection.getTypeInfo().getJavaClass(_field.getOID());
        if (_result != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _result;
        }
        int _sqlType = this.getSQLType(_column);
        switch (_sqlType) {
            case 2003: {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return "java.sql.Array";
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String type = this.getKBType(_column);
        if ("unknown".equals(type)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "java.lang.String";
        }
        return "java.lang.Object";
    }

    @Override
    public boolean isWrapperFor(Class<?> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return clz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clz) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (clz.isAssignableFrom(this.getClass())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return clz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clz.getName());
    }
}

