/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;

public class StreamWrapper {
    private static final int MAX_MEMORY_BUFFER_BYTES_T = 51200;
    private static final String TEMP_FILE_PREFIX = "kingbase8-kbjdbc-stream";
    private final InputStream streamT;
    private final byte[] rawdataT;
    private final int _offset;
    private final int lengthT;

    public StreamWrapper(InputStream stream, int length) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.streamT = stream;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.rawdataT = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._offset = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.lengthT = length;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public StreamWrapper(byte[] data, int _offset, int length) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.streamT = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.rawdataT = data;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._offset = _offset;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.lengthT = length;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamWrapper(InputStream stream) throws KSQLException {
        block8: {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ByteArrayOutputStream memoryOutputStream = new ByteArrayOutputStream();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int memoryLength = StreamWrapper.copyStream(stream, memoryOutputStream, 51200);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                byte[] rawdata = memoryOutputStream.toByteArray();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (memoryLength == -1) {
                    int diskLength;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    boolean jdkVersionSupport = false;
                    jdkVersionSupport = true;
                    File intermediateFile = null;
                    intermediateFile = jdkVersionSupport ? Files.createTempFile(TEMP_FILE_PREFIX, null, new FileAttribute[0]).toFile() : File.createTempFile(TEMP_FILE_PREFIX, null);
                    final File tmpFile = intermediateFile;
                    FileOutputStream diskOutputStream = new FileOutputStream(tmpFile);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    diskOutputStream.write(rawdata);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        diskLength = StreamWrapper.copyStream(stream, diskOutputStream, Integer.MAX_VALUE - rawdata.length);
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (diskLength == -1) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            throw new KSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), KSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        diskOutputStream.flush();
                    }
                    finally {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        diskOutputStream.close();
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this._offset = 0;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.lengthT = rawdata.length + diskLength;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.rawdataT = null;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.streamT = new FileInputStream(tmpFile){
                        private boolean hasClosed;
                        private int pos;
                        {
                            super(x0);
                            this.hasClosed = false;
                            this.pos = 0;
                        }

                        private void checkShouldClose_(int readResultT) throws IOException {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (readResultT == -1) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                this.close();
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            } else {
                                this.pos += readResultT;
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                if (this.pos >= StreamWrapper.this.lengthT) {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    this.close();
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                }
                            }
                        }

                        @Override
                        public int read(byte[] bytes) throws IOException {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (this.hasClosed) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                return -1;
                            }
                            int _result = super.read(bytes);
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.checkShouldClose_(_result);
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            return _result;
                        }

                        @Override
                        public int read(byte[] bytes, int off, int leng) throws IOException {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (this.hasClosed) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                return -1;
                            }
                            int _result = super.read(bytes, off, leng);
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.checkShouldClose_(_result);
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            return _result;
                        }

                        @Override
                        public void close() throws IOException {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (!this.hasClosed) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                super.close();
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                tmpFile.delete();
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                this.hasClosed = true;
                            }
                        }

                        protected void finalize() throws IOException {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.close();
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            super.finalize();
                        }
                    };
                    break block8;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.rawdataT = rawdata;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.streamT = null;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._offset = 0;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.lengthT = rawdata.length;
            }
            catch (IOException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), KSQLState.IO_ERROR, (Throwable)e);
            }
        }
    }

    public InputStream getStream() {
        if (this.streamT != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.streamT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new ByteArrayInputStream(this.rawdataT, this._offset, this.lengthT);
    }

    public int getLength() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.lengthT;
    }

    public int getOffset() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._offset;
    }

    public byte[] getBytes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.rawdataT;
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "<stream of " + this.lengthT + " _bytes>";
    }

    private static int copyStream(InputStream inputStream, OutputStream outputStream, int limit) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int totalLengthT = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] _buffer = new byte[2048];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int readLengthT = inputStream.read(_buffer);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (readLengthT > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            outputStream.write(_buffer, 0, readLengthT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if ((totalLengthT += readLengthT) >= limit) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return -1;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            readLengthT = inputStream.read(_buffer);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return totalLengthT;
    }
}

