/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.chatcompletion;

import com.azure.ai.openai.models.ChatRequestAssistantMessage;
import com.azure.ai.openai.models.ChatRequestFunctionMessage;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestToolMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.ai.openai.models.FunctionDefinition;
import com.azure.core.util.BinaryData;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.BinaryDataUtils;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.OpenAIChatCompletion;
import com.microsoft.semantickernel.aiservices.openai.chatcompletion.ParsedPrompt;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.implementation.chatcompletion.ChatPromptParseVisitor;
import com.microsoft.semantickernel.implementation.chatcompletion.ChatXMLPromptParser;
import com.microsoft.semantickernel.services.chatcompletion.AuthorRole;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenAiXMLPromptParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAiXMLPromptParser.class);

    OpenAiXMLPromptParser() {
    }

    public static ParsedPrompt parse(String rawPrompt) {
        ChatPromptParseVisitor visitor = ChatXMLPromptParser.parse((String)rawPrompt, (ChatPromptParseVisitor)new OpenAiChatPromptParseVisitor());
        return (ParsedPrompt)visitor.get();
    }

    private static ChatRequestMessage getChatRequestMessage(String role, String content) {
        try {
            AuthorRole authorRole = AuthorRole.valueOf((String)role.toUpperCase(Locale.ROOT));
            return OpenAIChatCompletion.getChatRequestMessage(authorRole, content);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Unknown author role: " + role);
            throw new SKException("Unknown author role: " + role);
        }
    }

    public static ChatRequestMessage unescapeRequest(ChatRequestMessage message) {
        if (message instanceof ChatRequestUserMessage) {
            ChatRequestUserMessage chatRequestMessage = (ChatRequestUserMessage)message;
            String content = StringEscapeUtils.unescapeXml((String)BinaryDataUtils.toString(chatRequestMessage.getContent()));
            return new ChatRequestUserMessage(content).setName(chatRequestMessage.getName());
        }
        if (message instanceof ChatRequestSystemMessage) {
            ChatRequestSystemMessage chatRequestMessage = (ChatRequestSystemMessage)message;
            String content = StringEscapeUtils.unescapeXml((String)BinaryDataUtils.toString(chatRequestMessage.getContent()));
            return new ChatRequestSystemMessage(content).setName(chatRequestMessage.getName());
        }
        if (message instanceof ChatRequestAssistantMessage) {
            ChatRequestAssistantMessage chatRequestMessage = (ChatRequestAssistantMessage)message;
            String content = StringEscapeUtils.unescapeXml((String)BinaryDataUtils.toString(chatRequestMessage.getContent()));
            return new ChatRequestAssistantMessage(content).setToolCalls(chatRequestMessage.getToolCalls()).setFunctionCall(chatRequestMessage.getFunctionCall()).setName(chatRequestMessage.getName());
        }
        if (message instanceof ChatRequestFunctionMessage) {
            ChatRequestFunctionMessage chatRequestMessage = (ChatRequestFunctionMessage)message;
            String content = StringEscapeUtils.unescapeXml((String)chatRequestMessage.getContent());
            return new ChatRequestFunctionMessage(chatRequestMessage.getName(), content);
        }
        if (message instanceof ChatRequestToolMessage) {
            ChatRequestToolMessage chatRequestMessage = (ChatRequestToolMessage)message;
            String content = StringEscapeUtils.unescapeXml((String)BinaryDataUtils.toString(chatRequestMessage.getContent()));
            return new ChatRequestToolMessage(content, chatRequestMessage.getToolCallId());
        }
        throw new SKException("Unknown message type: " + message.getClass().getSimpleName());
    }

    private static class OpenAiChatPromptParseVisitor
    implements ChatPromptParseVisitor<ParsedPrompt> {
        @Nullable
        private ParsedPrompt parsedRaw = null;
        private final List<FunctionDefinition> functionDefinitions = new ArrayList<FunctionDefinition>();
        private final List<ChatRequestMessage> messages = new ArrayList<ChatRequestMessage>();

        private OpenAiChatPromptParseVisitor() {
        }

        public ChatPromptParseVisitor<ParsedPrompt> addMessage(String role, String content) {
            this.messages.add(OpenAiXMLPromptParser.getChatRequestMessage(role, content));
            return this;
        }

        public ChatPromptParseVisitor<ParsedPrompt> addFunction(String name, @Nullable String description, @Nullable BinaryData parameters) {
            FunctionDefinition function = new FunctionDefinition(name);
            if (description != null) {
                function.setDescription(description);
            }
            if (parameters != null) {
                function.setParameters(parameters);
            }
            this.functionDefinitions.add(function);
            return this;
        }

        public boolean areMessagesEmpty() {
            return this.messages.isEmpty();
        }

        public ChatPromptParseVisitor<ParsedPrompt> fromRawPrompt(String rawPrompt) {
            ChatRequestUserMessage message = new ChatRequestUserMessage(rawPrompt);
            if (message.getName() == null) {
                message.setName(UUID.randomUUID().toString());
            }
            this.parsedRaw = new ParsedPrompt(Collections.singletonList(message), null);
            return this;
        }

        public ParsedPrompt get() {
            if (this.parsedRaw != null) {
                return this.parsedRaw;
            }
            return new ParsedPrompt(this.messages, this.functionDefinitions);
        }

        public ChatPromptParseVisitor<ParsedPrompt> reset() {
            return new OpenAiChatPromptParseVisitor();
        }
    }
}

