/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.chatcompletion.responseformat;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.microsoft.semantickernel.orchestration.responseformat.ResponseSchemaGenerator;
import java.lang.reflect.Type;

public class JacksonResponseFormatGenerator
implements ResponseSchemaGenerator {
    private final SchemaGenerator generator;

    public JacksonResponseFormatGenerator() {
        JacksonModule module = new JacksonModule();
        SchemaGeneratorConfigBuilder builder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((Module)module);
        builder.forFields().withRequiredCheck(fieldScope -> {
            JsonProperty propAnno = (JsonProperty)fieldScope.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
            JsonPropertyDescription descAnno = (JsonPropertyDescription)fieldScope.getAnnotationConsideringFieldAndGetter(JsonPropertyDescription.class);
            if (propAnno != null && descAnno != null) {
                return propAnno.required();
            }
            return true;
        });
        this.generator = new SchemaGenerator(builder.build());
    }

    public JacksonResponseFormatGenerator(SchemaGenerator generator) {
        this.generator = generator;
    }

    public String generateSchema(Class<?> clazz) {
        ObjectNode schema = this.generator.generateSchema(clazz, new Type[0]);
        JacksonResponseFormatGenerator.sanitize((ContainerNode)schema);
        return schema.toPrettyString();
    }

    private static void sanitize(ContainerNode schema) {
        block4: {
            block3: {
                if (!(schema instanceof ObjectNode)) break block3;
                ((ObjectNode)schema).remove("$schema");
                if (schema.has("type") && schema.get("type").asText().equals("object")) {
                    ((ObjectNode)schema).put("additionalProperties", false);
                }
                for (JsonNode node : (ObjectNode)schema) {
                    if (!(node instanceof ContainerNode)) continue;
                    JacksonResponseFormatGenerator.sanitize((ContainerNode)node);
                }
                break block4;
            }
            if (!(schema instanceof ArrayNode)) break block4;
            for (JsonNode node : (ArrayNode)schema) {
                if (!(node instanceof ContainerNode)) continue;
                JacksonResponseFormatGenerator.sanitize((ContainerNode)node);
            }
        }
    }
}

