/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data.vectorstorage.definition;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.semantickernel.data.vectorstorage.annotations.VectorStoreRecordData;
import com.microsoft.semantickernel.data.vectorstorage.annotations.VectorStoreRecordKey;
import com.microsoft.semantickernel.data.vectorstorage.annotations.VectorStoreRecordVector;
import com.microsoft.semantickernel.data.vectorstorage.definition.VectorStoreRecordDataField;
import com.microsoft.semantickernel.data.vectorstorage.definition.VectorStoreRecordField;
import com.microsoft.semantickernel.data.vectorstorage.definition.VectorStoreRecordKeyField;
import com.microsoft.semantickernel.data.vectorstorage.definition.VectorStoreRecordVectorField;
import com.microsoft.semantickernel.exceptions.SKException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VectorStoreRecordDefinition {
    private final VectorStoreRecordKeyField keyField;
    private final List<VectorStoreRecordDataField> dataFields;
    private final List<VectorStoreRecordVectorField> vectorFields;
    private final List<VectorStoreRecordField> nonVectorFields;
    private final List<VectorStoreRecordField> allFields;
    private final Map<String, VectorStoreRecordField> allFieldsMap;

    public VectorStoreRecordKeyField getKeyField() {
        return this.keyField;
    }

    public List<VectorStoreRecordDataField> getDataFields() {
        return this.dataFields;
    }

    public List<VectorStoreRecordVectorField> getVectorFields() {
        return this.vectorFields;
    }

    public List<VectorStoreRecordField> getAllFields() {
        return this.allFields;
    }

    public List<VectorStoreRecordField> getNonVectorFields() {
        return this.nonVectorFields;
    }

    public boolean containsField(String fieldName) {
        return this.allFieldsMap.containsKey(fieldName);
    }

    public VectorStoreRecordField getField(String fieldName) {
        if (!this.allFieldsMap.containsKey(fieldName)) {
            throw new SKException("Field not found: " + fieldName);
        }
        return this.allFieldsMap.get(fieldName);
    }

    private VectorStoreRecordDefinition(VectorStoreRecordKeyField keyField, List<VectorStoreRecordDataField> dataFields, List<VectorStoreRecordVectorField> vectorFields) {
        this.keyField = keyField;
        this.dataFields = Collections.unmodifiableList(dataFields);
        this.vectorFields = Collections.unmodifiableList(vectorFields);
        this.nonVectorFields = Collections.unmodifiableList(Stream.concat(Stream.of(keyField), dataFields.stream()).collect(Collectors.toList()));
        this.allFields = Collections.unmodifiableList(Stream.concat(this.nonVectorFields.stream(), vectorFields.stream()).collect(Collectors.toList()));
        this.allFieldsMap = Collections.unmodifiableMap(this.allFields.stream().collect(Collectors.toMap(VectorStoreRecordField::getName, p -> p)));
    }

    private static VectorStoreRecordDefinition checkFields(List<VectorStoreRecordKeyField> keyFields, List<VectorStoreRecordDataField> dataFields, List<VectorStoreRecordVectorField> vectorFields) {
        if (keyFields.size() != 1) {
            throw new IllegalArgumentException("Exactly one key field is required");
        }
        return new VectorStoreRecordDefinition(keyFields.iterator().next(), dataFields, vectorFields);
    }

    public static VectorStoreRecordDefinition fromFields(List<VectorStoreRecordField> fields) {
        List<VectorStoreRecordKeyField> keyFields = fields.stream().filter(p -> p instanceof VectorStoreRecordKeyField).map(p -> (VectorStoreRecordKeyField)p).collect(Collectors.toList());
        List<VectorStoreRecordDataField> dataFields = fields.stream().filter(p -> p instanceof VectorStoreRecordDataField).map(p -> (VectorStoreRecordDataField)p).collect(Collectors.toList());
        List<VectorStoreRecordVectorField> vectorFields = fields.stream().filter(p -> p instanceof VectorStoreRecordVectorField).map(p -> (VectorStoreRecordVectorField)p).collect(Collectors.toList());
        return VectorStoreRecordDefinition.checkFields(keyFields, dataFields, vectorFields);
    }

    public static VectorStoreRecordDefinition fromRecordClass(Class<?> recordClass) {
        ArrayList<VectorStoreRecordKeyField> keyFields = new ArrayList<VectorStoreRecordKeyField>();
        ArrayList<VectorStoreRecordDataField> dataFields = new ArrayList<VectorStoreRecordDataField>();
        ArrayList<VectorStoreRecordVectorField> vectorFields = new ArrayList<VectorStoreRecordVectorField>();
        for (Field field : recordClass.getDeclaredFields()) {
            String storageName = null;
            if (field.isAnnotationPresent(JsonProperty.class)) {
                storageName = field.getAnnotation(JsonProperty.class).value();
            }
            if (field.isAnnotationPresent(VectorStoreRecordKey.class)) {
                VectorStoreRecordKey keyAttribute = field.getAnnotation(VectorStoreRecordKey.class);
                if (storageName == null) {
                    storageName = keyAttribute.storageName().isEmpty() ? field.getName() : keyAttribute.storageName();
                }
                keyFields.add(((VectorStoreRecordKeyField.Builder)((VectorStoreRecordKeyField.Builder)((VectorStoreRecordKeyField.Builder)VectorStoreRecordKeyField.builder().withName(field.getName())).withStorageName(storageName)).withFieldType(field.getType())).build());
            }
            if (field.isAnnotationPresent(VectorStoreRecordData.class)) {
                VectorStoreRecordData dataAttribute = field.getAnnotation(VectorStoreRecordData.class);
                if (storageName == null) {
                    storageName = dataAttribute.storageName().isEmpty() ? field.getName() : dataAttribute.storageName();
                }
                dataFields.add(((VectorStoreRecordDataField.Builder)((VectorStoreRecordDataField.Builder)((VectorStoreRecordDataField.Builder)VectorStoreRecordDataField.builder().withName(field.getName())).withStorageName(storageName)).withFieldType(field.getType())).isFilterable(dataAttribute.isFilterable()).build());
            }
            if (!field.isAnnotationPresent(VectorStoreRecordVector.class)) continue;
            VectorStoreRecordVector vectorAttribute = field.getAnnotation(VectorStoreRecordVector.class);
            if (storageName == null) {
                storageName = vectorAttribute.storageName().isEmpty() ? field.getName() : vectorAttribute.storageName();
            }
            vectorFields.add(((VectorStoreRecordVectorField.Builder)((VectorStoreRecordVectorField.Builder)((VectorStoreRecordVectorField.Builder)VectorStoreRecordVectorField.builder().withName(field.getName())).withStorageName(storageName)).withFieldType(field.getType())).withDimensions(vectorAttribute.dimensions()).withIndexKind(vectorAttribute.indexKind()).withDistanceFunction(vectorAttribute.distanceFunction()).build());
        }
        return VectorStoreRecordDefinition.checkFields(keyFields, dataFields, vectorFields);
    }

    public static void validateSupportedTypes(List<VectorStoreRecordField> fields, Set<Class<?>> supportedTypes) {
        HashSet unsupportedTypes = new HashSet();
        for (VectorStoreRecordField field : fields) {
            if (supportedTypes.contains(field.getFieldType())) continue;
            unsupportedTypes.add(field.getFieldType());
        }
        if (!unsupportedTypes.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unsupported field types found in record class: %s. Supported types: %s", unsupportedTypes.stream().map(Class::getName).collect(Collectors.joining(", ")), supportedTypes.stream().map(Class::getName).collect(Collectors.joining(", "))));
        }
    }
}

