/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation;

import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.localization.SemanticKernelResources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedResourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedResourceLoader.class);

    public static String readFile(String fileName, Class<?> clazz) throws FileNotFoundException {
        return EmbeddedResourceLoader.readFile(fileName, clazz, ResourceLocation.CLASSPATH);
    }

    public static String readFile(String fileName, @Nullable Class<?> clazz, ResourceLocation ... locations) throws FileNotFoundException {
        List locationsList = Arrays.stream(locations).collect(Collectors.toList());
        Optional<String> fileContents = locationsList.stream().map(type -> {
            switch (type.ordinal()) {
                case 0: {
                    if (clazz != null) return EmbeddedResourceLoader.getResourceAsStream(fileName, clazz);
                    throw new SKException("Resource location CLASSPATH requires a class");
                }
                case 2: {
                    try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
                        String string = EmbeddedResourceLoader.readInputStream(fileName, inputStream);
                        return string;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
                case 1: {
                    return EmbeddedResourceLoader.readFileFromFileSystem(fileName);
                }
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
        if (fileContents.isPresent()) {
            return fileContents.get();
        }
        throw new FileNotFoundException("Could not find file " + fileName);
    }

    @Nullable
    static String getResourceAsStream(String fileName, Class<?> clazz) {
        String string;
        block8: {
            InputStream inputStream = clazz.getResourceAsStream(fileName);
            try {
                string = EmbeddedResourceLoader.readInputStream(fileName, inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    @Nullable
    static String readFileFromFileSystem(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            String string;
            block9: {
                InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    string = EmbeddedResourceLoader.readInputStream(fileName, inputStream);
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                inputStream.close();
            }
            return string;
        }
        return null;
    }

    @Nullable
    private static String readInputStream(String fileName, InputStream inputStream) throws FileNotFoundException {
        String string;
        if (inputStream == null) {
            throw new FileNotFoundException("File not found: " + fileName);
        }
        BufferedReader bf = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            string = bf.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    bf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.trace(MessageFormat.format(SemanticKernelResources.getString("failed.to.load.file.0"), fileName), (Throwable)e);
                return null;
            }
        }
        bf.close();
        return string;
    }

    public static enum ResourceLocation {
        CLASSPATH,
        FILESYSTEM,
        CLASSPATH_ROOT;

    }
}

