/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.bean;

import com.tongweb.starter.bean.ApplicationHome;
import com.tongweb.starter.bean.ApplicationTemp;
import com.tongweb.starter.utils.Assert;
import java.io.File;

public class SessionStoreDirectory {
    private File directory;

    File getDirectory() {
        return this.directory;
    }

    void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getValidDirectory(boolean mkdirs) {
        File dir = this.getDirectory();
        if (dir == null) {
            return new ApplicationTemp().getDir("servlet-sessions");
        }
        if (!dir.isAbsolute()) {
            dir = new File(new ApplicationHome().getDir(), dir.getPath());
        }
        if (!dir.exists() && mkdirs) {
            dir.mkdirs();
        }
        this.assertDirectory(mkdirs, dir);
        return dir;
    }

    private void assertDirectory(boolean mkdirs, File dir) {
        Assert.state(!mkdirs || dir.exists(), () -> "Session dir " + dir + " does not exist");
        Assert.state(!dir.isFile(), () -> "Session dir " + dir + " points to a file");
    }
}

