/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.config;

import com.tongweb.commons.license.DynamicLoadingListener;
import com.tongweb.commons.license.LicenseProviderFacade;
import com.tongweb.connector.AbstractProtocol;
import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.UpgradeProtocol;
import com.tongweb.connector.http11.AbstractHttp11JsseProtocol;
import com.tongweb.connector.http11.AbstractHttp11Protocol;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.core.AprLifecycleListener;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.Http2;
import com.tongweb.starter.bean.IoMode;
import com.tongweb.starter.bean.SocketConfigBean;
import com.tongweb.starter.bean.Ssl;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.bean.TongwebConfig;
import com.tongweb.starter.config.ConfigHandler;
import com.tongweb.starter.config.ContextConfigHandler;
import com.tongweb.starter.exception.WebServerException;
import com.tongweb.starter.utils.Assert;
import com.tongweb.starter.utils.CustomizeUtil;
import com.tongweb.starter.utils.DataSize;
import com.tongweb.starter.utils.PropertyMapper;
import com.tongweb.starter.utils.ResourceUtils;
import com.tongweb.starter.utils.StringUtils;
import com.tongweb.web.util.net.SSLHostConfig;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public class ConnectorConfigHandler
implements ConfigHandler {
    private static final Log log = LogFactory.getLog(ConnectorConfigHandler.class);
    private static ServletContainer tongweb;
    private static Connector connector;

    public ConnectorConfigHandler(ServletContainer tongweb) {
        ConnectorConfigHandler.tongweb = tongweb;
    }

    @Override
    public void config(TongWebProperties tongWebProperties) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Connector Config Start.");
        }
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(tongWebProperties).whenNonNull().to(this::customizeBasicValue);
        propertyMapper.from(tongWebProperties.getSsl()).whenNonNull().when(Ssl::isEnabled).to(this::customizeSsl);
        propertyMapper.from(tongWebProperties.getHttp2()).when(Http2::isEnabled).when(http2 -> tongWebProperties.getSsl().isEnabled()).to(http2 -> tongweb.getConnector().addUpgradeProtocol((UpgradeProtocol)new Http2Protocol()));
        propertyMapper.from(tongWebProperties.getCompression()).whenNonNull().to(this::customizeCompression);
        propertyMapper.from(tongWebProperties.getTongweb()).whenNonNull().to(this::customizeAllowTrace);
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Connector Config End.");
        }
    }

    private void customizeSsl(Ssl ssl) {
        ProtocolHandler handler = connector.getProtocolHandler();
        Assert.state(handler instanceof AbstractHttp11JsseProtocol, "To use SSL, the connector's protocol handler must be an AbstractHttp11JsseProtocol subclass");
        this.configureSsl((AbstractHttp11JsseProtocol)handler, ssl);
        connector.setScheme("https");
        connector.setSecure(true);
    }

    protected void configureSsl(AbstractHttp11JsseProtocol<?> protocol, Ssl ssl) {
        String ciphers;
        protocol.setSSLEnabled(true);
        protocol.setSslProtocol(ssl.getProtocol());
        this.configureSslClientAuth(protocol, ssl);
        protocol.setKeystorePass(ssl.getKeyStorePassword());
        protocol.setKeyPass(ssl.getKeyPassword());
        protocol.setKeyAlias(ssl.getKeyAlias());
        if (StringUtils.startsWithIgnoreCase(ssl.getProtocol(), "GMSSL")) {
            protocol.setSslImplementationName("com.tongweb.web.util.net.gmjsse.GMImplementation");
        }
        if (StringUtils.hasText(ciphers = StringUtils.arrayToCommaDelimitedString(ssl.getCiphers()))) {
            protocol.setCiphers(ciphers);
        }
        if (ssl.getEnabledProtocols() != null) {
            for (SSLHostConfig sslHostConfig : protocol.findSslHostConfigs()) {
                sslHostConfig.setProtocols(StringUtils.arrayToCommaDelimitedString(ssl.getEnabledProtocols()));
            }
        }
        this.configureSslKeyStore(protocol, ssl);
        this.configureSslTrustStore(protocol, ssl);
    }

    private void configureSslClientAuth(AbstractHttp11JsseProtocol<?> protocol, Ssl ssl) {
        if (ssl.getClientAuth() == Ssl.ClientAuth.NEED) {
            protocol.setClientAuth(Boolean.TRUE.toString());
        } else if (ssl.getClientAuth() == Ssl.ClientAuth.WANT) {
            protocol.setClientAuth("want");
        }
    }

    private void configureSslKeyStore(AbstractHttp11JsseProtocol<?> protocol, Ssl ssl) {
        try {
            if (StringUtils.startsWithIgnoreCase(ssl.getProtocol(), "GMSSL")) {
                protocol.setKeystoreFile(ResourceUtils.getURL(ssl.getKeyStore()).toString());
            } else {
                protocol.setKeystoreFile(ResourceUtils.getURL(ssl.getKeyStore()).toString());
            }
        }
        catch (FileNotFoundException ex) {
            throw new WebServerException("Could not load key store: " + ex.getMessage(), ex);
        }
        if (ssl.getKeyStoreType() != null) {
            protocol.setKeystoreType(ssl.getKeyStoreType());
        }
        if (ssl.getKeyStoreProvider() != null) {
            protocol.setKeystoreProvider(ssl.getKeyStoreProvider());
        }
    }

    private void configureSslTrustStore(AbstractHttp11JsseProtocol<?> protocol, Ssl ssl) {
        if (ssl.getTrustStore() != null) {
            try {
                protocol.setTruststoreFile(ResourceUtils.getURL(ssl.getTrustStore()).toString());
            }
            catch (FileNotFoundException ex) {
                throw new WebServerException("Could not load trust store: " + ex.getMessage(), ex);
            }
        }
        protocol.setTruststorePass(ssl.getTrustStorePassword());
        if (ssl.getTrustStoreType() != null) {
            protocol.setTruststoreType(ssl.getTrustStoreType());
        }
        if (ssl.getTrustStoreProvider() != null) {
            protocol.setTruststoreProvider(ssl.getTrustStoreProvider());
        }
    }

    private void customizeCompression(TongWebProperties.Compression compression) {
        if (compression.getEnabled()) {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setCompression("on");
                protocol.setCompressionMinSize(compression.getMinResponseSize());
                protocol.setCompressibleMimeType(CustomizeUtil.arrayToCommaDelimitedString(compression.getMimeTypes()));
                if (compression.getExcludedUserAgents() != null) {
                    protocol.setNoCompressionUserAgents(CustomizeUtil.arrayToCommaDelimitedString(compression.getExcludedUserAgents()));
                }
            }
            for (UpgradeProtocol upgradeProtocol : connector.findUpgradeProtocols()) {
                if (!(upgradeProtocol instanceof Http2Protocol)) continue;
                Http2Protocol protocol = (Http2Protocol)upgradeProtocol;
                protocol.setCompression("on");
                protocol.setCompressionMinSize(compression.getMinResponseSize());
                protocol.setCompressibleMimeType(CustomizeUtil.arrayToCommaDelimitedString(compression.getMimeTypes()));
                if (compression.getExcludedUserAgents() == null) continue;
                protocol.setNoCompressionUserAgents(CustomizeUtil.arrayToCommaDelimitedString(compression.getExcludedUserAgents()));
            }
        }
    }

    private void customizeAllowTrace(TongwebConfig tongwebConfig) {
        List<String> notAllowHttpMethods = tongwebConfig.getNotAllowHttpMethods();
        if (notAllowHttpMethods.contains("TRACE") || notAllowHttpMethods.contains("trace") || !tongwebConfig.getAllowTrace().booleanValue()) {
            connector.setAllowTrace(false);
        } else {
            connector.setAllowTrace(true);
        }
    }

    private void customizeBasicValue(TongWebProperties tongWebProperties) {
        TongwebConfig tongwebConfig = tongWebProperties.getTongweb();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(tongWebProperties.getTongweb().getIoMode()).whenNonNull().as(IoMode::getClassName).to(this::customizeIoMode);
        map.from(tongWebProperties.getPort()).asInt(integer -> integer >= 0 ? integer : 0).to(arg_0 -> ((Connector)connector).setPort(arg_0));
        map.from(tongWebProperties::getServerHeader).when(StringUtils::hasText).to(serverHeader -> connector.setAttribute("server", serverHeader));
        map.from(tongwebConfig.getUriEncoding()).whenNonNull().to(uri -> connector.setURIEncoding(uri.name()));
        map.from(tongWebProperties.getAddress()).whenNonNull().to(this::customizeProtocolAddress);
        connector.setProperty("bindOnInit", "false");
        map.from(tongwebConfig.getUriEncoding()).whenNonNull().to(uriEncoding -> connector.setURIEncoding(uriEncoding.name()));
        map.from(tongWebProperties.getTongweb().getMaxHttpPostSize()).whenNonNull().as(DataSize::parse).asInt(DataSize::toBytes).when(this::isPositive).to(arg_0 -> ((Connector)connector).setMaxPostSize(arg_0));
        map.from(tongwebConfig.getMaxParameterCount()).when(maxParameterCount -> maxParameterCount != 0).to(arg_0 -> ((Connector)connector).setMaxParameterCount(arg_0));
        map.from(tongwebConfig.getEnableLookups()).whenNonNull().to(arg_0 -> ((Connector)connector).setEnableLookups(arg_0));
        map.from(tongwebConfig.getAsyncTimeout()).whenNonNull().to(arg_0 -> ((Connector)connector).setAsyncTimeout(arg_0));
        map.from(tongwebConfig.getDiscardFacades()).whenNonNull().to(arg_0 -> ((Connector)connector).setDiscardFacades(arg_0));
        map.from(tongwebConfig.getEncodedSolidusHandling()).whenNonNull().to(arg_0 -> ((Connector)connector).setEncodedSolidusHandling(arg_0));
        map.from(tongwebConfig.getMaxCookieCount()).whenNonNull().to(arg_0 -> ((Connector)connector).setMaxCookieCount(arg_0));
        map.from(tongwebConfig.getThrowOnFailure()).whenNonNull().to(arg_0 -> ((Connector)connector).setThrowOnFailure(arg_0));
        map.from(tongwebConfig.getRelaxedPathChars()).whenNonNull().to(relaxedPathChars -> connector.setAttribute("relaxedPathChars", relaxedPathChars));
        map.from(tongwebConfig.getRelaxedQueryChars()).whenNonNull().to(relaxedQueryChars -> connector.setAttribute("relaxedQueryChars", relaxedQueryChars));
        map.from(tongwebConfig::getMaxParameterCount).whenNonNull().when(maxParameterCount -> maxParameterCount != 0).to(this::customizeMaxParameterCount);
        map.from(tongwebConfig::getEnableLookups).whenNonNull().to(this::customizeEnableLookups);
        map.from(tongwebConfig::getAsyncTimeout).whenNonNull().to(this::customizeAsyncTimeout);
        map.from(tongwebConfig::getDiscardFacades).whenNonNull().to(this::customizeDiscardFacades);
        map.from(tongwebConfig::getEncodedSolidusHandling).whenNonNull().to(this::customizeEncodedSolidusHandling);
        map.from(tongwebConfig::getMaxCookieCount).whenNonNull().to(this::customizeMaxCookieCount);
        map.from(tongwebConfig::getThrowOnFailure).whenNonNull().to(this::customizeThrowOnFailure);
        map.from(tongwebConfig::getSocket).to(this::customizeSocket);
    }

    private void customizeIoMode(String protocol) {
        Assert.hasLength(protocol, "Protocol must not be empty");
        if (protocol.equalsIgnoreCase(IoMode.APR.getClassName())) {
            AprLifecycleListener arpLifecycle = new AprLifecycleListener();
            ContextConfigHandler.addContextLifecycleListeners((LifecycleListener)arpLifecycle);
        }
        connector = new Connector(protocol);
        tongweb.getService().addConnector(connector);
    }

    private void customizeProtocolAddress(String address) {
        if (tongweb.getConnector().getProtocolHandler() instanceof AbstractProtocol) {
            try {
                ((AbstractProtocol)tongweb.getConnector().getProtocolHandler()).setAddress(InetAddress.getByName(address));
            }
            catch (UnknownHostException e) {
                log.warn((Object)("Customize Protocol Address failed by param [" + address + "]"), (Throwable)e);
            }
        }
    }

    private void customizeMaxHttpPostSize(int maxHttpPostSize) {
        connector.setMaxPostSize(maxHttpPostSize);
    }

    private void customizeMaxParameterCount(int maxParameterCount) {
        connector.setMaxParameterCount(maxParameterCount);
    }

    private void customizeEnableLookups(boolean enableLookups) {
        connector.setEnableLookups(enableLookups);
    }

    private void customizeAsyncTimeout(Long asyncTimeout) {
        connector.setAsyncTimeout((long)asyncTimeout.intValue());
    }

    private void customizeDiscardFacades(Boolean discardFacades) {
        connector.setDiscardFacades(discardFacades.booleanValue());
    }

    private void customizeEncodedSolidusHandling(String encodedSolidusHandling) {
        connector.setEncodedSolidusHandling(encodedSolidusHandling);
    }

    private void customizeMaxCookieCount(Integer maxCookieCount) {
        connector.setMaxCookieCount(maxCookieCount.intValue());
    }

    private void customizeThrowOnFailure(Boolean throwOnFailure) {
        connector.setThrowOnFailure(throwOnFailure.booleanValue());
    }

    private void customizeSocket(SocketConfigBean socket) {
        if (socket.getDirectBuffer() != null) {
            connector.setProperty("socket.directBuffer", socket.getDirectBuffer().toString());
        }
        if (socket.getDirectSslBuffer() != null) {
            connector.setProperty("socket.directSslBuffer", socket.getDirectSslBuffer().toString());
        }
        if (socket.getRxBufSize() != null) {
            connector.setProperty("socket.rxBufSize", socket.getRxBufSize().toString());
        }
        if (socket.getTxBufSize() != null) {
            connector.setProperty("socket.txBufSize", socket.getTxBufSize().toString());
        }
        if (socket.getAppReadBufSize() != null) {
            connector.setProperty("socket.appReadBufSize", socket.getAppReadBufSize().toString());
        }
        if (socket.getAppWriteBufSize() != null) {
            connector.setProperty("socket.appWriteBufSize", socket.getAppWriteBufSize().toString());
        }
        if (socket.getBufferPool() != null) {
            connector.setProperty("socket.bufferPool", socket.getBufferPool().toString());
        }
        if (socket.getBufferPoolSize() != null) {
            connector.setProperty("socket.bufferPoolSize", socket.getBufferPoolSize().toString());
        }
        if (socket.getProcessorCache() != null) {
            connector.setProperty("socket.processorCache", socket.getProcessorCache().toString());
        }
        if (socket.getKeyCache() != null) {
            connector.setProperty("socket.keyCache", socket.getKeyCache().toString());
        }
        if (socket.getEventCache() != null) {
            connector.setProperty("socket.eventCache", socket.getEventCache().toString());
        }
        if (socket.getTcpNoDelay() != null) {
            connector.setProperty("socket.tcpNoDelay", socket.getTcpNoDelay().toString());
        }
        if (socket.getSoKeepAlive() != null) {
            connector.setProperty("socket.soKeepAlive", socket.getSoKeepAlive().toString());
        }
        if (socket.getOoBInline() != null) {
            connector.setProperty("socket.ooBInline", socket.getOoBInline().toString());
        }
        if (socket.getSoReuseAddress() != null) {
            connector.setProperty("socket.soReuseAddress", socket.getSoReuseAddress().toString());
        }
        if (socket.getSoLingerOn() != null) {
            connector.setProperty("socket.soLingerOn", socket.getSoLingerOn().toString());
        }
        if (socket.getSoLingerTime() != null) {
            connector.setProperty("socket.soLingerTime", socket.getSoLingerTime().toString());
        }
        if (socket.getSoTimeout() != null) {
            connector.setProperty("socket.soTimeout", socket.getSoTimeout().toString());
        }
        if (socket.getPerformanceConnectionTime() != null) {
            connector.setProperty("socket.performanceConnectionTime", socket.getPerformanceConnectionTime().toString());
        }
        if (socket.getPerformanceLatency() != null) {
            connector.setProperty("socket.performanceLatency", socket.getPerformanceLatency().toString());
        }
        if (socket.getPerformanceBandwidth() != null) {
            connector.setProperty("socket.performanceBandwidth", socket.getPerformanceBandwidth().toString());
        }
        if (socket.getUnlockTimeout() != null) {
            connector.setProperty("socket.unlockTimeout", socket.getUnlockTimeout().toString());
        }
    }

    protected static void customizeMaxThreads(final int maxThreads) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            final AbstractProtocol protocol = (AbstractProtocol)handler;
            protocol.setMaxThreads(maxThreads);
            LicenseProviderFacade.registerDynamicLoadingListener((DynamicLoadingListener)new DynamicLoadingListener(){

                public String getListenerKey() {
                    return "MaxThreads";
                }

                public void exec() {
                    if (LicenseProviderFacade.isLimitThreadsByLicense()) {
                        protocol.setMaxThreads(5);
                    } else {
                        int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)maxThreads);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Dynamic loading license file support for number of maxThreads turning. current : " + protocol.getMinSpareThreads() + " change to: " + targetThread));
                        }
                        protocol.setMaxThreads(targetThread);
                    }
                }
            });
        }
    }

    protected static void customizeMinThreads(final int minSpareThreads) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractProtocol) {
            final AbstractProtocol protocol = (AbstractProtocol)handler;
            protocol.setMinSpareThreads(minSpareThreads);
            LicenseProviderFacade.registerDynamicLoadingListener((DynamicLoadingListener)new DynamicLoadingListener(){

                public String getListenerKey() {
                    return "MinSpareThreads";
                }

                public void exec() {
                    if (LicenseProviderFacade.isLimitThreadsByLicense()) {
                        protocol.setMinSpareThreads(5);
                    } else {
                        int targetThread = LicenseProviderFacade.getLimitThreadsByLicense((int)minSpareThreads);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Dynamic loading license file support for number of minSpareThreads turning. current : " + protocol.getMinSpareThreads() + " change to: " + targetThread));
                        }
                        protocol.setMinSpareThreads(targetThread);
                    }
                }
            });
        }
    }
}

