/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.config;

import com.tongweb.container.Container;
import com.tongweb.container.Context;
import com.tongweb.container.Host;
import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Loader;
import com.tongweb.container.Manager;
import com.tongweb.container.Valve;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.WebResourceSet;
import com.tongweb.container.Wrapper;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.loader.WebappLoader;
import com.tongweb.container.session.StandardManager;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.container.webresources.DirResourceSet;
import com.tongweb.container.webresources.StandardRoot;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.CorsFilterConfig;
import com.tongweb.starter.bean.EmbededContextConfig;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.classloader.TongWebEmbedWebappClassLoader;
import com.tongweb.starter.config.ConfigHandler;
import com.tongweb.starter.config.contextcfg.DocumentRoot;
import com.tongweb.starter.config.contextcfg.ErrorPage;
import com.tongweb.starter.config.contextcfg.MimeMappings;
import com.tongweb.starter.config.contextcfg.PreCustomizeContext;
import com.tongweb.starter.config.contextcfg.StaticResourceJars;
import com.tongweb.starter.config.contextcfg.TongWebContextCustomizer;
import com.tongweb.starter.config.contextcfg.TongWebErrorPage;
import com.tongweb.starter.exception.WebServerException;
import com.tongweb.starter.utils.Assert;
import com.tongweb.starter.utils.ClassUtils;
import com.tongweb.starter.utils.StringUtils;
import com.tongweb.web.JarScanFilter;
import com.tongweb.web.util.buf.ByteChunk;
import com.tongweb.web.util.descriptor.web.FilterDef;
import com.tongweb.web.util.descriptor.web.FilterMap;
import com.tongweb.web.util.descriptor.web.SecurityCollection;
import com.tongweb.web.util.descriptor.web.SecurityConstraint;
import com.tongweb.web.util.scan.StandardJarScanFilter;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;

public class ContextConfigHandler
implements ConfigHandler {
    private static final Log log = LogFactory.getLog(ContextConfigHandler.class);
    private static List<LifecycleListener> contextLifecycleListeners = new ArrayList<LifecycleListener>();
    private static List<Valve> contextValves = new ArrayList<Valve>();
    private Set<TongWebContextCustomizer> tongWebContextCustomizers = new LinkedHashSet<TongWebContextCustomizer>();
    private ServletContainer servletContainer;
    private TongWebProperties tongWebProperties;
    private final DocumentRoot documentRoot = new DocumentRoot(log);
    private Set<ErrorPage> errorPages = new LinkedHashSet<ErrorPage>();
    private Map<Locale, Charset> localeCharsetMappings = new HashMap<Locale, Charset>();
    private MimeMappings mimeMappings = new MimeMappings(MimeMappings.DEFAULT);
    private final StaticResourceJars staticResourceJars = new StaticResourceJars();

    public ContextConfigHandler(ServletContainer servletContainer) {
        this.servletContainer = servletContainer;
    }

    @Override
    public void config(TongWebProperties tongWebProperties) {
        this.tongWebProperties = tongWebProperties;
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Context Config Start.");
        }
        this.prepareContext();
        this.configureWebApps(this.servletContainer);
        this.configureWar(this.servletContainer);
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Context Config End.");
        }
    }

    public static void addContextLifecycleListeners(LifecycleListener listener) {
        Assert.notNull(contextLifecycleListeners, "ContextLifecycleListeners must not be null");
        contextLifecycleListeners.add(listener);
    }

    public static void addContextValves(Valve ... valves) {
        Assert.notNull((Object)valves, "Valves must not be null");
        contextValves.addAll(Arrays.asList(valves));
    }

    public void addContextCustomizers(TongWebContextCustomizer ... tongWebContextCustomizers) {
        Assert.notNull((Object)tongWebContextCustomizers, "TongwebContextCustomizers must not be null");
        this.tongWebContextCustomizers.addAll(Arrays.asList(tongWebContextCustomizers));
    }

    public void addErrorPages(ErrorPage ... errorPages) {
        Assert.notNull((Object)errorPages, "ErrorPages must not be null");
        this.errorPages.addAll(Arrays.asList(errorPages));
    }

    public void setMimeMappings(MimeMappings mimeMappings) {
        this.mimeMappings = new MimeMappings(mimeMappings);
    }

    private void addLocaleMappings(Context context) {
        for (Map.Entry<Locale, Charset> entry : this.getLocaleCharsetMappings().entrySet()) {
            Locale locale = entry.getKey();
            Charset charset = entry.getValue();
            context.addLocaleEncodingMappingParameter(locale.toString(), charset.toString());
        }
    }

    public Map<Locale, Charset> getLocaleCharsetMappings() {
        return this.localeCharsetMappings;
    }

    public void setLocaleCharsetMappings(Map<Locale, Charset> localeCharsetMappings) {
        Assert.notNull(localeCharsetMappings, "localeCharsetMappings must not be null");
        this.localeCharsetMappings = localeCharsetMappings;
    }

    public MimeMappings getMimeMappings() {
        return this.mimeMappings;
    }

    private void prepareContext() {
        new PreCustomizeContext(this, this.tongWebProperties).customize();
        String contextPath = "";
        if (StringUtils.hasText(this.tongWebProperties.getContextPath())) {
            contextPath = this.tongWebProperties.getContextPath();
        }
        Host host = this.servletContainer.getHost();
        File documentRoot = this.getValidDocumentRoot();
        File docBase = documentRoot != null ? documentRoot : this.createTempDir("tongweb-docbase");
        Context context = this.servletContainer.addWebapp(host, contextPath, docBase.getAbsolutePath(), (LifecycleListener)new EmbededContextConfig());
        context.setName(contextPath);
        context.setDisplayName(this.tongWebProperties.getApplicationDisplayName());
        String path = this.tongWebProperties.getContextPath();
        if (path == null) {
            path = "";
        }
        context.setPath(path);
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener((LifecycleListener)new ServletContainer.FixContextListener());
        context.setParentClassLoader(ClassUtils.getDefaultClassLoader());
        this.resetDefaultLocaleMapping(context);
        this.addLocaleMappings(context);
        context.setUseRelativeRedirects(false);
        this.configureTldSkipPatterns(context);
        WebappLoader loader = new WebappLoader(context.getParentClassLoader());
        loader.setLoaderClass(TongWebEmbedWebappClassLoader.class.getName());
        loader.setDelegate(true);
        context.setLoader((Loader)loader);
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet(context);
            this.addJasperInitializer(context);
        }
        context.addLifecycleListener((LifecycleListener)new StaticResourceConfigurer(context));
        context.addLifecycleListener((LifecycleListener)new WebXmlMountListener());
        context.addLifecycleListener((LifecycleListener)new WebClassResourcesListener());
        context.setReloadable(false);
        this.configureContext(context);
        this.postProcessContext(context);
        this.customizeCors(context, this.tongWebProperties.getTongweb().getFilter().getCors());
    }

    private void customizeCors(Context context, CorsFilterConfig filter) {
        if (filter.isEnabled()) {
            String exposedHeaders;
            String allowedHeaders;
            String allowedMethods;
            FilterDef corsFilterDef = new FilterDef();
            corsFilterDef.setFilterName("TongWebCORSFilter");
            corsFilterDef.setFilterClass("com.tongweb.container.filters.CorsFilter");
            corsFilterDef.addInitParameter("cors.support.credentials", String.valueOf(filter.isSupportCredentials()));
            String allowedOrigins = filter.getAllowedOrigins();
            if (allowedOrigins != null && allowedOrigins.length() != 0) {
                corsFilterDef.addInitParameter("cors.allowed.origins", allowedOrigins);
            }
            if ((allowedMethods = filter.getAllowedMethods()) != null && allowedMethods.length() != 0) {
                corsFilterDef.addInitParameter("cors.allowed.methods", allowedMethods);
            }
            if ((allowedHeaders = filter.getAllowedHeaders()) != null && allowedHeaders.length() != 0) {
                corsFilterDef.addInitParameter("cors.allowed.headers", allowedHeaders);
            }
            if ((exposedHeaders = filter.getExposedHeaders()) != null && exposedHeaders.length() != 0) {
                corsFilterDef.addInitParameter("cors.exposed.headers", exposedHeaders);
            }
            String preflightMaxAge = filter.getPreflightMaxAge();
            if (exposedHeaders != null && exposedHeaders.length() != 0) {
                corsFilterDef.addInitParameter("cors.preflight.maxage", preflightMaxAge);
            }
            context.addFilterDef(corsFilterDef);
            FilterMap corsFilterMap = new FilterMap();
            corsFilterMap.setFilterName("TongWebCORSFilter");
            String urlPatterns = filter.getUrlPatterns();
            if (urlPatterns == null || urlPatterns.length() == 0) {
                corsFilterMap.addURLPattern("/*");
            } else {
                corsFilterMap.addURLPattern(urlPatterns);
            }
            context.addFilterMap(corsFilterMap);
        }
    }

    public void configureWebApps(ServletContainer servletContainer) {
        Map<String, String> webApps = this.tongWebProperties.getTongweb().getWebApp();
        if (webApps != null) {
            webApps.forEach((key, value) -> {
                new File(servletContainer.getServer().getCatalinaBase(), "webapps").mkdirs();
                Context context = servletContainer.addWebapp(key.startsWith("/") ? key : "/" + key, value);
                context.setParentClassLoader(ClassUtils.getDefaultClassLoader());
                WebappLoader loader = new WebappLoader();
                loader.setLoaderClass(TongWebEmbedWebappClassLoader.class.getName());
                if (StringUtils.hasText(this.tongWebProperties.getTongweb().getResourceCacheList())) {
                    loader.setCacheResourceNames(this.tongWebProperties.getTongweb().getResourceCacheList());
                }
                loader.setDelegate(true);
                context.setLoader((Loader)loader);
                context.addLifecycleListener((LifecycleListener)new StaticResourceConfigurer(context));
                context.setReloadable(false);
                this.resetDefaultLocaleMapping(context);
                this.addLocaleMappings(context);
                try {
                    context.setUseRelativeRedirects(false);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                for (LifecycleListener lifecycleListener : contextLifecycleListeners) {
                    context.addLifecycleListener(lifecycleListener);
                }
                for (Valve valve : contextValves) {
                    context.getPipeline().addValve(valve);
                }
                for (ErrorPage errorPage : this.getErrorPages()) {
                    new TongWebErrorPage(errorPage).addToContext(context);
                }
                for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
                    context.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
                }
                this.configureSession(context);
                this.configureResources(context);
                this.disableReferenceClearingContext(context);
                for (TongWebContextCustomizer customizer : this.tongWebContextCustomizers) {
                    customizer.customize(context);
                }
            });
        }
    }

    public void configureWar(ServletContainer servletContainer) {
        String war = this.tongWebProperties.getTongweb().getWar();
        if (war != null && war.length() != 0) {
            new File(servletContainer.getServer().getCatalinaBase(), "webapps").mkdirs();
            Context context = servletContainer.addWebapp("", war);
            context.setParentClassLoader(ClassUtils.getDefaultClassLoader());
            WebappLoader loader = new WebappLoader();
            loader.setLoaderClass(TongWebEmbedWebappClassLoader.class.getName());
            if (StringUtils.hasText(this.tongWebProperties.getTongweb().getResourceCacheList())) {
                loader.setCacheResourceNames(this.tongWebProperties.getTongweb().getResourceCacheList());
            }
            loader.setDelegate(true);
            context.setLoader((Loader)loader);
            context.addLifecycleListener((LifecycleListener)new StaticResourceConfigurer(context));
            context.setReloadable(false);
            this.resetDefaultLocaleMapping(context);
            this.addLocaleMappings(context);
            try {
                context.setUseRelativeRedirects(false);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            for (LifecycleListener lifecycleListener : contextLifecycleListeners) {
                context.addLifecycleListener(lifecycleListener);
            }
            for (Valve valve : contextValves) {
                context.getPipeline().addValve(valve);
            }
            for (ErrorPage errorPage : this.getErrorPages()) {
                new TongWebErrorPage(errorPage).addToContext(context);
            }
            for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
                context.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
            }
            this.configureSession(context);
            this.configureResources(context);
            this.disableReferenceClearingContext(context);
            for (TongWebContextCustomizer customizer : this.tongWebContextCustomizers) {
                customizer.customize(context);
            }
        }
    }

    public Set<ErrorPage> getErrorPages() {
        return this.errorPages;
    }

    public void setErrorPages(Set<? extends ErrorPage> errorPages) {
        Assert.notNull(errorPages, "ErrorPages must not be null");
        this.errorPages = new LinkedHashSet<ErrorPage>(errorPages);
    }

    protected void configureContext(Context context) {
        for (LifecycleListener lifecycleListener : contextLifecycleListeners) {
            context.addLifecycleListener(lifecycleListener);
        }
        for (Valve valve : contextValves) {
            context.getPipeline().addValve(valve);
        }
        for (ErrorPage errorPage : this.getErrorPages()) {
            new TongWebErrorPage(errorPage).addToContext(context);
        }
        for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
            context.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
        }
        this.configureSession(context);
        this.configureResources(context);
        this.disableReferenceClearingContext(context);
        for (TongWebContextCustomizer customizer : this.tongWebContextCustomizers) {
            customizer.customize(context);
        }
        String socketClassName = this.tongWebProperties.getTongweb().getSocket().getSocketClassName();
        context.addApplicationListener(socketClassName);
    }

    private void disableReferenceClearingContext(Context context) {
        if (context instanceof StandardContext) {
            StandardContext standardContext = (StandardContext)context;
            try {
                standardContext.setClearReferencesObjectStreamClassCaches(false);
                standardContext.setClearReferencesRmiTargets(false);
                standardContext.setClearReferencesThreadLocals(false);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }

    private void configureResources(Context context) {
        WebResourceRoot resourceRoot = context.getResources();
        if (Objects.isNull(resourceRoot)) {
            resourceRoot = new StandardRoot(context);
        }
        resourceRoot.setCachingAllowed(this.tongWebProperties.getTongweb().getResource().isAllowCaching());
        resourceRoot.setCacheObjectMaxSize(this.tongWebProperties.getTongweb().getResource().getCacheObjectMaxSize().intValue());
        resourceRoot.setCacheMaxSize(this.tongWebProperties.getTongweb().getResource().getCacheMaxSize().longValue());
        resourceRoot.setCacheTtl(this.tongWebProperties.getTongweb().getResource().getCacheTtl());
        context.setResources(resourceRoot);
    }

    private void configureSession(Context context) {
        long sessionTimeout = this.getSessionTimeoutInMinutes();
        context.setSessionTimeout((int)sessionTimeout);
        if (this.tongWebProperties.getServlet().getSession().isPersistent()) {
            Manager manager = context.getManager();
            if (manager == null) {
                manager = new StandardManager();
                context.setManager(manager);
            }
            this.configurePersistSession(manager);
        } else {
            context.addLifecycleListener((LifecycleListener)new DisablePersistSessionListener());
        }
    }

    private long getSessionTimeoutInMinutes() {
        Duration sessionTimeout = this.tongWebProperties.getServlet().getSession().getTimeout();
        if (this.isZeroOrLess(sessionTimeout)) {
            return 0L;
        }
        return Math.max(sessionTimeout.toMinutes(), 1L);
    }

    protected final File getValidSessionStoreDir() {
        return this.getValidSessionStoreDir(true);
    }

    protected final File getValidSessionStoreDir(boolean mkdirs) {
        return this.tongWebProperties.getServlet().getSession().getSessionStoreDirectory().getValidDirectory(mkdirs);
    }

    public void setDocumentRoot(File documentRoot) {
        this.documentRoot.setDirectory(documentRoot);
    }

    private boolean isZeroOrLess(Duration sessionTimeout) {
        return sessionTimeout == null || sessionTimeout.isNegative() || sessionTimeout.isZero();
    }

    private void configurePersistSession(Manager manager) {
        Assert.state(manager instanceof StandardManager, () -> "Unable to persist HTTP session state using manager type " + manager.getClass().getName());
        File dir = this.getValidSessionStoreDir();
        File file = new File(dir, "SESSIONS.ser");
        ((StandardManager)manager).setPathname(file.getAbsolutePath());
    }

    protected void postProcessContext(Context context) {
        this.allowHttpMethods(context);
    }

    private void allowHttpMethods(Context context) {
        if (!this.tongWebProperties.getTongweb().getNotAllowHttpMethods().isEmpty()) {
            SecurityConstraint constraint = new SecurityConstraint();
            constraint.setUserConstraint("CONFIDENTIAL");
            SecurityCollection securityCollection = new SecurityCollection();
            securityCollection.addPattern("/*");
            for (String httpMethod : this.tongWebProperties.getTongweb().getNotAllowHttpMethods()) {
                securityCollection.addMethod(httpMethod);
            }
            constraint.setAuthConstraint(true);
            constraint.addCollection(securityCollection);
            SecurityConstraint constraint2 = new SecurityConstraint();
            constraint2.setUserConstraint("NONE");
            SecurityCollection securityCollection2 = new SecurityCollection();
            securityCollection2.addPattern("/*");
            constraint2.addCollection(securityCollection2);
            context.addConstraint(constraint);
            context.addConstraint(constraint2);
        }
    }

    protected final File getValidDocumentRoot() {
        return this.documentRoot.getValidDirectory();
    }

    protected final File createTempDir(String prefix) {
        try {
            File tempDir = File.createTempFile(prefix + ".", "." + this.tongWebProperties.getPort());
            tempDir.delete();
            tempDir.mkdir();
            tempDir.deleteOnExit();
            return tempDir;
        }
        catch (IOException ex) {
            throw new WebServerException("Unable to create tempDir. java.io.tmpdir is set to " + System.getProperty("java.io.tmpdir"), ex);
        }
    }

    private void resetDefaultLocaleMapping(Context context) {
        context.addLocaleEncodingMappingParameter(Locale.ENGLISH.toString(), ByteChunk.DEFAULT_CHARSET.displayName());
        context.addLocaleEncodingMappingParameter(Locale.FRENCH.toString(), ByteChunk.DEFAULT_CHARSET.displayName());
    }

    private void configureTldSkipPatterns(Context context) {
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip(StringUtils.collectionToCommaDelimitedString(this.tongWebProperties.getTongweb().getAdditionalTldSkipPatterns()));
        context.getJarScanner().setJarScanFilter((JarScanFilter)filter);
    }

    private void addDefaultServlet(Context context) {
        Wrapper defaultServlet = context.createWrapper();
        defaultServlet.setName("default");
        defaultServlet.setServletClass("com.tongweb.container.servlets.DefaultServlet");
        defaultServlet.addInitParameter("debug", "0");
        defaultServlet.addInitParameter("listings", "false");
        defaultServlet.setLoadOnStartup(1);
        defaultServlet.setOverridable(true);
        context.addChild((Container)defaultServlet);
        context.addServletMappingDecoded("/", "default");
    }

    protected boolean shouldRegisterJspServlet() {
        this.tongWebProperties.getServlet().getJsp().setClassName("com.tongweb.jasper.servlet.JspServlet");
        return this.tongWebProperties.getServlet().getJsp() != null && this.tongWebProperties.getServlet().getJsp().getRegistered() && ClassUtils.isPresent(this.tongWebProperties.getServlet().getJsp().getClassName(), this.getClass().getClassLoader());
    }

    private void addJspServlet(Context context) {
        Wrapper jspServlet = context.createWrapper();
        jspServlet.setName("jsp");
        jspServlet.setServletClass(this.tongWebProperties.getServlet().getJsp().getClassName());
        jspServlet.addInitParameter("fork", "false");
        for (Map.Entry<String, String> initParameter : this.tongWebProperties.getServlet().getJsp().getInitParameters().entrySet()) {
            jspServlet.addInitParameter(initParameter.getKey(), initParameter.getValue());
        }
        jspServlet.setLoadOnStartup(3);
        context.addChild((Container)jspServlet);
        context.addServletMappingDecoded("*.jsp", "jsp");
        context.addServletMappingDecoded("*.jspx", "jsp");
    }

    private void addJasperInitializer(Context context) {
        try {
            ServletContainerInitializer initializer = (ServletContainerInitializer)ClassUtils.forName("com.tongweb.jasper.servlet.JasperInitializer", null).newInstance();
            context.addServletContainerInitializer(initializer, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File getJarFileDocumentRoot() {
        return this.getArchiveFileDocumentRoot(".jar");
    }

    private File getArchiveFileDocumentRoot(String extension) {
        File file = this.getCodeSourceArchive();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Code archive: " + file));
        }
        if (file != null && file.exists() && !file.isDirectory() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(extension)) {
            return file.getAbsoluteFile();
        }
        return null;
    }

    private File getCodeSourceArchive() {
        return this.getCodeSourceArchive(this.getClass().getProtectionDomain().getCodeSource());
    }

    File getCodeSourceArchive(CodeSource codeSource) {
        try {
            URL location;
            URL uRL = location = codeSource != null ? codeSource.getLocation() : null;
            if (location == null) {
                return null;
            }
            URLConnection connection = location.openConnection();
            String path = connection instanceof JarURLConnection ? ((JarURLConnection)connection).getJarFile().getName() : location.toURI().getPath();
            int index = path.indexOf("!/");
            if (index != -1) {
                path = path.substring(0, index);
            }
            return new File(path);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected final List<URL> getUrlsOfJarsWithMetaInfResources() {
        return this.staticResourceJars.getUrls();
    }

    private static class WebClassResourcesListener
    implements LifecycleListener {
        private WebClassResourcesListener() {
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("before_start")) {
                File additionWebInfClasses;
                File fileBase;
                Context context = (Context)event.getLifecycle();
                WebResourceRoot resources = context.getResources();
                if (resources == null) {
                    resources = new StandardRoot(context);
                    context.setResources(resources);
                }
                if ((fileBase = new File((additionWebInfClasses = new File("target/classes")).getAbsolutePath(), "/")).isDirectory()) {
                    DirResourceSet resourceSet = new DirResourceSet(resources, "/WEB-INF/classes", additionWebInfClasses.getAbsolutePath(), "/");
                    resources.addPreResources((WebResourceSet)resourceSet);
                } else {
                    additionWebInfClasses = new File("classes");
                    fileBase = new File(additionWebInfClasses.getAbsolutePath(), "/");
                    if (fileBase.isDirectory()) {
                        DirResourceSet resourceSet = new DirResourceSet(resources, "/WEB-INF/classes", additionWebInfClasses.getAbsolutePath(), "/");
                        resources.addPreResources((WebResourceSet)resourceSet);
                    }
                }
                context.setResources(resources);
            }
        }
    }

    private static class WebXmlMountListener
    implements LifecycleListener {
        private WebXmlMountListener() {
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("before_start")) {
                URL resource;
                Context context = (Context)event.getLifecycle();
                WebResourceRoot resources = context.getResources();
                if (resources == null) {
                    resources = new StandardRoot(context);
                    context.setResources(resources);
                }
                if ((resource = context.getParentClassLoader().getResource("WEB-INF/web.xml")) != null) {
                    String webXmlUrlString = resource.toString();
                    try {
                        URL root = new URL(webXmlUrlString.substring(0, webXmlUrlString.length() - "WEB-INF/web.xml".length()));
                        resources.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/WEB-INF", root, "/WEB-INF");
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private final class StaticResourceConfigurer
    implements LifecycleListener {
        private final Context context;

        private StaticResourceConfigurer(Context context) {
            this.context = context;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("configure_start")) {
                File dir;
                this.addResourceJars(ContextConfigHandler.this.getUrlsOfJarsWithMetaInfResources());
                if (ContextConfigHandler.this.tongWebProperties.getTongweb().getJarJspEnabled().booleanValue() && (dir = ContextConfigHandler.this.getJarFileDocumentRoot()) != null && this.context.getResources() != null) {
                    this.context.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", dir.getAbsolutePath(), null, "/META-INF/resources");
                }
            }
        }

        private void addResourceJars(List<URL> resourceJarUrls) {
            for (URL url : resourceJarUrls) {
                String file = url.getPath();
                if (file.endsWith(".jar") || file.endsWith(".jar!/")) {
                    String jar = url.toString();
                    if (!jar.startsWith("jar:")) {
                        jar = "jar:" + jar + "!/";
                    }
                    this.addResourceSet(jar);
                    continue;
                }
                this.addResourceSet(url.toString());
            }
        }

        private void addResourceSet(String resource) {
            try {
                if (this.isInsideNestedJar(resource)) {
                    resource = resource.substring(0, resource.length() - 2);
                }
                URL url = new URL(resource);
                String path = "/META-INF/resources";
                this.context.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", url, path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean isInsideNestedJar(String dir) {
            return dir.indexOf("!/") < dir.lastIndexOf("!/");
        }
    }

    private static class DisablePersistSessionListener
    implements LifecycleListener {
        private DisablePersistSessionListener() {
        }

        public void lifecycleEvent(LifecycleEvent event) {
            Context context;
            Manager manager;
            if (event.getType().equals("start") && (manager = (context = (Context)event.getLifecycle()).getManager()) != null && manager instanceof StandardManager) {
                ((StandardManager)manager).setPathname(null);
            }
        }
    }
}

