/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.config;

import com.tongweb.commons.license.LicenseProviderFacade;
import com.tongweb.container.Engine;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.config.ConfigHandler;
import com.tongweb.starter.config.ConnectorConfigHandler;
import com.tongweb.starter.utils.CheckIntegrityUtil;
import com.tongweb.starter.utils.PropertyMapper;

public class LicenseConfigHandler
implements ConfigHandler {
    private static final Log log = LogFactory.getLog(LicenseConfigHandler.class);
    private ServletContainer tongweb;

    public LicenseConfigHandler(ServletContainer tongweb) {
        this.tongweb = tongweb;
    }

    @Override
    public void config(TongWebProperties tongWebProperties) {
        PropertyMapper map = PropertyMapper.get();
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb License Config Start.");
        }
        new CheckIntegrityUtil();
        PropertyMapper propertyMapper = PropertyMapper.get();
        String validType = tongWebProperties.getTongweb().getLicense().getType();
        String productVersion = "esRTevlz6wm/tpN/Cbl4CfU7xtHDelNBw/kd4O9uSO0=";
        String licensePath = tongWebProperties.getTongweb().getLicense().getPath();
        String tongwebEdition = "Embed";
        System.setProperty("server.tongweb.license.validType", validType);
        System.setProperty("server.tongweb.license.licensePath", licensePath);
        propertyMapper.from(tongWebProperties.getTongweb().getLicense().getLicenseIps()).whenHasText().to(this::putLicenseIps);
        propertyMapper.from(tongWebProperties.getTongweb().getLicense().getLicensePublicKey()).whenHasText().to(this::putPublicKey);
        this.putProductKey(productVersion);
        this.putTongwebEdition(tongwebEdition);
        if (tongWebProperties.getTongweb().getLicense().getSsl() != null) {
            propertyMapper.from(tongWebProperties.getTongweb().getLicense().isSslEnabled()).whenNonNull().to(this::pusSslEnabled);
            propertyMapper.from(tongWebProperties.getTongweb().getLicense().getSsl().getKeyStore()).whenHasText().to(this::putKeyStore);
            propertyMapper.from(tongWebProperties.getTongweb().getLicense().getSsl().getKeyStorePassword()).whenHasText().to(this::putKeyStorePassword);
            propertyMapper.from(tongWebProperties.getTongweb().getLicense().getSsl().getKeyStoreType()).whenHasText().to(this::putKeyStoreType);
            propertyMapper.from(tongWebProperties.getTongweb().getLicense().getSsl().getTrustStore()).whenHasText().to(this::putTrustStore);
            propertyMapper.from(tongWebProperties.getTongweb().getLicense().getSsl().getTrustStorePassword()).whenHasText().to(this::putTrustStorePassword);
            propertyMapper.from(tongWebProperties.getTongweb().getLicense().getSsl().getTrustStoreType()).whenHasText().to(this::putTrustStoreType);
        }
        Engine engine = this.tongweb.getEngine();
        engine.addLifecycleListener(event -> {
            if ("before_stop".equals(event.getType())) {
                LicenseProviderFacade.exit();
            }
        });
        map.from(tongWebProperties.getTongweb().getMaxThreads()).when(this::isPositive).to(ConnectorConfigHandler::customizeMaxThreads);
        map.from(tongWebProperties.getTongweb().getMinSpareThreads()).when(this::isPositive).to(ConnectorConfigHandler::customizeMinThreads);
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb License Config End.");
        }
    }

    private void putLicenseIps(String value) {
        System.setProperty("server.tongweb.license.license-ips", value);
    }

    private void putPublicKey(String value) {
        System.setProperty("server.tongweb.license.publicKey", value);
    }

    private void putProductKey(String value) {
        System.setProperty("server.tongweb.license.productKey", value);
    }

    private void putTongwebEdition(String value) {
        System.setProperty("server.tongweb.license.tongWebEdition", value);
    }

    private void pusSslEnabled(boolean value) {
        System.setProperty("server.tongweb.license.ssl.enabled", String.valueOf(value));
    }

    private void putKeyStore(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStore", value);
    }

    private void putKeyStorePassword(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStorePassword", value);
    }

    private void putKeyStoreType(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStoreType", value);
    }

    private void putTrustStore(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStore", value);
    }

    private void putTrustStorePassword(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStorePassword", value);
    }

    private void putTrustStoreType(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStoreType", value);
    }
}

