/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.config;

import com.tongweb.container.startup.ServletContainer;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.config.ConfigHandler;
import com.tongweb.starter.config.ConnectorConfigHandler;
import com.tongweb.starter.exception.WebServerException;
import com.tongweb.starter.utils.PropertyMapper;
import java.io.File;
import java.io.IOException;

public class ServerContainerHandler
implements ConfigHandler {
    private static final Log log = LogFactory.getLog(ConnectorConfigHandler.class);
    private ServletContainer tongweb;

    public ServerContainerHandler(ServletContainer tongweb) {
        this.tongweb = tongweb;
    }

    @Override
    public void config(TongWebProperties tongWebProperties) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Server Container Config Start.");
        }
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        File baseDir = tongWebProperties.getTongweb().getBasedir() != null ? tongWebProperties.getTongweb().getBasedir() : this.createTempDir("tongweb", tongWebProperties);
        this.tongweb.setBaseDir(baseDir.getAbsolutePath());
        this.tongweb.getHost().setAutoDeploy(false);
        if (log.isTraceEnabled()) {
            log.trace((Object)"TongWeb Server Container Config End.");
        }
    }

    protected final File createTempDir(String prefix, TongWebProperties tongWebProperties) {
        try {
            File tempDir = File.createTempFile(prefix + ".", "." + tongWebProperties.getPort());
            tempDir.delete();
            tempDir.mkdir();
            tempDir.deleteOnExit();
            return tempDir;
        }
        catch (IOException e) {
            throw new WebServerException("Unable to create tempDir. java.io.tmpdir is set to " + System.getProperty("java.io.tmpdir"), e);
        }
    }
}

