/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.config.contextcfg;

import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Valve;
import com.tongweb.container.core.StandardHost;
import com.tongweb.container.security.SecurityListener;
import com.tongweb.container.valves.ErrorReportValve;
import com.tongweb.container.valves.JsonErrorReportValve;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.AuditLog;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.bean.TongwebConfig;
import com.tongweb.starter.config.ContextConfigHandler;
import com.tongweb.starter.utils.PropertyMapper;
import com.tongweb.starter.utils.StringUtils;
import com.tongweb.web.util.http.CookieProcessor;
import com.tongweb.web.util.http.LegacyCookieProcessor;
import java.io.File;

public class PreCustomizeContext {
    private static final Log logger = LogFactory.getLog(PreCustomizeContext.class);
    private ContextConfigHandler contextConfigHandler;
    private TongWebProperties tongWebProperties;

    public PreCustomizeContext(ContextConfigHandler contextConfigHandler, TongWebProperties tongWebProperties) {
        this.contextConfigHandler = contextConfigHandler;
        this.tongWebProperties = tongWebProperties;
    }

    public void customize() {
        TongwebConfig tongwebConfig = this.tongWebProperties.getTongweb();
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(tongwebConfig::getAuditLog).when(AuditLog::getEnable).to(auditLog -> this.customizeAuditLog((AuditLog)auditLog));
        propertyMapper.from(tongwebConfig::getUseLegacyCookieProcessor).whenTrue().to(x -> this.customizeCookieProcessor());
        propertyMapper.from(tongwebConfig.getDocBasePath()).whenNonNull().to(docBasePath -> this.customizeDocBase((String)docBasePath));
        this.customizeSecurityListener();
        this.customizeErrorReportValve();
        if (tongwebConfig.getRedirectContextRoot() != null) {
            this.customizeRedirectContextRoot(tongwebConfig.getRedirectContextRoot());
        }
        if (tongwebConfig.getUseRelativeRedirects() != null) {
            this.customizeUseRelativeRedirects(tongwebConfig.getUseRelativeRedirects());
        }
    }

    private void customizeUseRelativeRedirects(boolean useRelativeRedirects) {
        this.contextConfigHandler.addContextCustomizers(context -> context.setUseRelativeRedirects(useRelativeRedirects));
    }

    private void customizeRedirectContextRoot(boolean redirectContextRoot) {
        this.contextConfigHandler.addContextCustomizers(context -> context.setMapperContextRootRedirectEnabled(redirectContextRoot));
    }

    private void customizeErrorReportValve() {
        block9: {
            boolean jsonErrorReportValveEnabled = this.tongWebProperties.getTongweb().getJsonErrorReportValve().isEnabled();
            if (jsonErrorReportValveEnabled) {
                String errorValveClassName = "com.tongweb.container.valves.JsonErrorReportValve";
                JsonErrorReportValve valve = new JsonErrorReportValve();
                this.contextConfigHandler.addContextCustomizers(context -> {
                    StandardHost host = (StandardHost)context.getParent();
                    host.setErrorReportValveClass(errorValveClassName);
                    host.getPipeline().addValve((Valve)valve);
                });
            } else if (this.tongWebProperties.getTongweb().getErrorReportValve().isEnabled()) {
                boolean errorReportValveShowReport = this.tongWebProperties.getTongweb().getErrorReportValve().isShowReport();
                boolean errorReportValveShowServerInfo = this.tongWebProperties.getTongweb().getErrorReportValve().isShowServerInfo();
                this.generateErrorReportValve(errorReportValveShowReport, errorReportValveShowServerInfo);
            } else if (!StringUtils.isEmpty(this.tongWebProperties.getTongweb().getCustomizedErrorReportValve().getType())) {
                String customizedErrorValveType = this.tongWebProperties.getTongweb().getCustomizedErrorReportValve().getType();
                try {
                    Object customizedErrorValveObj = Class.forName(customizedErrorValveType).getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (customizedErrorValveObj instanceof ErrorReportValve) {
                        ErrorReportValve customizedErrorValve = (ErrorReportValve)customizedErrorValveObj;
                        this.contextConfigHandler.addContextCustomizers(context -> {
                            StandardHost host = (StandardHost)context.getParent();
                            host.getPipeline().addValve((Valve)customizedErrorValve);
                        });
                        break block9;
                    }
                    logger.warn((Object)("customize valve class " + customizedErrorValveType + " is invalid , customized errorValve failed."));
                }
                catch (Throwable e) {
                    logger.warn((Object)("class " + customizedErrorValveType + " not exist. customized errorValve failed."), e);
                }
            } else {
                this.generateErrorReportValve(true, false);
            }
        }
    }

    private void generateErrorReportValve(boolean showReport, boolean showServerInfo) {
        ErrorReportValve valve = new ErrorReportValve();
        valve.setShowReport(showReport);
        valve.setShowServerInfo(showServerInfo);
        this.contextConfigHandler.addContextCustomizers(context -> {
            StandardHost host = (StandardHost)context.getParent();
            host.setErrorReportValveClass(valve.getClass().getCanonicalName());
            host.getPipeline().addValve((Valve)valve);
        });
    }

    private void customizeDocBase(String docBasePath) {
        this.contextConfigHandler.setDocumentRoot(new File(docBasePath));
        this.contextConfigHandler.addContextCustomizers(context -> context.setDocBase(docBasePath));
    }

    private void customizeCookieProcessor() {
        this.contextConfigHandler.addContextCustomizers(context -> context.setCookieProcessor((CookieProcessor)new LegacyCookieProcessor()));
    }

    private void customizeAuditLog(AuditLog auditLog) {
        auditLog.setTargetDir(this.tongWebProperties.getTongweb().getBasedir());
        ContextConfigHandler.addContextLifecycleListeners(event -> {
            if (event.getType().equalsIgnoreCase("after_start")) {
                auditLog.start();
            }
            if (event.getType().equalsIgnoreCase("before_destroy")) {
                auditLog.stop();
            }
        });
    }

    private void customizeSecurityListener() {
        boolean securityEnabled = this.tongWebProperties.getTongweb().getSecurityListener().isEnabled();
        boolean removeRootUser = this.tongWebProperties.getTongweb().getSecurityListener().isRemoveRootUser();
        String minimumUmask = this.tongWebProperties.getTongweb().getSecurityListener().getMinimumUmask();
        String checkedOsUsers = this.tongWebProperties.getTongweb().getSecurityListener().getCheckedOsUsers();
        if (securityEnabled) {
            SecurityListener securityListener = new SecurityListener();
            if (!StringUtils.isEmpty(minimumUmask)) {
                securityListener.setMinimumUmask(minimumUmask);
            }
            if (removeRootUser) {
                securityListener.setCheckedOsUsers("");
            }
            if (!StringUtils.isEmpty(checkedOsUsers)) {
                securityListener.setCheckedOsUsers(checkedOsUsers);
            }
            ContextConfigHandler.addContextLifecycleListeners((LifecycleListener)securityListener);
        }
    }
}

