/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.config.contextcfg;

import com.tongweb.container.Context;
import com.tongweb.starter.config.contextcfg.ErrorPage;
import com.tongweb.starter.utils.Assert;
import com.tongweb.starter.utils.ClassUtils;
import com.tongweb.starter.utils.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TongWebErrorPage {
    private static final String ERROR_PAGE_CLASS = "com.tongweb.web.util.descriptor.web.ErrorPage";
    private final String location;
    private final String exceptionType;
    private final int errorCode;
    private final Object nativePage;

    public TongWebErrorPage(ErrorPage errorPage) {
        this.location = errorPage.getPath();
        this.exceptionType = errorPage.getExceptionName();
        this.errorCode = errorPage.getStatusCode();
        this.nativePage = this.createNativePage();
    }

    private Object createNativePage() {
        try {
            if (ClassUtils.isPresent(ERROR_PAGE_CLASS, null)) {
                return ClassUtils.forName(ERROR_PAGE_CLASS, null).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException | LinkageError throwable) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void addToContext(Context context) {
        Assert.state(this.nativePage != null, "No ServletContainer detected so no native error page exists");
        if (ClassUtils.isPresent(ERROR_PAGE_CLASS, null)) {
            com.tongweb.web.util.descriptor.web.ErrorPage errorPage = (com.tongweb.web.util.descriptor.web.ErrorPage)this.nativePage;
            errorPage.setLocation(this.location);
            errorPage.setErrorCode(this.errorCode);
            errorPage.setExceptionType(this.exceptionType);
            context.addErrorPage(errorPage);
        } else {
            this.callMethod(this.nativePage, "setLocation", this.location, String.class);
            this.callMethod(this.nativePage, "setErrorCode", this.errorCode, Integer.TYPE);
            this.callMethod(this.nativePage, "setExceptionType", this.exceptionType, String.class);
            this.callMethod(context, "addErrorPage", this.nativePage, this.nativePage.getClass());
        }
    }

    private void callMethod(Object target, String name, Object value, Class<?> type) {
        Method method = ReflectionUtils.findMethod(target.getClass(), name, type);
        ReflectionUtils.invokeMethod(method, target, value);
    }
}

