/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.parse;

import com.tongweb.container.startup.ServletContainer;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.config.ConfigHandlerHolder;
import com.tongweb.starter.parse.utils.IOUtils;
import java.io.IOException;

public class ConfigProcessor {
    private static final Log log = LogFactory.getLog(ConfigProcessor.class);
    private String fileName;
    private ServletContainer tongweb;
    private TongWebProperties tongWebProperties;

    public ConfigProcessor() {
    }

    public ConfigProcessor(ServletContainer tongweb) {
        this.tongweb = tongweb;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void processConfig() throws IOException {
        TongWebProperties tongWebProperties = null;
        if (this.fileName.endsWith(".properties")) {
            tongWebProperties = IOUtils.processPropertiesConfig(this.fileName);
        } else if (this.fileName.endsWith(".yml") || this.fileName.endsWith(".yaml")) {
            tongWebProperties = IOUtils.processYamlConfig(this.fileName);
        }
        if (tongWebProperties == null) {
            log.error((Object)"process config file failed. system start exit");
            System.exit(0);
        }
        this.printResult(tongWebProperties);
        this.tongWebProperties = tongWebProperties;
    }

    private void printResult(TongWebProperties tongWebProperties) {
    }

    public void configComponents() throws Exception {
        ConfigHandlerHolder.configComponents(this.tongWebProperties, this.tongweb);
    }

    public void addShutdownListener() {
    }

    public void setTongweb(ServletContainer tongweb) {
        this.tongweb = tongweb;
    }
}

