/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.parse.utils;

import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.bean.TongWebProperties;
import com.tongweb.starter.parse.utils.MapBeanUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class IOUtils {
    private static final Log log = LogFactory.getLog(IOUtils.class);

    public static TongWebProperties processYamlConfig(String fileName) {
        TongWebProperties tongWebProperties = new TongWebProperties();
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Map<String, Object> obj = null;
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
            obj = IOUtils.yamlToFlattenedMap(is);
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        if (obj == null || obj.size() <= 0) {
            log.warn((Object)("parse yaml failed. yaml file path : " + fileName));
            return tongWebProperties;
        }
        try {
            tongWebProperties = IOUtils.transFormFromHashMap(obj);
        }
        catch (Exception e) {
            log.warn((Object)("transform yaml content to tongwebProperties failed . yaml file path : " + fileName));
            throw new RuntimeException(e);
        }
        return tongWebProperties;
    }

    public static Map<String, Object> yamlToFlattenedMap(InputStream yamlContent) {
        Yaml yaml = IOUtils.createYaml();
        Map<String, Object> map = new HashMap<String, Object>();
        for (Object object : yaml.loadAll(yamlContent)) {
            if (object == null) continue;
            map = IOUtils.asMap(object);
            map = IOUtils.getFlattenedMap(map);
        }
        return map;
    }

    private static Yaml createYaml() {
        return new Yaml((BaseConstructor)new SafeConstructor());
    }

    private static Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result.put("document", object);
            return result;
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            Object key;
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = IOUtils.asMap(value);
            }
            if ((key = entry.getKey()) instanceof CharSequence) {
                result.put(key.toString(), value);
                continue;
            }
            result.put("[" + key.toString() + "]", value);
        }
        return result;
    }

    private static Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        IOUtils.buildFlattenedMap(result, source, null);
        return result;
    }

    private static void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (path != null && path.length() > 0) {
                key = key.startsWith("[") ? path + key : path + '.' + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                IOUtils.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    IOUtils.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value.toString() : "");
        }
    }

    public static TongWebProperties processPropertiesConfig(String fileName) {
        Properties properties = new Properties();
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
            properties.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TongWebProperties tongWebProperties = null;
        try {
            tongWebProperties = IOUtils.transFormFromProperties(properties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tongWebProperties;
    }

    private static TongWebProperties transFormFromProperties(Properties originProperties) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(originProperties);
        return IOUtils.transFormFromHashMap(map);
    }

    private static TongWebProperties transFormFromHashMap(Map<String, Object> origin) {
        TongWebProperties tongWebProperties;
        HashMap<String, Object> removeFirstPrefixMap = new HashMap<String, Object>();
        HashMap camelCaseMap = new HashMap();
        origin.forEach((k, v) -> removeFirstPrefixMap.put(MapBeanUtil.removeFirstPrefix(k), v));
        removeFirstPrefixMap.forEach((k, v) -> camelCaseMap.put(MapBeanUtil.middleLineToCamel(k), v));
        try {
            tongWebProperties = MapBeanUtil.mapToBean(camelCaseMap, TongWebProperties.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tongWebProperties;
    }
}

