/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.parse.utils;

import com.tongweb.starter.bean.IoMode;
import com.tongweb.starter.bean.Ssl;
import com.tongweb.starter.bean.TongWebProperties;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;

public class MapBeanUtil {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");

    public static <T> T mapToBean(Map map, Class<T> beanClass) throws Exception {
        T object = beanClass.newInstance();
        MapBeanUtil.registryConvert();
        BeanUtils.populate(object, (Map)map);
        return object;
    }

    private static void registryConvert() {
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                String val = MapBeanUtil.getString(value);
                if (val == null) {
                    return null;
                }
                return Enum.valueOf(TongWebProperties.ForwardHeadersStrategy.class, val);
            }
        }, TongWebProperties.ForwardHeadersStrategy.class);
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                String val = MapBeanUtil.getString(value);
                if (val == null) {
                    return null;
                }
                return Enum.valueOf(Ssl.ClientAuth.class, val);
            }
        }, Ssl.ClientAuth.class);
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                String val = MapBeanUtil.getString(value);
                if (val == null) {
                    return null;
                }
                return Enum.valueOf(IoMode.class, val);
            }
        }, IoMode.class);
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                String valueString = String.valueOf(value);
                String[] strArr = valueString.split(",");
                List<String> list = Arrays.asList(strArr);
                return list;
            }
        }, List.class);
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                String s = String.valueOf(value);
                return Charset.forName(s);
            }
        }, Charset.class);
    }

    public static boolean isNumeric(String str) {
        return str != null && NUMBER_PATTERN.matcher(str).matches();
    }

    private static String getString(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new ConversionException("\u53ea\u80fd\u8f6c\u5316String\u7c7b\u578b");
        }
        String val = (String)value;
        if (val.trim().equals("")) {
            return null;
        }
        val = val.toUpperCase();
        return val;
    }

    private static String getStringLower(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new ConversionException("\u53ea\u80fd\u8f6c\u5316String\u7c7b\u578b");
        }
        String val = (String)value;
        if (val.trim().equals("")) {
            return null;
        }
        val = val.toLowerCase();
        return val;
    }

    private static boolean isPrimitive(Class clz) {
        if (clz.isPrimitive()) {
            return true;
        }
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> T toBean(Properties properties, Class<T> type, String prefix) throws IntrospectionException, IllegalAccessException, InstantiationException, InvocationTargetException {
        PropertyDescriptor[] propertyDescriptors;
        if (prefix == null) {
            prefix = "";
        } else if (!prefix.isEmpty() && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        type.getDeclaredFields();
        T obj = type.newInstance();
        BeanInfo bean = Introspector.getBeanInfo(type);
        for (PropertyDescriptor descriptor : propertyDescriptors = bean.getPropertyDescriptors()) {
            Class<?> fieldType = descriptor.getPropertyType();
            if (fieldType == Class.class) continue;
            if (MapBeanUtil.isPrimitive(fieldType) || fieldType == String.class) {
                BeanUtils.setProperty(obj, (String)descriptor.getName(), (Object)properties.getProperty(prefix + descriptor.getName()));
                continue;
            }
            BeanUtils.setProperty(obj, (String)descriptor.getName(), MapBeanUtil.toBean(properties, fieldType, prefix + descriptor.getName()));
        }
        return obj;
    }

    public static String camelToMiddleLine(String origin) {
        return MapBeanUtil.stringProcess(origin, (prev, c) -> {
            if (Character.isLowerCase(prev.charValue()) && Character.isUpperCase(c.charValue())) {
                return "-" + Character.toLowerCase(c.charValue());
            }
            return "" + c;
        });
    }

    public static String middleLineToCamel(String origin) {
        return MapBeanUtil.stringProcess(origin, (prev, c) -> {
            if (prev.charValue() == '-' && Character.isLowerCase(c.charValue())) {
                return "" + Character.toUpperCase(c.charValue());
            }
            if (c.charValue() == '-') {
                return "";
            }
            return "" + c;
        });
    }

    public static String removeFirstPrefix(String origin) {
        return origin.replaceFirst("server.", "");
    }

    public static String stringProcess(String origin, BiFunction<Character, Character, String> convertFunc) {
        if (origin == null || "".equals(origin.trim())) {
            return "";
        }
        String newOrigin = "0" + origin;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < newOrigin.length() - 1; ++i) {
            char prev = newOrigin.charAt(i);
            char c = newOrigin.charAt(i + 1);
            sb.append(convertFunc.apply(Character.valueOf(prev), Character.valueOf(c)));
        }
        return sb.toString();
    }
}

