/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.starter.service;

import com.tongweb.commons.license.LicenseProviderFacade;
import com.tongweb.commons.license.LicenseSDKProvider;
import com.tongweb.commons.license.bean.cfg.LicenseConfig;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.LifecycleState;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.starter.classloader.TongWebEmbedWebappClassLoader;
import com.tongweb.starter.parse.ConfigProcessor;
import com.tongweb.starter.service.TongWebStarter;
import java.io.IOException;

public class StandardTongWebStarer
implements TongWebStarter {
    private static final Log log = LogFactory.getLog(StandardTongWebStarer.class);
    private ConfigProcessor processor;
    private ServletContainer tongweb;
    private boolean alreadyConfig = false;
    private final Object monitor = new Object();

    public StandardTongWebStarer() {
        this.init();
    }

    public void setConfigFileName(String fileName) {
        this.processor.setFileName(fileName);
    }

    public void config() {
        this.configInternal();
    }

    public void start() {
        if (!this.alreadyConfig) {
            this.configInternal();
        }
        try {
            this.tongweb.start();
            this.checkThatConnectorsHaveStarted();
            this.checkLicense();
            this.tongweb.getServer().await();
        }
        catch (LifecycleException | RuntimeException e) {
            log.error((Object)"TongWeb Start Failed", e);
            this.stopTongWebSilent();
        }
    }

    private void checkThatConnectorsHaveStarted() {
        for (Connector connector : this.tongweb.getService().findConnectors()) {
            if (!LifecycleState.FAILED.equals((Object)connector.getState())) continue;
            throw new RuntimeException("TongWeb start failed");
        }
    }

    private void init() {
        this.tongweb = new ServletContainer();
        this.processor = new ConfigProcessor(this.tongweb);
    }

    private void configInternal() {
        try {
            this.processor.processConfig();
            this.processor.configComponents();
            this.processor.addShutdownListener();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.alreadyConfig = true;
    }

    private void checkLicense() {
        String validType = System.getProperty("server.tongweb.license.validType");
        String productVersion = System.getProperty("server.tongweb.license.productKey");
        String licensePath = System.getProperty("server.tongweb.license.licensePath");
        String tongwebEdition = System.getProperty("server.tongweb.license.tongWebEdition");
        if (validType.equals("remote")) {
            LicenseSDKProvider.validate();
        } else {
            LicenseConfig licenseConfig = LicenseProviderFacade.genConfig((String)productVersion, (String)licensePath, (String)tongwebEdition, (String)"TongWeb");
            LicenseProviderFacade.config((LicenseConfig)licenseConfig);
            LicenseProviderFacade.validate();
            LicenseProviderFacade.startWorker();
        }
    }

    private void stopTongWebSilent() {
        try {
            this.stopTongWeb();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    private void stopTongWeb() throws LifecycleException {
        if (Thread.currentThread().getContextClassLoader() instanceof TongWebEmbedWebappClassLoader) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        this.tongweb.stop();
        System.exit(0);
    }

    public ServletContainer getTongweb() {
        return this.tongweb;
    }
}

